/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** 
** Header file for flx_filebox.h 
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* 
** Main form structure
*/
typedef struct {

    FL_FORM *main;

    FL_OBJECT *dir_browser;
    FL_OBJECT *file_browser;

    FL_OBJECT *loc_input;
    FL_OBJECT *filter_input;
    FL_OBJECT *file_input;    

    FL_OBJECT *dot_dirs;    
    FL_OBJECT *dot_files;    

    FL_OBJECT *ok_def_b;
    FL_OBJECT *ok_b;    

    FL_OBJECT *filter_def_b;
    FL_OBJECT *filter_b;    

    FL_FORM *help;
    
    char *dir;             /* current directory    */
    char *filter;          /* current file filter  */

} FORM_S;


/* 
** This function builds the main form 
*/
static FORM_S *build_filebox(const char *directory, 
                             const char *pattern, 
                             const char *default_file);                

/* 
** Callback functions 
*/
static void DblFileCB  (FL_OBJECT *ob, long data);
static void DoneCB     (FL_OBJECT *ob, long data);
static void DoHelpCB   (FL_OBJECT *ob, long data);
static void DotfileCB  (FL_OBJECT *ob, long data);
static void DirCB      (FL_OBJECT *ob, long data);
static void FileCB     (FL_OBJECT *ob, long data);
static void FilterCB   (FL_OBJECT *ob, long data);
static void LocationCB (FL_OBJECT *ob, long data);
static void QuitCB     (FL_OBJECT *ob, long data);

/* 
** Utility functions 
*/
static void parse_dir(FORM_S *theForm);
static char *extract_filter(const char *filename, char delimiter);
static void *vmalloc(int chunk_size);
static int  change_focus(FL_OBJECT *ob, int ev, 
                         FL_Coord mx, FL_Coord my, 
                         int key, void *xev);

/* 
** GNU pattern matcher 
*/
int fnmatch (char *pattern, char *string, int flags);

 
static int have_file = 0;
