/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** NAME
**       flx_help_dialog
**
** PURPOSE
**       Creates a form that displays text and a "Dismiss" button
**
** FUNCTION PROTOTYPE
**       FL_FORM *flx_help_dialog(const char *help_text);
**
** INPUTS
**       help_text: character string of arbitrary length that may include
**                  newline characters
**
** OUTPUT
**       Pointer to the created form
**
** RESTRICTIONS
**       None
**
** MODIFICATION HISTORY
**       Written, Robert.Mallozzi@msfc.nasa.gov, September 1997
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** flx: Extensions for the xforms library
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the Free
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "forms.h"
#include "flx.h"

static void DismissCB(FL_OBJECT *ob, long data);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
FL_FORM *flx_help_dialog(const char *text)
{

    FL_FORM *helpForm;
    FL_OBJECT *obj, *browser;
    int i, numLines;
    int currentWidth, maxWidth = 0;
     

    helpForm = fl_bgn_form(FL_NO_BOX, 400, 300);
  
        obj = fl_add_box(FL_UP_BOX, 0, 0, 400, 300, "");

        browser = fl_add_browser(FL_NORMAL_BROWSER, 
            10, 10, 390, 240, "");
        fl_add_browser_line(browser, text);
        fl_set_browser_fontstyle(browser, FL_BOLD_STYLE);
        fl_set_browser_fontsize(browser, FL_NORMAL_SIZE);
        fl_set_browser_hscrollbar(browser, FL_AUTO);
        fl_set_browser_vscrollbar(browser, FL_ON);

        obj = flx_add_return_button(FL_NORMAL_BUTTON, 
            165, 260, 70, 30, "Dismiss"); 
        fl_set_object_lstyle(obj, FL_BOLD_STYLE);
        fl_set_object_callback(obj, DismissCB, 0);
        fl_set_form_hotobject(helpForm, obj);
        obj->u_vdata = (void *) helpForm; 
 
    fl_end_form();

    numLines = fl_get_browser_maxline(browser);
    for (i = 1; i <= numLines; i++) {

        currentWidth = fl_get_string_width(FL_BOLD_STYLE, FL_NORMAL_SIZE, 
           fl_get_browser_line(browser, i), 
           strlen(fl_get_browser_line(browser, i)));

        if (maxWidth < currentWidth)
           maxWidth = currentWidth;

    }
    
    currentWidth = maxWidth + (0.10 * maxWidth);
    
    fl_set_form_size(helpForm, currentWidth + 20, 300);
    
    fl_set_object_geometry(browser, 
           10, 10, currentWidth, 235);
    
    flx_scale_form(helpForm);
    
    
    return (helpForm);    
    
    
} /* end function flx_help_dialog() */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
void DismissCB(FL_OBJECT *ob, long data)
{
    FL_FORM *helpForm = (FL_FORM *) ob->u_vdata;
 
    
    if (fl_form_is_visible(helpForm))
       fl_hide_form(helpForm);

}
