/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**+
** NAME
**      flx_show_input
**
** PURPOSE
**     Popup dialogs to replace some of the xforms goodies.
**     Retrieves a string from user.
**
** CALLING SEQUENCE
**     result = flx_show_input (type, "message_string", "initial_value");
**
**     result (char *): pointer to the input string. 
**     type (int): One of the input types supported by xforms 
**        (FL_NORMAL_INPUT, FL_INT_INPUT, etc)
**     message_string (const char *): prompt string
**     initial (const char *): initial value in the input box  
**
**     Dialog attributes can be set by calling any of the following functions
**          before the call to fl_show_input()
**
**          void flx_set_dialog_lcol (int theLabelColor);
**          void flx_set_dialog_font (int theLabelStyle, int theLabelSize);
**          void flx_set_dialog_color (int theInactiveColor, int theActiveColor);
**          void flx_set_dialog_bgcolor (int theBgColor);
**         
** MODIFICATION HISTORY
**     Written, Robert.Mallozzi@msfc.nasa.gov, January 1998
**                         
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** flx: Extensions for the xforms library
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the Free
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#include "forms.h"
#include "question.xpm"

extern int FLX_DIALOG_ICOLOR;
extern int FLX_DIALOG_ACOLOR;
extern int FLX_DIALOG_BGCOLOR;
extern int FLX_DIALOG_LCOL;
extern int FLX_DIALOG_LSTYLE;
extern int FLX_DIALOG_LSIZE;

void flx_set_dialog_lcol();
void flx_set_dialog_font();
void flx_set_dialog_color();
void flx_set_dialog_bgcolor();

 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
char *flx_show_input (int type, const char *message_str, const char *initial)
{

    FL_FORM *main_form;  
    FL_OBJECT *obj, *obj_input, *ret;

    int button_width  = 70;
    int button_height = 25;
    int min_x         = 180;
    int min_y         = 120;
    int pad           = 10;
    int pm_width      = 50;
    int pm_height     = 50;
                    
    int label_width, label_height;
    int button_label_width, button_label_height;
    int status = 0;
    int form_x, form_y, yoffset, ymax_height;
    char **discriminator;

 
    discriminator = question_xpm;


    /* Get the string sizes, then size the form */

    /* The main label */
    fl_get_string_dimension (FLX_DIALOG_LSTYLE, FLX_DIALOG_LSIZE,
        message_str, strlen(message_str), 
        &label_width, &label_height);

    form_x = pm_width + pad + label_width + pad;
    if (form_x < min_x)
       form_x = min_x;
    
    if (label_height <= pm_height)
       ymax_height = pm_height;
    else
       ymax_height = label_height;
       
    form_y = ymax_height + pad + 10 + pad + button_height + pad; 
    if (form_y < min_y)
       form_y = min_y;

    yoffset = form_y - min_y;
    
   
    main_form = fl_bgn_form(FL_NO_BOX, form_x, form_y);

        obj = fl_add_box(FL_UP_BOX, 
            0, 0, form_x, form_y, "");
        fl_set_object_color(obj, FLX_DIALOG_BGCOLOR, 0);

        obj = fl_add_pixmap(FL_NORMAL_PIXMAP, 
            0, 0, pm_width, pm_height, "");
        fl_set_pixmap_data(obj, discriminator);

        obj = fl_add_box(FL_NO_BOX, 
            pm_width + pad, 0, 
            label_width, ymax_height, 
            message_str);
        fl_set_object_lcol(obj, FLX_DIALOG_LCOL);
        fl_set_object_lstyle(obj, FLX_DIALOG_LSTYLE);
        fl_set_object_lsize(obj, FLX_DIALOG_LSIZE);
  
        obj = fl_add_box(FL_NO_BOX, 
            0, ymax_height + pad, form_x, 10, "@DnLine");

        obj_input = obj = fl_add_input (type, 
            10, ymax_height + pad + 10 + pad, 
            form_x - 20, button_height, ""); 
        fl_set_input_return (obj, FL_RETURN_END);
        fl_set_object_color (obj, FLX_DIALOG_ICOLOR, FLX_DIALOG_ACOLOR);
        fl_set_object_lcol (obj, FLX_DIALOG_LCOL);
        fl_set_object_lstyle (obj, FLX_DIALOG_LSTYLE);
        fl_set_object_lsize (obj, FLX_DIALOG_LSIZE);
        if (initial != NULL)
	   fl_set_input (obj, initial);

    fl_end_form();
         
    fl_show_form (main_form, FL_PLACE_MOUSE, FL_TRANSIENT, "input");
    
    ret = fl_do_forms();

    if (ret == obj_input) {
       fl_hide_form (main_form);
       return ((char *) fl_get_input(obj_input));
    }
                    

    return (0);


} /* END */
