/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** NAME
**       flx_justify_input
**
** PURPOSE
**       Adjusts text in an input widget so that the end of the text
**       string is visible.  If the input widget is wider than the 
**       text string, this routine has no effect.
**
** CALLING SEQUENCE      
**       void flx_justify_input (FL_OBJECT *input_obj, char *string, 
**           int STYLE, int SIZE);
**
**       This routine is meant to be called immediately after fl_set_input().
**
** INPUTS
**       FL_OBJECT *input_obj is a pointer to the input widget.
**       char *string is the text string placed in the widget.
**       int STYLE is the xforms font style (FL_NORMAL_STYLE, etc).
**       int SIZE is the xforms font size (FL_NORMAL_SIZE, etc).
**
** RESTRICTIONS
**       No checking is done to verify that the input widget is valid.
**              
** MODIFICATION HISTORY
**       Written, Robert.Mallozzi@msfc.nasa.gov, February 1998
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#include "forms.h"

#include <stdlib.h>
#include <string.h>


void flx_justify_input(FL_OBJECT *input_obj, char *string, int STYLE, int SIZE);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
void flx_justify_input(FL_OBJECT *input_obj, char *string, int STYLE, int SIZE)
{
    int width;
    

    width = fl_get_string_width (STYLE, SIZE, string, strlen(string));
    if (width > input_obj->w)  
       fl_set_input_xoffset (input_obj, width - input_obj->w + 
           /* Add a little more offset */
	   fl_get_string_width (STYLE, SIZE, "AA", 2));    

} 

