/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** NAME
**       flx_scale_form
**
** PURPOSE
**       Scales an xforms form based on the current font size
**
** CALLING SEQUENCE      
**       void flx_scale_form(FL_FORM *form);
**
** INPUTS
**       FL_FORM *form is a pointer to the form to scale.
**
** RESTRICTIONS
**       None
**              
** MODIFICATION HISTORY
**       Written, Robert.Mallozzi@msfc.nasa.gov, September 1997
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#include "forms.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


void flx_scale_form(FL_FORM *form);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
/* Scales a form based on the current font */
void flx_scale_form(FL_FORM *form)
{
    /* 
    ** Toplevel form scale factor, scale of (1.0, 1.0) based on a   
    ** 12pt, 75dpi font
    */
    double scaleFactor[2];
    int test_str_width, test_str_height;
    const int dpi75_width = 89;
    const int dpi75_height = 14;
      
 
    /* 
    ** Get a test string dimension; main form is scaled based on a 
    ** "normal" size computed from a 75dpi font 
    */
    fl_get_string_dimension(FL_BOLD_STYLE, FL_NORMAL_SIZE, "TEST_STRING", 
        strlen("TEST_STRING"), &test_str_width, &test_str_height);

    scaleFactor[0] = (double) test_str_width / dpi75_width;
    scaleFactor[1] = (double) test_str_height / dpi75_height;

    fl_scale_form(form, scaleFactor[0], scaleFactor[1]);

} 

