/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** NAME
**       flx_sort_browser
**
** PURPOSE
**       Sort an xforms browser object
**
** CALLING SEQUENCE      
**       void flx_sort_browser(FL_OBJECT *browser, 
**                             int (*sorter) (const void *, const void *));
**
** INPUTS
**       FL_OBJECT *browser is a pointer to the browser object to sort.
**   
**       The  contents of the browser are sorted in ascending order
**       according to a comparison function pointed to  by  sorter(),
**       which  is  called  with  two  arguments  that point to the
**       objects being compared.  If sorter() is NULL, the browser is
**       sorted alphabetically.
**
**       The sorter() function must return an integer less  than,
**       equal  to,  or  greater than zero if the first argument is
**       considered to be respectively  less  than,  equal  to,  or
**       greater than the second.  If two members compare as equal,
**       their order in the sorted array is undefined.
** 
**
** RESTRICTIONS
**       None
**              
** MODIFICATION HISTORY
**       v1.0: written, Robert.Mallozzi@msfc.nasa.gov, August 1997
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#include "forms.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


static int  s_sorter (char *s1[], char *s2[]);
void flx_sort_browser (FL_OBJECT *obj);

/* DEBUG routine */
static void print_browser (FL_OBJECT *browser, char *name);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int s_sorter(char *cp1[], char *cp2[])
{
    return (strcmp(*cp1, *cp2));
}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void flx_sort_browser(FL_OBJECT *browser)
{
    int numLines = fl_get_browser_maxline (browser);
    int i;    
    char **browserArr;
    char *line;
    

    browserArr = (char **) fl_calloc (1, numLines * sizeof (char *));
    for (i = 0; i < numLines; i++) {      
        
        line = (char *) fl_get_browser_line (browser, i+1);

        browserArr[i] = (char *) fl_calloc (1, strlen(line) + 1);
        strcpy (browserArr[i], line);
         
    }

    qsort (browserArr, (size_t) numLines, sizeof(*browserArr), 
        (int (*)(const void *, const void *)) s_sorter);
            
    for (i = 0; i < numLines; i++) {
        
        fl_replace_browser_line (browser, i+1, browserArr[i]);
        free (browserArr[i]);
    
    }
    free (browserArr);


}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* DEBUG routine */
void print_browser(FL_OBJECT *browser, char *name)
{
    int i;
    int numLines = fl_get_browser_maxline (browser);

       
    for (i = 1; i <= numLines; i++)
        printf("%s browser line %d = %s\n", name, i, 
            fl_get_browser_line (browser, i));
     
   
}
