#include "forms.h"
#include "xfpovray.h"
#include "pov-defaults.h"

extern struct pov_options pov;
extern int show_tips;

extern char *CONFIG_POV_WIDTH; 
extern char *CONFIG_POV_HEIGHT;
extern char *CONFIG_POV_LIB_PATH;
extern char *POV_INIFILE;
extern char *STREAM_FILE;
extern char *FATAL_FILE;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
** PARSING PAGE
*/
PARSING_PAGE_S *build_parsing_page(FL_OBJECT *folder)
{
    PARSING_PAGE_S *page = (PARSING_PAGE_S *) fl_calloc(1, sizeof(*page));
    FL_OBJECT *obj;
    int i;    
    int margin = 10;   
    int fx, fy, fw, fh; /* folder geometry */
    

    fl_get_folder_area (folder, &fx, &fy, &fw, &fh);
    
    page->form = fl_bgn_form (FL_FLAT_BOX, fw, fh);
	        
	obj = fl_add_text (FL_NORMAL_TEXT,
            margin, margin, fw - 20, 25, "Library Paths"); 
        fl_set_object_lalign (obj, FL_ALIGN_TOP);
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
 
        for (i = 0; i < 5; i++) {
            page->libpathInput[i] = fl_add_input (FL_NORMAL_INPUT, 
	        margin, margin + (30*(i+1)), fw - (2*margin), 25, "");  
            if (i == 0)
               fl_set_input(page->libpathInput[i], CONFIG_POV_LIB_PATH);
            else
               fl_set_input(page->libpathInput[i], "");
        }  

        page->languageVersion = obj = fl_add_choice(FL_DROPLIST_CHOICE, 
            margin + 120, margin + 190, 70, 25, "Language Version"); 
        fl_addto_choice (obj, "1.0|2.0|3.0");
        fl_set_choice (obj, pov.version);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);
        /* if (show_tips) showtip(obj, "POV-Ray version compatibility"); */

        page->removeBounds = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 120, margin + 220, 70, 25, "Remove Bounds"); 
        fl_addto_choice (obj, "No|Yes");
        fl_set_choice (obj, pov.remove_bounds + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0); 

        page->splitUnions = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 120, margin + 250, 70, 25, "Split Unions"); 
        fl_addto_choice (obj, "No|Yes");
        fl_set_choice (obj, pov.split_unions + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);
          
    fl_end_form();

    /* Scale form based on current font */
    flx_scale_form (page->form);


    return (page); 
        
}



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
** OUTPUT PAGE
*/
OUTPUT_PAGE_S *build_output_page(FL_OBJECT *folder)
{
    OUTPUT_PAGE_S *page = (OUTPUT_PAGE_S *) fl_calloc(1, sizeof(*page));
    FL_OBJECT *obj;
    int margin = 10;   
    int fx, fy, fw, fh;

    
    fl_get_folder_area (folder, &fx, &fy, &fw, &fh);
    
    page->form = fl_bgn_form(FL_FLAT_BOX, fw, fh);
    
	obj = fl_add_menu (FL_PULLDOWN_MENU, 
	    margin, margin, 100, 25, "Image Width");
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_menu(obj, 
	    "50|60|70|80|90|100|150|200|240|320|640|800|1024|1280");
        fl_set_object_callback (obj, SetImageSizeCB, 1);

	page->imageWidthInput = obj = fl_add_input (FL_INT_INPUT, 
	    margin + 110, margin, 50, 25, "");
        fl_set_input(obj, CONFIG_POV_WIDTH);    
        fl_set_object_callback (obj, SetImageSizeCB, 1);

        obj = fl_add_button (FL_NORMAL_BUTTON, 
            margin + 165, margin + 5, 20, 20, "@square");
        fl_set_object_callback (obj, SetImageSizeCB, 2);
        fl_set_object_lsize(obj, FL_NORMAL_SIZE);

	obj = fl_add_menu (FL_PULLDOWN_MENU, 
	    margin, margin + 30, 100, 25, "Image Height");
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_menu (obj, 
	    "50|60|70|80|90|100|150|200|240|320|480|600|768|1024");
        fl_set_object_callback (obj, SetImageSizeCB, 0);

	page->imageHeightInput = obj = fl_add_input (FL_INT_INPUT, 
	    margin + 110, margin + 30, 50, 25, "");
        fl_set_input (obj, CONFIG_POV_HEIGHT);  
        fl_set_object_callback (obj, SetImageSizeCB, 0);

        obj = fl_add_button (FL_NORMAL_BUTTON, 
            margin + 165, margin + 35, 20, 20, "@square");
        fl_set_object_callback (obj, SetImageSizeCB, 3);
        fl_set_object_lsize (obj, FL_NORMAL_SIZE);

	obj = fl_add_menu (FL_PULLDOWN_MENU, 
	    margin + 210, margin, 100, 25, "Mosaic Start");
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_menu (obj, "64|32|16|8|4|2| ");
        fl_set_object_callback (obj, SetMosaicCB, 0);

        page->mosaicStart = obj = fl_add_input (FL_INT_INPUT, 
	    margin + 320, margin, 50, 25, "");
        fl_set_input (obj, "");  

	obj = fl_add_menu (FL_PULLDOWN_MENU, 
	    margin + 210, margin + 30, 100, 25, "Mosaic End");
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_menu (obj, "64|32|16|8|4|2| ");
        fl_set_object_callback (obj, SetMosaicCB, 1);

        page->mosaicEnd = obj = fl_add_input (FL_INT_INPUT, 
	    margin + 320, margin + 30, 50, 25, "");
        fl_set_input (obj, "");  
 
        page->constrainRatio = obj = fl_add_checkbutton (FL_PUSH_BUTTON,
            margin, margin + 60, 100, 25, "Constrain Ratio"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_button (obj, 1);      

        obj = fl_add_frame (FL_ENGRAVED_FRAME,
            margin, margin + 90, fw - 20, 90, "Crop Image"); 
        fl_set_object_lalign (obj, FL_ALIGN_TOP);
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 10, margin + 115, 100, 25, "Start Column"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
 
        page->columnStart = obj = fl_add_input (FL_INT_INPUT, 
	    margin + 100, margin + 115, 50, 25, "");
        fl_set_input (obj, "");  

        obj = fl_add_text(FL_NORMAL_TEXT, 
            margin + 160, margin + 115, 100, 25, "End Column"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
 
        page->columnEnd = obj = fl_add_input(FL_INT_INPUT, 
	    margin + 250, margin + 115, 50, 25, "");
        fl_set_input (obj, "");  

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 10, margin + 145, 100, 25, "Start Row"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
 
        page->rowStart = obj = fl_add_input (FL_INT_INPUT, 
	    margin + 100, margin + 145, 50, 25, "");
        fl_set_input (obj, "");  

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 160, margin + 145, 100, 25, "End Row"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
 
        page->rowEnd = obj = fl_add_input (FL_INT_INPUT, 
	    margin + 250, margin + 145, 50, 25, "");
        fl_set_input (obj, "");

        obj = fl_add_button (FL_NORMAL_BUTTON, 
            margin + 345, margin + 150, 20, 20, "@square");
        fl_set_object_callback (obj, ClearPartialImageCB, 0);
        fl_set_object_lsize (obj, FL_NORMAL_SIZE);

        page->displayDuringRender = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 140, margin + 190, 70, 25, "Display During Render"); 
        fl_addto_choice (obj, "No|Yes");
        fl_set_choice (obj, pov.display_during_render + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);

        page->palette = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 280, margin + 190, 90, 25, "Palette"); 
        fl_addto_choice (obj, "True Color|High Color|Gray Scale");
        fl_set_choice (obj, pov.palette);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);
 
        page->imageToFile = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 140, margin + 220, 70, 25, "Output Image to File"); 
        fl_addto_choice (obj, "No|Yes");
        fl_set_choice (obj, pov.output_to_file + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);

        page->fileType = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 280, margin + 220, 90, 25, "File Type"); 
        fl_addto_choice (obj, "TGA-24|RLE|PNG|PPM|System");
        fl_set_choice (obj, pov.output_filetype);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);
                 
        page->bufferOutput = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 140, margin + 250, 70, 25, "Buffer Output"); 
        fl_addto_choice (obj, "No|Yes");
        fl_set_choice (obj, pov.buffer_output + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);
 
        page->verbosity = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 280, margin + 250, 70, 25, "Verbose"); 
        fl_addto_choice (obj, "Off|Low|High");
        fl_set_choice (obj, pov.verbose + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);

    fl_end_form();

    /* Scale form based on current font */
    flx_scale_form (page->form);

    
    return (page); 
        
}



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
** TRACING PAGE
*/
TRACING_PAGE_S *build_tracing_page(FL_OBJECT *folder)
{
    TRACING_PAGE_S *page = (TRACING_PAGE_S *) fl_calloc(1, sizeof(*page));
    FL_OBJECT *obj;
    char temp[128];
    int bw = 110;
    int bh = 25;
    int margin = 10;   
    int fx, fy, fw, fh;

    
    fl_get_folder_area (folder, &fx, &fy, &fw, &fh);

    page->form = fl_bgn_form (FL_FLAT_BOX, fw, fh);

        page->qualitySlider = obj = fl_add_valslider (FL_HOR_SLIDER, 
            margin, margin, 220, 20, "");
        fl_set_slider_bounds (obj, 1, 9);
        fl_set_slider_value (obj, 9);
        fl_set_slider_step (obj, 1);
        fl_set_slider_precision (obj, 0);
        fl_set_slider_return (obj, 0);
        fl_set_object_lsize (obj, FL_NORMAL_SIZE);
        fl_set_object_callback (obj, QualityCB, 0);
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 270, margin, 50, 25, "Quality"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);

        obj = fl_add_button (FL_NORMAL_BUTTON, 
            margin + 240, margin, 20, 20, "@square");
        fl_set_object_callback (obj, QualityResetCB, 0);
        fl_set_object_lsize (obj, FL_NORMAL_SIZE);

        page->antialiasSlider = obj = fl_add_valslider (FL_HOR_SLIDER, 
            margin, margin + 30, 220, 20, "");
        fl_set_slider_bounds (obj, 1, 9);
        fl_set_slider_value (obj, 3);
        fl_set_slider_step (obj, 1);
        fl_set_slider_precision (obj, 0);
        fl_set_slider_return (obj, 0);
        fl_set_object_lsize (obj, FL_NORMAL_SIZE);
        fl_set_object_callback (obj, QualityCB, 1);
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 270, margin + 30, 100, 25, "Antialias Depth"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);

        obj = fl_add_button (FL_NORMAL_BUTTON, 
            margin + 240, margin + 30, 20, 20, "@square");
        fl_set_object_callback (obj, QualityResetCB, 1);
        fl_set_object_lsize (obj, FL_NORMAL_SIZE);
 
        page->antialias = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 80, margin + 70, bw, bh, "Antialias"); 
	fl_addto_choice (obj, "No|Yes");
	fl_set_choice (obj, pov.antialias + 1);
	fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
	fl_set_object_lstyle (obj, FL_BOLD_STYLE);
	fl_set_object_boxtype (obj, FL_UP_BOX);
	fl_set_object_callback (obj, YesNoCB, 0);

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 190, margin + 70, 130, 25, "Antialias Threshold"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_lalign (obj, FL_ALIGN_RIGHT);
 
        page->antialiasThreshold = obj = fl_add_input (FL_FLOAT_INPUT, 
	    margin + 325, margin + 70, 50, 25, "");
	sprintf(temp, "%5.2f", POV_ANTIALIAS_THRESHOLD);
        fl_set_input (obj, temp);
 
        page->antialiasMethod = obj = fl_add_choice(FL_DROPLIST_CHOICE, 
            margin + 80, margin + 100, bw, bh, "Method"); 
        fl_addto_choice (obj, "Non-Adaptive|Adaptive");
        fl_set_choice (obj, pov.aa_sampling_method);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);

        page->radiosity = obj = fl_add_choice(FL_DROPLIST_CHOICE, 
            margin + 80, margin + 130, bw, bh, "Radiosity"); 
        fl_addto_choice (obj, "No|Yes");
        fl_set_choice (obj, pov.radiosity + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);

        page->bounding = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 80, margin + 160, bw, bh, "Bounding"); 
        fl_addto_choice (obj, "No|Yes");
        fl_set_choice (obj, pov.bounding + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 190, margin + 160, 130, 25, "Bounding Threshold"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_lalign (obj, FL_ALIGN_RIGHT);
 
        sprintf(temp, "%d", pov.bounding_threshold); 
        page->boundingThreshold = obj = fl_add_input(FL_INT_INPUT, 
	    margin + 325, margin + 160, 50, 25, "");
        fl_set_input (obj, temp);
 
        page->lightBuffer = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 80, margin + 190, bw, bh, "Light Buffer"); 
        fl_addto_choice (obj, "No|Yes");
        fl_set_choice (obj, pov.light_buffer + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);

        page->vistaBuffer = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 80, margin + 220, bw, bh, "Vista Buffer"); 
        fl_addto_choice (obj, "No|Yes");
        fl_set_choice ( obj, pov.vista_buffer + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);

        page->jitter = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 80, margin + 250, bw, bh, "Jitter"); 
        fl_addto_choice (obj, "No|Yes");
        fl_set_choice (obj, pov.jitter + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 190, margin + 250, 130, 25, "Jitter Amount"); 
	fl_set_object_lstyle (obj, FL_BOLD_STYLE);
	fl_set_object_lalign (obj, FL_ALIGN_RIGHT);
 
        page->jitterInput = obj = fl_add_input (FL_FLOAT_INPUT, 
	    margin + 325, margin + 250, 50, 25, "");
	sprintf(temp, "%5.2f", POV_JITTER_AMOUNT);
        fl_set_input (obj, temp);
              
    fl_end_form();
    
    /* Scale form based on current font */
    flx_scale_form (page->form);

    
    return (page); 
        
}



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
** ANIMATION PAGE
*/
ANIMATION_PAGE_S *build_animation_page(FL_OBJECT *folder)
{
    ANIMATION_PAGE_S *page = (ANIMATION_PAGE_S *) fl_calloc(1, sizeof(*page));
    FL_OBJECT *obj;
    int margin = 10;   
    int fx, fy, fw, fh;

    
    fl_get_folder_area (folder, &fx, &fy, &fw, &fh);    

    page->form = fl_bgn_form(FL_FLAT_BOX, fw, fh);

        obj = fl_add_frame (FL_ENGRAVED_FRAME,
            margin, margin, fw - 20, 160, "Internal Animation Loop"); 
        fl_set_object_lalign (obj, FL_ALIGN_TOP);
        fl_set_object_lstyle (obj, FL_BOLD_STYLE); 
             
        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 20, margin + 30, 100, 25, "Initial Frame"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        
	page->frameStartInput = obj = fl_add_input (FL_INT_INPUT, 
	    margin + 110, margin + 30, 50, 25, "");
        fl_set_input (obj, "1");  

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 170, margin + 30, 130, 25, "Subset Start Frame"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        
	page->subsetFrameStartInput = fl_add_input (FL_INT_INPUT, 
	    margin + 310, margin + 30, 50, 25, "");
 
        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 20, margin + 60, 100, 25, "Final Frame"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        
	page->frameEndInput = obj = fl_add_input (FL_INT_INPUT, 
	    margin + 110, margin + 60, 50, 25, "");
        fl_set_input (obj, "-1");  

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 170, margin + 60, 130, 25, "Subset End Frame"); 
        fl_set_object_lstyle(obj, FL_BOLD_STYLE);
        
	page->subsetFrameEndInput = fl_add_input (FL_INT_INPUT, 
	    margin + 310, margin + 60, 50, 25, "");

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 20, margin + 90, 100, 25, "Initial Clock"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        
	page->clockStartInput = obj = fl_add_input (FL_FLOAT_INPUT, 
	    margin + 110, margin + 90, 50, 25, "");
        fl_set_input (obj, "0.00");  

        page->cyclicAnimation = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 290, margin + 90, 70, 25, "Cyclic Animation"); 
        fl_addto_choice (obj, "Off|On");
        fl_set_choice (obj, pov.cyclic_animation + 1);
        fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        fl_set_object_boxtype (obj, FL_UP_BOX);
        fl_set_object_callback (obj, YesNoCB, 0);

        obj = fl_add_text (FL_NORMAL_TEXT, 
            margin + 20, margin + 120, 100, 25, "Final Clock"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        
	page->clockEndInput = obj = fl_add_input (FL_NORMAL_INPUT, 
	    margin + 110, margin + 120, 50, 25, "");
        fl_set_input (obj, "1.00");  

        page->fieldRendering = obj = fl_add_choice (FL_DROPLIST_CHOICE, 
            margin + 290, margin + 120, 70, 25, "Field Rendering"); 
	fl_addto_choice (obj, "Off|Even|Odd");
	fl_set_choice (obj, pov.field_rendering + 1);
	fl_set_choice_fontstyle (obj, FL_BOLD_STYLE); 
	fl_set_object_lstyle (obj, FL_BOLD_STYLE);
	fl_set_object_boxtype (obj, FL_UP_BOX);
	fl_set_object_callback (obj, YesNoCB, 0);
 
        obj = fl_add_frame (FL_ENGRAVED_FRAME,
            margin, margin + 180, fw - 20, 70, "External Animation Loop"); 
        fl_set_object_lalign (obj, FL_ALIGN_TOP);
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);

        obj = fl_add_text(FL_NORMAL_TEXT, 
            margin + 20, margin + 210, 100, 25, "Clock"); 
        fl_set_object_lstyle (obj, FL_BOLD_STYLE);
        
	page->clockExternalInput = obj = fl_add_input(FL_NORMAL_INPUT, 
	    margin + 110, margin + 210, 50, 25, "");
        fl_set_input (obj, "0.00");

    fl_end_form();
    
    /* Scale form based on current font */
    flx_scale_form (page->form);

    
    return (page); 
        
}




/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
** CONFIG PAGE
*/
CONFIG_PAGE_S *build_config_page(FL_OBJECT *folder)
{
    CONFIG_PAGE_S *page = (CONFIG_PAGE_S *) fl_calloc (1, sizeof(*page));
    FL_OBJECT *obj;
    int margin = 10;   
    int fx, fy, fw, fh;

    
    fl_get_folder_area (folder, &fx, &fy, &fw, &fh);
 
    page->form = fl_bgn_form (FL_FLAT_BOX, fw, fh);
   
        page->configBrowser = obj = fl_add_browser (FL_NORMAL_BROWSER, 
            margin, margin, fw - 20, fh - 60, POV_INIFILE);
        fl_load_browser (obj, POV_INIFILE);
         
    fl_end_form();
        
    /* Scale form based on current font */
    flx_scale_form (page->form);

        
    return (page); 
}
