/* 
** POV-Ray templates 
**
** v1.0: RSM, 1997 July 
** v1.1: RSM, 1998 January.  
**       Added explicit newline characters to end of line.  SGI compiler 
**       complained about implicit newline continuation of strings.
*/




/* ============================================================================
** Scene Template
** ============================================================================
*/
static char *T_SCENE = 
"//\n"
"// AUTHOR:\n"
"//   DATE:\n"
"//  SCENE:\n"
"\n"
"#include \"colors.inc\"	// Pre-defined colors\n"
"#include \"textures.inc\"	// Standard textures\n"
"\n"
"camera {\n"
"    location <-2.0, 2.0, -5.0>	// location (float[3])\n"
"    look_at <0.0, 0.0, 0.0> 	// view point (float[3])\n"     
"}\n"
" \n"
"light_source {\n"
"    <10.0, 10.0, -10.0>	// location (float[3])\n"
"    color <1.0, 1.0, 1.0> 	// light color (float[3])\n"     
"}\n";



/* ============================================================================
** FINITE SOLIDS
** ============================================================================
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** blob 
*/
static char *T_BLOB =                                      
"// Add any number of cylinders and/or spheres\n"
"blob {\n"
"    threshold   0.5		 // threshold > 0.0 (float)\n"
"    cylinder { <0.0, 0.0, 0.0>, // endpoint 1 (float[3])\n"
"		<0.0, 0.0, 1.0>, // endpoint 2 (float[3])\n"
"		1.0,		 // radius (float)\n"
"		1.0		 // strength (float)\n"
"	      }\n"
"    sphere   { <0.0, 0.0, 0.0>, // center (float[3])\n"
"		1.0,		 // radius (float)\n"
"		1.0		 // strength (float)\n"
"	      }\n"
"    pigment { rgb <1.0, 1.0, 1.0> }\n"
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** box
*/
static char *T_BOX = 
"// Each element of corner_1 < corresponding element of corner_2\n"
"box {\n"
"    <0.0, 0.0, 0.0>, 	// corner_1 (float[3])\n"
"    <1.0, 1.0 ,1.0>	// corner_2 (float[3])\n"     
"    pigment { rgb <1.0, 1.0, 1.0> }\n" 
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** cone
*/
static char *T_CONE = 
"cone {\n"
"    <0.0, 0.0, 0.0>, 	// base point (float[3])\n"
"    1.0,		// base radius (float)\n"
"    <1.0, 1.0, 1.0>, 	// cap point (float[3])\n"
"    0.0		// cap radius (float)\n"    
"    pigment { rgb <1.0, 1.0, 1.0> }\n" 
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** cylinder
*/
static char *T_CYLINDER = 
"cylinder {\n"
"    <0.0, 0.0, 0.0>, 	// base point (float[3])\n"
"    <1.0, 1.0, 1.0>, 	// cap point (float[3])\n"
"    1.0		// radius (float)\n"    
"    pigment { rgb <1.0, 1.0, 1.0> }\n"
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** height field
*/
static char *T_HEIGHT_FIELD = 
"height_field {\n"
"    gif		// file type\n" 
"    \"file.gif\"	// filename\n"
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** julia fractal
*/
static char *T_JULIA_FRACTAL = 
"julia_fractal {\n"
"    <1.0, 0.0, 0.0, 0.0>	 // 4-D JULIA_PARAMETER (float[4])\n" 
"    quaternion			 // 4-D algebra type\n"
"    // hypercomplex		 // (quaternion | hypercomplex)\n"
"    sqr			 // interation function\n"
"    max_iteration 20		 // max iterations for convergence (integer)\n"
"    precision 20		 // convergence criterion (integer)\n"
"    slice <0.0, 0.0, 0.0, 1.0>, // 4-D normal (float[4])\n" 
"          0.0			 // distance (float)\n"
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** lathe
*/
static char *T_LATHE = 
"lathe {\n"
"    linear_spline	// linear_spline | quadratic_spline | cubic_spline\n"
"    2,			// number of data points n (integer)\n"
"    <0.0, 0.0>,	// data point 1 (float[2])\n"
"    <1.0, 1.0>		// data point n (float[2])\n"
"    pigment { rgb <1.0, 1.0, 1.0> }\n"
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** sphere
*/
static char *T_SPHERE = 
"sphere {\n"
"    <0.0, 0.0, 0.0>, 	// center (float[3])\n"
"    1.0		// radius (float)\n"    
"    pigment { rgb <1.0, 1.0, 1.0> }\n"
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** superquadratic ellipsoid
*/
static char *T_SUPERELLIPSOID = 
"superellipsoid {\n"
"    <0.8, 0.8>	    // east-west component, north-south component (float[2])\n"
"    pigment { rgb <1.0, 1.0, 1.0> }\n"
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** surface of revolution
*/
static char *T_SOR = 
"sor {\n"
"    2,			// number of data points n (integer)\n"
"    <0.0, 0.0>,	// data point 1 (float[2])\n"
"    <1.0, 1.0>		// data point n (float[2])\n"
"    pigment { rgb <1.0, 1.0, 1.0> }\n" 
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** text
*/
static char *T_TEXT = 
"text {\n"
"    ttf \"fontname.ttf\",	// True Type font filename\n"
"    \"Text\", 	   		// string of text\n"   
"    1.0,			// character thickness (float)\n"
"    0.0			// character offset (float)\n"
"    pigment { rgb <1.0, 1.0, 1.0> }\n"
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** torus
*/
static char *T_TORUS = 
"torus {\n"
"    1.0,	// major radius (float)\n"
"    0.1 	// minor radius (float)\n"    
"    pigment { rgb <1.0, 1.0, 1.0> }\n"
"}\n";




/* ============================================================================
** INFINITE SOLIDS
** ============================================================================
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** plane
*/
static char *T_XPLANE = 
"plane {\n"
"    <1.0, 0.0, 0.0>,	// normal vector (float[3])\n"
"    0.0 		// offset distance (float)\n"     
"    pigment { rgb <1.0, 1.0, 1.0> }\n"
"}\n";

static char *T_YPLANE = 
"plane {\n"
"    <0.0, 1.0, 0.0>,	// normal vector (float[3])\n"
"    0.0 		// offset distance (float)\n"    
"    pigment { rgb <1.0, 1.0, 1.0> }\n" 
"}\n";

static char *T_ZPLANE = 
"plane {\n"
"    <0.0, 0.0, 1.0>,	// normal vector (float[3])\n"
"    0.0 		// offset distance (float)\n"    
"    pigment { rgb <1.0, 1.0, 1.0> }\n"
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** axes
*/
static char *T_AXES = 
"#declare Axes = \n"
"union {\n"
"   cylinder { <0, 0, 0>, <500, 0, 0>, 0.05\n"
"     pigment { rgb <1, 0, 0> }\n"
"   }\n"
"   cylinder { <0, 0, 0>, <0, 500, 0>, 0.05\n"
"     pigment { rgb <0, 1, 0> }\n"
"   }\n"
"   cylinder { <0, 0, 0>, <0, 0, 500>, 0.05\n"
"     pigment { rgb <0, 0, 1> }\n"
"   }\n"
"}\n"
"object { Axes }\n";




/* ============================================================================
** LIGHTS
** ============================================================================
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** point light
*/
static char *T_LIGHT_POINT = 
"// Point light\n"
"light_source {\n"
"    <10.0, 10.0, -10.0>	// location (float[3])\n"
"    color <1.0, 1.0, 1.0> 	// light color (float[3])\n"     
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** spot light
*/
static char *T_LIGHT_SPOT = 
"// Spot light\n"
"light_source {\n"
"    <10.0, 10.0, -10.0>       // location (float[3])\n"
"    color <1.0, 1.0, 1.0>     // light color (float[3])\n"
"    spotlight		       // light type\n"
"    point_at <0.0, 0.0, 1.0>  // direction (float[3])\n"
"    radius 45.0	       // half-angle of inner cone, fully lit (float)\n"
"    falloff 60.0	       // half-angle of light cone (float)\n"
"    tightness 10              // light falloff, 1-100 (integer)\n"    
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** cylindrical light
*/
static char *T_LIGHT_CYL = 
"// Cylindrical light\n"
"light_source {\n"
"    <10.0, 10.0, -10.0>       // location (float[3])\n"
"    color <1.0, 1.0, 1.0>     // light color (float[3])\n"
"    cylinder		       // light type\n"
"    point_at <0.0, 0.0, 1.0>  // direction (float[3])\n"
"    radius 45.0	       // half-angle of inner cone, fully lit (float)\n"
"    falloff 60.0	       // half-angle of light cone (float)\n"
"    tightness 10              // light falloff, 1-100 (integer)\n"     
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** area light
*/
static char *T_LIGHT_AREA = 
"// Area light\n"
"light_source {\n"
"    <10.0, 10.0, -10.0>	// location (float[3])\n"
"    color <1.0, 1.0, 1.0> 	// light color (float[3])\n"
"    area_light <1.0, 0.0, 0.0>,// light axis 1 (float[3])\n"
"               <0.0, 1.0, 0.0>,// light axis 2 (float[3])\n"
"                3, 		// dimension of point light array 1 (integer)\n"
"                3		// dimension of point light array 2 (integer)\n"
"    point_at <0.0, 0.0, 1.0>	// direction (float[3])\n"
"    adaptive 1			// enable adaptive sampling (integer >= 0)\n"
"    jitter 1			// random jitter of point lights\n"    
"}\n";




/* ============================================================================
** CAMERA
** ============================================================================
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** perspective camera
*/
static char *T_PERSPECTIVE_CAMERA = 
"camera {\n"
"    location <-2.0, 2.0, -5.0>	// location (float[3])\n"
"    look_at <0.0, 0.0, 0.0> 	// view point (float[3])\n"     
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** orthographic camera
*/
static char *T_ORTHOGRAPHIC_CAMERA = 
"camera {\n"
"    orthographic\n"
"    location <-2.0, 2.0, -5.0>	// location (float[3])\n"
"    look_at <0.0, 0.0, 0.0> 	// view point (float[3])\n"     
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** fisheye camera
*/
static char *T_FISHEYE_CAMERA = 
"camera {\n"
"    fisheye\n"
"    location <-2.0, 2.0, -5.0>	// location (float[3])\n"
"    look_at <0.0, 0.0, 0.0> 	// view point (float[3])\n"
"    angle 180.0		// camera view angle in degrees (float)\n"     
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** wide angle camera
*/
static char *T_WIDE_ANGLE_CAMERA = 
"camera {\n"
"    ultra_wide_angle\n"
"    location <-2.0, 2.0, -5.0>	// location (float[3])\n"
"    look_at <0.0, 0.0, 0.0> 	// view point (float[3])\n"
"    angle 180.0		// camera view angle in degrees (float)\n"     
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** omnimax camera
*/
static char *T_OMNIMAX_CAMERA = 
"camera {\n"
"    omnimax			// camera type\n"
"    location <-2.0, 2.0, -5.0>	// location (float[3])\n"
"    look_at <0.0, 0.0, 0.0> 	// view point (float[3])\n"
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** panoramic camera
*/
static char *T_PANORAMIC_CAMERA = 
"camera {\n"
"    panoramic			// camera type\n"
"    location <-2.0, 2.0, -5.0>	// location (float[3])\n"
"    look_at <0.0, 0.0, 0.0> 	// view point (float[3])\n"
"    angle 180.0		// horizontal view angle in degrees (float)\n"     
"}\n";




/* ============================================================================
** ATMOSPHERIC EFFECTS
** ============================================================================
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** atmosphere
*/
static char *T_ATMOSPHERE = 
"#declare ISOTROPIC         = 1\n"
"#declare MIE_HAZY          = 2\n"
"#declare MIE_MURKY         = 3\n"
"#declare RAYLEIGH          = 4\n"
"#declare HENYEY_GREENSTEIN = 5\n"
"atmosphere {\n"
"    type ISOTROPIC\n"
"    distance 0.1	   // particle density (float)\n"
"    color <0.8, 0.8, 0.8> // default color is black (float[3])\n"
"//    scattering  	   // amount of scattered light (float)\n"
"//    eccentricity	   // Henyey-Greenstein scattering ellipse (float)\n"
"//    samples		   // number of samples along viewing ray (integer)\n"
"//    jitter		   // add random noise to particles (float)\n"
"//    aa_level		   // enable super-sampling (integer)\n"
"//    aa_threshold	   // threshold for intensity change (float)\n"
"}\n";


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** background
*/
static char *T_BACKGROUND =
"background {\n"
"    color <0.0, 0.0, 0.0>	// default color is black (float[3])\n"
"}\n";
     

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** fog
*/
static char *T_FOG =
"#declare CONSTANT_FOG = 1\n"
"#declare GROUND_FOG   = 2\n"
"fog {\n"
"    fog_type CONSTANT_FOG\n"	
"    distance 0.1	    // particle density (float)\n"
"    color <0.8, 0.8, 0.8>  // fog color (float[3])\n"
"//    turbulence	    // (float[3])\n"
"//    turb_depth	    // scale turbulence along viewing ray (float)\n"
"//    omega		    // value of successive octave steps (float)\n"
"//    lambda		    // randomness of successive octaves (float)\n"
"//    octaves		    // number of steps of turbulence (integer, 1-10)\n"
"//    fog_offset	    // fog density constant to this height (float)\n"
"//    fog_alt		    // rate at which fog fades away (float)\n"
"//    up		    // ground normal vector (float[3])\n"
"}\n";
     

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** sky sphere
*/
static char *T_SKY_SPHERE =
"// One sky sphere per scene\n"
"// Add pigment layers; last pigment is at top\n"
"sky_sphere {\n"
"    pigment {\n"
"        gradient <0.0, 1.0, 0.0>\n"
"        color_map {\n"
"             [0.5 color rgb <0.258824, 0.258824, 0.435294>]\n"
"             [1.0 color rgb <0.184314, 0.184314, 0.309804>]\n"
"        }\n"
"        scale 2\n"
"        translate -1\n"
"    }\n"
"}\n";
     

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** rainbow
*/
static char *T_RAINBOW =
"rainbow {\n"
"    direction <1.0, 1.0, 1.0>	// light direction (float[3])\n"
"    angle 40.0			// position (float)\n"
"    width 5.0			// size (float)\n"
"    distance 1000.0		// particle density (float)\n"
"    color_map { }		// rainbow colormap\n"
"//    jitter			// add random noise to particles (float)\n"
"//    up			// ground normal vector (float[3])\n"
"//    arc_angle		// size of arc in degrees (float)\n"
"//    falloff_angle		// arc endpoint blending in degrees (float)\n"
"}\n";



/* ============================================================================
** GLOBAL SETTINGS
** ============================================================================
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
**
*/
static char *T_G_ADC_BAIL = 
    "global_settings { adc_bailout 0.0039 }\n";	 
static char *T_G_AMBIENT = 
    "global_settings { ambient_light rgb <1.0, 1.0, 1.0> }\n";	 
static char *T_G_GAMMA = 
    "global_settings { assumed_gamma 2.2 }\n";	 
static char *T_G_HF_GRAY = 
    "global_settings { hf_gray_16 on }\n";	 
static char *T_G_IRID = 
    "global_settings { irid_wavelength rgb <0.25, 0.18, 0.14> }\n";	 
static char *T_G_MAX_TRACE = 
    "global_settings { max_trace_level 5 }\n";	 
static char *T_G_MAX_INTERSECT = 
    "global_settings { max_intersections 64 }\n";
static char *T_G_NUM_WAVES = 
    "global_settings { number_of_waves 10 }\n";	 
static char *T_G_RADIOSITY = 
"\\ Radiosity is EXPERIMENTAL for POV-Ray v3.0\n"
"global_settings { radiosity\n"
"    brightness		// brighten amibient values (float, def = 3.3)\n"
"    count		// number of rays (integer, def = 100)\n"
"    distance_maximum	// distance where error_bound >= 1 (float, def = 0)\n" 
"    error_bound	// fraction error allowed (float 0.0-1.0, def = 0.4)\n"
"    gray_threshold	// limit color-bleeding (float, def = 0.5)\n"
"    low_error_factor	// set error_bound on initial passes (float, def = 0.8)\n"
"    minimum_reuse	// minimum effective ratio (float, def = 0.015)\n"
"    nearest_count	// max ambient values blended (integer, def = 6)\n"
"//    radiosity_quality // NOT YET IMPLEMENTED (v3.0)\n"
"    recursion_limit	// levels for diffuse inter-reflection (1 or 2, def = 1)\n"
"}\n";	 




/* ============================================================================
** INCLUDES
** ============================================================================
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** inc files
*/
static char *T_INC_CHARS = 
    "#include \"chars.inc\"	// Character objects\n";
static char *T_INC_COLORS = 
    "#include \"colors.inc\"	// Pre-defined colors\n";
static char *T_INC_CONSTS = 
    "#include \"consts.inc\"	// Constants and aliases\n";
static char *T_INC_FINISH = 
    "#include \"finish.inc\"	// Basic finishes\n";
static char *T_INC_GLASS = 
    "#include \"glass.inc\"	// Glass finishes\n";
static char *T_INC_GOLDS = 
    "#include \"golds.inc\"	// Gold textures\n";
static char *T_INC_METALS = 
    "#include \"metals.inc\"	// Metallic finishes\n";
static char *T_INC_SHAPES = 
    "#include \"shapes.inc\"	// Standard shapes\n";
static char *T_INC_SHAPES2 = 
    "#include \"shapes2.inc\"	// Seldom used shapes\n";
static char *T_INC_SHAPESQ = 
    "#include \"shapesq.inc\"	// Cubic and quartic shapes\n";
static char *T_INC_SKIES = 
    "#include \"skies.inc\"	// Sky textures\n";
static char *T_INC_STARS = 
    "#include \"stars.inc\"	// Star fields\n";
static char *T_INC_STONES = 
    "#include \"stones.inc\"	// Stone textures\n";
static char *T_INC_STONES1 = 
    "#include \"stones1.inc\"	// Part 1 of stones.inc\n";
static char *T_INC_STONES2 = 
    "#include \"stones2.inc\"	// Part 2 of stones.inc\n";
static char *T_INC_TEXTURE = 
    "#include \"textures.inc\"	// Standard textures\n";
static char *T_INC_WOODMAP = 
    "#include \"woodmaps.inc\"	// Wooden colormaps\n";
static char *T_INC_WOODS = 
    "#include \"woods.inc\"	// Wood textures\n";
