/*
** run_program
**
** Use execvp() to run an arbitrary program.  First input argument is
** a string designating the program to run, followed by a list of strings
** that are the program input arguments.
**
** Robert.Mallozzi@msfc.nasa.gov
** 1998 January
**
*/

#include <stdarg.h>
#include <stdio.h>


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
void run_program (int count, ...)
{
    int i, pid;
    va_list ap;
    char *program;
    char **arg_list;
    

    arg_list = (char **) malloc ((count + 1) * sizeof(char *));
    if (arg_list == NULL) {
       perror ("run_program");
       return;
    }
                 
    /* Initialize argument list */
    va_start (ap, count);

    /* 
    ** Copy the program name to the second argument to execvp()
    ** By convention, this argument is the program name.
    */
    arg_list[0] = va_arg (ap, char*); 
    program = arg_list[0]; 
    for (i = 1; i < count; i++)
        arg_list[i] = va_arg (ap, char*); 
    arg_list[count] = NULL; 
    
    /* gcc doesn't need this, but some compilers may require it */
    va_end (ap);	

    /* 
    ** Run the program as a child process 
    */    
    pid = fork();
    if (pid == 0) {
       if (execvp (program, arg_list) == -1) {
          fprintf (stderr, "\nrun: could not exec() %s\n", arg_list[0]);
          /* sigchld catcher handles the error */
          _exit (255);
       }   
    }
    else if (pid < 0)
       fprintf (stderr, "\nrun: could not fork()\n");

    free (arg_list);
    
        
    return;
}


#ifdef TEST_RUN_PROGRAM

int main (void)
{

    run_program (2, "nedit", "junk");

    return (0);
}

#endif
