#include <stdlib.h>
#include <stddef.h>
#include <string.h>

#include "forms.h"
#include "xfpovray.h"

extern struct pov_options pov;
extern char *CONFIG_DISPLAY_COMMAND;
extern char *CONFIG_POV_DIR;
extern char *CONFIG_SCENE_FILTER;
extern char *CONFIG_IMAGE_FILTER;

extern OUTPUT_PAGE_S *outputPage;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
char *truncate(char *string, char endat)
{
    char *endchar;
    
    
    if ((string != NULL) && (endchar = strrchr(string, endat)) != NULL)
       *endchar = '\0';
       
    return (string);   

}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
/* 
** Display the image after rendering.  Some OS do not allow 
** display during rendering.
*/
void show_image(void)
{
    char viewit[256];
    char imgfile[256];
    char temp[256];
    char currentFilter[10];
    int type;
    char *ext;
    const char *file;
    

    strcpy(temp, pov.input_file_name);
    sprintf(imgfile, "%s", truncate(temp, '.'));

    
    /* 
    ** Try to guess the image extension
    */
    type = fl_get_choice (outputPage->fileType);
    switch (type) {
        case 1:  ext = ".tga"; break;
        case 2:  ext = ".tga"; break;
        case 3:  ext = ".png"; break;
        case 4:  ext = ".ppm"; break;
        case 5:  ext = strtok(CONFIG_IMAGE_FILTER, "*"); break;	
        default: ext = ".tga"; break;
    }
    strcat(imgfile, ext);
    
    sprintf(currentFilter, "*%s", ext);
    file = (char *) flx_filebox (CONFIG_POV_DIR, currentFilter, &imgfile); 

    if (strcmp(file, "") != 0) {
       sprintf(viewit, "%s %s &", CONFIG_DISPLAY_COMMAND, imgfile);
       system(viewit);
    }
    
}
