#include "forms.h"
#include <stdlib.h>

extern int show_tips;
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
/*
 * use the post handler as a tipper
 */
int post_handler(FL_OBJECT *ob, int event, 
    FL_Coord mx, FL_Coord my, int key, void *xev)
{
     static int cnt;

        
     if (!show_tips)
        return 0;
        
     if (!ob->u_vdata)
        return 0;

     fl_set_oneliner_color (FL_BLACK, FL_WHITE);
     fl_set_oneliner_font (FL_NORMAL_STYLE, FL_SMALL_SIZE);


     if (event == FL_ENTER) {
        fl_set_object_automatic(ob, 1);
        cnt = 1;
     }
     else if (event == FL_LEAVE || event == FL_PUSH) {
        fl_set_object_automatic(ob, 0); 
        fl_hide_oneliner();
     }
     else if (event == FL_STEP && (cnt++ % 20)== 0) {
        fl_set_object_automatic(ob, 0);
        fl_show_oneliner(ob->u_vdata, ob->form->x + ob->x,
                         ob->form->y + ob->y + ob->h + 1);
     }
     
     return 0;
}




/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
void showtip(FL_OBJECT *ob, char *s)
{
       ob->u_vdata = s;
       fl_set_object_posthandler(ob, post_handler);

}
