/*
** General utility functions
*/

#include <stdlib.h>
#include <string.h>



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
/* Truncate a string at endat */
char *strtruncate (char *string, char endat)
{
    char *endchar;
    
    if ((string != NULL) && (endchar = strrchr(string, endat)) != NULL)
       *endchar = '\0';
   
    return (string);

}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Break a filename into tokens */
int tokenize(char *command_string, char *tokenlist[], size_t maxtoken)
{
    static char tokensep[] = "/";
    int tokencount;
    char *thistoken;
    

    if (command_string == NULL || !maxtoken)
       return 0;
       
    thistoken = strtok(command_string, tokensep);
    
    for (tokencount = 0; tokencount < maxtoken && thistoken != NULL;) {

        tokenlist[tokencount++] = thistoken;
        thistoken = strtok(NULL, tokensep);
        
    }
    
    tokenlist[tokencount] = NULL;
 
    return tokencount;     

}
