/* 
** Header file for xfpovray
*/

#ifndef XFPOVRAY_H
#define XFPOVRAY_H

 
/* 
** Command to invoke POV-Ray 
*/
#define POV_COMMAND "/usr/local/bin/povray"

 
/* 
** System or default library path.  You can add up to 4 more on
** the widget for a total of 5, even though POV-Ray supports more.
*/
#define POV_LIB_PATH "/usr/local/include/povray"
 
 
/* 
** Image file viewer command 
*/
#define DISPLAY_COMMAND "xv"
 
 
/* 
** Editor command.  If you use a console editor like vi, execute the
** editor in an xterm, e.g., xterm -e vi
*/
#define POV_EDITOR "nedit"
 
  
/* 
** Default directory to search for scene files when xfpovray is run 
*/
#define POV_DIR "."

 
/* 
** Default file filter for scene files 
*/
#define SCENE_FILTER "*.pov"

 
/* 
** Default file filter for image files 
*/
#define IMAGE_FILTER "*.tga"
 
/* 
** Default image size 
*/
#define POV_WIDTH 150
#define POV_HEIGHT 150
#define POV_WIDTH_S "150"
#define POV_HEIGHT_S "150"


/* 
** System utilities.  Hopefully you won't have to change these.
*/
#define MKDIR "mkdir"

/* 
** Don't change these unless the new commands accept the same options flags.
** TODO: This area needs a lot of work...
*/
#define GREP "grep"
#define SED  "sed"
#define CUT  "cut"


/* 
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
** END USER DEFINITIONS.  No need to edit below here.
*/


/* 
** Temporary files used by xfpovray, written in directory
** $HOME/.xfpovray/
*/
#define _POV_INIFILE "xfpovray.ini"
#define _STREAM_FILE "xfpovray.stream"
#define _FATAL_FILE "xfpovray.fatal"
#define _PREVIEW_FILE "xfpovray.preview"
#define _TEMP_FILE "xfpovray.tmp"
 

/* 
** Button states 
*/
#define PUSHED   1  
#define RELEASED 0
 

/* 
** The minimum version of xforms required to compile xfpovray
*/
#define MIN_XFORMS_VER 0
#define MIN_XFORMS_REV 87


/* 
** Callback functions 
*/
void AbortCB		   (FL_OBJECT *obj, long data);
void ClearPartialImageCB   (FL_OBJECT *obj, long data); 
void ChangedFolderCB	   (FL_OBJECT *obj, long data);
void ConfigCB		   (FL_OBJECT *obj, long data);
void ContinueCB 	   (FL_OBJECT *obj, long data); 
void DismissAboutCB	   (FL_OBJECT *obj, long data);
void DismissConfiguratorCB (FL_OBJECT *obj, long data);
void DismissHelpCB	   (FL_OBJECT *obj, long data);
void DismissFolderCB	   (FL_OBJECT *obj, long data);
void DismissMessageCB	   (FL_OBJECT *obj, long data);
void DisplayHelpCB	   (FL_OBJECT *obj, long data);
void DoPreviewCB	   (FL_OBJECT *obj, long data);
void ExternalCB 	   (FL_OBJECT *obj, long data);
void GetFileCB  	   (FL_OBJECT *obj, long data);
void LoadClipboardCB	   (FL_OBJECT *obj, long data);
void HelpCB		   (FL_OBJECT *obj, long data);
int  nothingCB  	   (FL_OBJECT *obj, long data);
void OptionsCB  	   (FL_OBJECT *obj, long data);
void PovCB		   (FL_OBJECT *obj, long data);
int  PovCheckCB 	   (XEvent *ev, void *data);
void PreviewCB  	   (FL_OBJECT *obj, long data);
void PreviewDismissCB	   (FL_OBJECT *obj, long data);
void PreviewRadioCB	   (FL_OBJECT *obj, long data); 
void QualityCB  	   (FL_OBJECT *obj, long data);
void QualityResetCB	   (FL_OBJECT *obj, long data);
void QuitCB		   (FL_OBJECT *obj, long data);
void ResetPreviewCB	   (FL_OBJECT *obj, long data);
void SetHelpFontCB	   (FL_OBJECT *obj, long data);
void SetImageSizeCB	   (FL_OBJECT *obj, long data);
void SetMosaicCB	   (FL_OBJECT *obj, long data);
void ToggleFolderCB	   (FL_OBJECT *obj, long data);
void YesNoCB		   (FL_OBJECT *obj, long data);

/* 
** Other utility functions 
*/
void write_config (char *ini_file);
void show_image   (void);
void save_state   (void);
int  get_state    (int warn);
void run_program  (int count, ...);

/* 
** These local functions build the various forms 
*/
static void build_main         (void);
static void build_folder       (void);
static void build_text         (void);
static void build_fatal        (void);
static void build_about        (void);
static void build_preview      (void);
static void build_help         (void);
static void build_render_pup   (void);
static void build_configurator (void);


/* 
** Global data structure 
*/
typedef struct {

    FL_FORM *mainForm;             
    FL_FORM *folderForm;           
    FL_FORM *messageForm;          
    FL_FORM *fatalForm;            
    FL_FORM *aboutForm;            
    FL_FORM *previewForm;          
    FL_FORM *helpForm;             
    FL_FORM *renderPupForm;        
    FL_FORM *configuratorForm;     

    FL_OBJECT *mainFolder;
    FL_OBJECT *sceneFileInput;    
    FL_OBJECT *outFileInput;    
    FL_OBJECT *messageBrowser;    
    FL_OBJECT *fatalBrowser;      
    FL_OBJECT *aboutText;         
    FL_OBJECT *aboutTimer;        
    FL_OBJECT *toggleFolder;      
    FL_OBJECT *helpBrowser;       
    
    FL_OBJECT *previewOption[10]; 
    FL_OBJECT *previewBrowser;    
    FL_OBJECT *previewType[4];    
    FL_OBJECT *showAxes;          
    FL_OBJECT *previewCamera[3];       
    FL_OBJECT *previewCameraLookat[3]; 
    FL_OBJECT *previewLight[3];        
        
    FL_OBJECT *optionsMenu;
    FL_OBJECT *configOptions[9];

} XFDATA_S;    


/* 
** Options folder data structures 
*/
typedef struct {
    FL_FORM *form;
    FL_OBJECT *libpathInput[5];
    FL_OBJECT *languageVersion;
    FL_OBJECT *removeBounds;
    FL_OBJECT *splitUnions;
} PARSING_PAGE_S;    

PARSING_PAGE_S *build_parsing_page(FL_OBJECT *folder);


typedef struct {
    FL_FORM *form;
    FL_OBJECT *imageWidthInput;
    FL_OBJECT *imageHeightInput;
    FL_OBJECT *mosaicStart;
    FL_OBJECT *mosaicEnd;
    FL_OBJECT *constrainRatio;    
    FL_OBJECT *columnStart;
    FL_OBJECT *columnEnd;
    FL_OBJECT *rowStart;
    FL_OBJECT *rowEnd;
    FL_OBJECT *displayDuringRender;    
    FL_OBJECT *palette;    
    FL_OBJECT *imageToFile;
    FL_OBJECT *fileType;
    FL_OBJECT *verbosity;        
    FL_OBJECT *bufferOutput;        
} OUTPUT_PAGE_S;    

OUTPUT_PAGE_S *build_output_page(FL_OBJECT *folder);


typedef struct {
    FL_FORM *form;
    FL_OBJECT *qualitySlider;        
    FL_OBJECT *antialiasSlider;        
    FL_OBJECT *antialias;        
    FL_OBJECT *antialiasThreshold;        
    FL_OBJECT *antialiasMethod;        
    FL_OBJECT *radiosity;
    FL_OBJECT *bounding;
    FL_OBJECT *boundingThreshold;                
    FL_OBJECT *lightBuffer;
    FL_OBJECT *vistaBuffer;
    FL_OBJECT *jitter;
    FL_OBJECT *jitterInput;
} TRACING_PAGE_S;    

TRACING_PAGE_S *build_tracing_page(FL_OBJECT *folder);


typedef struct {
    FL_FORM *form;
    FL_OBJECT *frameStartInput;    
    FL_OBJECT *frameEndInput;    
    FL_OBJECT *subsetFrameStartInput;
    FL_OBJECT *subsetFrameEndInput;
    FL_OBJECT *clockStartInput;    
    FL_OBJECT *clockEndInput;    
    FL_OBJECT *clockExternalInput;
    FL_OBJECT *cyclicAnimation;
    FL_OBJECT *fieldRendering;
} ANIMATION_PAGE_S;    

ANIMATION_PAGE_S *build_animation_page(FL_OBJECT *folder);


typedef struct {
    FL_FORM *form;
    FL_OBJECT *configBrowser;
} CONFIG_PAGE_S;    

CONFIG_PAGE_S *build_config_page(FL_OBJECT *folder);


/* POV structure */
struct pov_options {
       char *input_file_name;
/*       char *output_file_name;*/
       int height;
       int width;
       int display_during_render;
       int output_to_file;
       int verbose;
       int buffer_output;
       int buffer_size;
       int antialias;
       int aa_sampling_method;
       int aa_depth;
       int radiosity;
       int quality;
       int redirect_on;
       int version; 
       int remove_bounds;
       int split_unions;
       int bounding;
       int bounding_threshold;
       int light_buffer;
       int vista_buffer;
       int jitter;
       int initial_frame;
       int final_frame;
       int cyclic_animation;
       int field_rendering;
       int odd_field;
       int palette;
       int output_filetype;
};

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#endif /* XFPOVRAY_H */
