%{
#include <iostream>
#include <cstring>
#include <cstdio>
#include <ctype.h>
#include <signal.h>
#include <setjmp.h>

#include "base.cpp"


int yyparse();
int yylex();
void yyerror(char *s);
void execerror(char *s);

jmp_buf begin;

bool COUT = false;
command m_com;
m_string global_name;

%}
%union YYUstYPE{
	m_string vars;
	fraction fractions;
}
%token <vars> VARS
%token <fractions> FRACT
%type <fractions> expr
%type <vars> code commands structurs
%left	','
%right '='
%right '|' '&'
%right '<' '>' '#' '?'
%left	'+' '-'
%left	'*' '/'
%right  '@' '%'
%right 	'^'
%left	'.'
%left	'_'
%left UNARMINUS '!'
%%
list:	/* nothing */
	| list '\n'
	| list code '\n'				
	| list commands '\n'
	| list expr '\n'				{COUT = m_com.find_expr(CODE_EXP); 
											if (!m_com.miss)
												if (!COUT && m_com.condition() !=  DESCRIPTION_FUNCTION)
													std::cout << $2 << std::endl;
									}
	| list expr ';''\n'				{m_com.find_expr(CODE_EXP); }
	| list error '\n'				{ yyerror("syntax error my");}
	| list 'i''n''c''l''u''d''e' VARS'\n' 		{m_com.open_file($9, 1);}
	| list 'f''o''r''(' expr ';''\n'		{ m_com.find_for_small();}
	;
structurs: 
	  'i''f' '('expr')'					{ m_com.find_if($4,0);  }
	| 'w''h''i''l''e''('expr')'			{ m_com.find_while($7,0);}
	| 'f''o''r''('expr';'expr';'expr')'	{ m_com.find_for($9);}
	| 'e''l''s''e'						{ m_com.find_else(0);  }
	;
code : VARS '(' expr ')' '{'		{ if (m_com.condition() != CALCULATIONS)
											m_com.error_line("Embedded functions not possible");
										else 
											m_com.open_func($1);
									}
	| structurs							/**/
	| structurs	expr					{ COUT = m_com.find_expr(CODE_EXP); 
											if (!m_com.miss)
												if (!COUT && m_com.condition() !=  DESCRIPTION_FUNCTION)
													std::cout << $2 << std::endl;
										}
	| structurs	commands				/**/
	| structurs '{'						{ m_com.blok_open(); }
	| '{'								{ m_com.blok_open(); }
	| '}'								{ m_com.blok_close();}
	| 'p''r''o''p''e''r'			{fraction::proper = PROPER;}
	| 'i''m''p''r''o''p''e''r'		{fraction::proper = IMPROPER;}
	;
commands: 
	 'r''e''t''u''r''n' expr ';'	{ COUT = m_com.find_expr(CODE_EXP);
									 if (m_com.condition() == CALCULATIONS)
											m_com.error_line("Only in function");
										else 
											if (!m_com.miss)
												if (!COUT)
													m_com.return_func($7);
									}
	| 'r''e''t''u''r''n'';'			{ COUT = m_com.find_expr(CODE_EXP);
									 if (m_com.condition() == CALCULATIONS)
											m_com.error_line("Only in function");
										else 
											if (!m_com.miss)
												if (!COUT)
													m_com.return_func(0);
									}
	| 'b''r''e''a''k'';'			{	COUT = m_com.find_expr(CODE_EXP);
										if (!m_com.miss)
											if (!COUT)
												m_com.find_break();
									}
	| 'e''x''i''t'					{ m_com.find_exit();}
	;
expr: FRACT					{ if (!m_com.miss) $$ = $1; else $$ = 1; }
	| expr '.' expr			{ if (!m_com.miss) {$3.set_den_ten(); $$ = $1+$3; } else $$ = 1; }
	| expr '_' expr			{ if (!m_com.miss) {$$ = $1; if ($3 == fraction::zer) execerror("Division by zero"); $$ = $$ / $3;} else $$ = 1; }	
	| VARS					{ if (!m_com.miss) $$ = m_com.m_vars.get($1); else $$ = 1; }
	| '@' VARS				{ if (!m_com.miss){
									 $$ = m_com.m_vars.get($2)+fraction::one;
									 m_com.m_vars.add($2,$$); 
								  } else $$ = 1; 
							}
	| VARS	'@' 			{ if (!m_com.miss){
									 $$ = m_com.m_vars.get($1);
									 m_com.m_vars.add($1,$$+fraction::one); 
								  } else $$ = 1; 
							}
	| '%' VARS				{ if (!m_com.miss){
									 $$ = m_com.m_vars.get($2)-fraction::one;
									 m_com.m_vars.add($2,$$); 
								  } else $$ = 1; 
							}
	| VARS	'%' 			{ if (!m_com.miss){
									 $$ = m_com.m_vars.get($1);
									 m_com.m_vars.add($1,$$-fraction::one); 
								  } else $$ = 1; 
							}
	| VARS '=' expr				{ if (!m_com.miss){
										m_com.m_vars.add($1,$3); 
										$$ = $3;
									} else
										$$ = 1;
							}
	| VARS '(' expr ')'		{ if (!m_com.miss && m_com.condition() != DESCRIPTION_FUNCTION){
										m_com.param.push($3);
										global_name = m_com.global($1);
										if (m_com.functions.is_key(global_name.c_str()) != 0)
											execerror("Can't find this function");
										else {
											if (strcmp($1,"numerator") == 0)
												$$ = $3.numerator();
											else if (strcmp($1,"denominator") == 0)
												$$ = $3.denominator();
											else if (strcmp($1,"integer") == 0)
												$$ = $3.integer();
											else {										 
												m_com.run_func(global_name.c_str());	
												longjmp(begin, 0);
											}
										}
										} else
										$$ = 1;
							}
	| expr '^' expr 				{ if (!m_com.miss) $$ = $1 ^ $3; else $$ = 1; }
	| expr '+' expr 				{ if (!m_com.miss) $$ = $1 + $3; else $$ = 1; }
	| expr '-' expr 				{ if (!m_com.miss) $$ = $1 - $3; else $$ = 1; }
	| expr '*' expr 				{ if (!m_com.miss) $$ = $1 * $3; else $$ = 1; }
	| expr '/' expr 				{ if (!m_com.miss) {if ($3 == fraction::zer) execerror("Division by zero"); $$ = $1 / $3;} else $$ = 1;}
	| '(' expr ')' 					{ if (!m_com.miss) $$ = $2; else $$ = 1; }
	| '-' expr %prec UNARMINUS		{ if (!m_com.miss) $$ = -$2; else $$ = 1; }
	| expr '<' expr				{ if (!m_com.miss) $$ = ($1 < $3); else $$ = 1;}
	| expr '>' expr				{ if (!m_com.miss) $$ = ($1 > $3); else $$ = 1;}
	| expr '<''=' expr				{ if (!m_com.miss) $$ = ($1 <= $4); else $$ = 1;}
	| expr '>''=' expr				{ if (!m_com.miss) $$ = ($1 >= $4); else $$ = 1;}
	| expr '#' expr				{ if (!m_com.miss) $$ = ($1 != $3); else $$ = 1;}
	| expr '?' expr				{ if (!m_com.miss) $$ = ($1 == $3); else $$ = 1;}
	| expr '|''|' expr				{ if (!m_com.miss) $$ = ($1 || $4); else $$ = 1;}
	| expr '&''&' expr				{ if (!m_com.miss) $$ = ($1 && $4); else $$ = 1;}
	| '!' expr					{ if (!m_com.miss) $$ = $2.negation(); else $$ = 1;}
	| expr ',' expr				{ if (!m_com.miss) {m_com.param.push($1); $$ = $3;} else $$ = 1;}
	;
%%

int yylex(){
	int t = m_com.nextlex(FRACT, VARS);  
	if (t == FRACT){
		yylval.fractions = m_com.get_fract();
	}
	if (t == VARS){
		yylval.vars = m_com.get_vars();
	}
	return t;
}
void yyerror(char *s){
	execerror(s);
}

void execerror(char *s){	
	m_com.error_line(s);
	m_com.Init();
	longjmp(begin, 0);
}

void fpecatch(int){
	signal(SIGFPE, fpecatch);
	execerror("floating point exception");
}

char *help[]={"\n\tfraccalc - an exact precision calculator language.",
"\n\n\n\tfraccalc [-h/--help] [-f/--file] [-l/--libs] [-V/--version]",
"\n\n\t-h/--help",
"\t\t - print the usage and exit.",
"\n\n\t-f/--file filename",
"\t - obtain commands from file and exit",
"\n\n\t-l/--lib filename",
"\t - obtain commands from file",
"\n\n\t-V/--version",
"\t\t - print the version number.\n\n",
};

int main(int argc, char *argv[]){
	for (int i = 1; i < argc; ++i){
		if(!strcmp(argv[i],"--help") || !strcmp(argv[i],"-h")){
			for(int i = 0; i < 10;++i)
				std::cout << help[i];
			exit(0);
		}
		if(!strcmp(argv[i],"--file") || !strcmp(argv[i],"-f")){
			m_com.open_file(argv[++i],0);
			continue;
		}
		if(!strcmp(argv[i],"--version") || !strcmp(argv[i],"-V")){
			std::cout << "\n\tfraccalc version 1.00";
			exit(0);
		}
		if(!strcmp(argv[i],"--lib") || !strcmp(argv[i],"-l")){
			m_com.open_file(argv[++i],1);
			continue;
		}
		m_com.open_file(argv[i],1);
	}
	m_com.Init();
	setjmp(begin);
	signal(SIGFPE, fpecatch);
	signal(SIGINT, exit);
	signal(SIGTERM, exit);
	yyparse();
	return 0;
}
