/* ############################################################
 * Programm zur Berechnung von "ausgeschriebenen Zahlen".
 * Autor: Helmut Fahrion
 * E-Mail: hefa@gmx.net
 * Lizenz:  
 * Datum: 06.2004
 * ############################################################
 */


#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>

#include "hecalc-version.h"  // Versionsnummer

int expotential, batch, expz;
char expstr[256];
char *ergebnis = "Ergebnis: ";

/* Declaration stellt Warnings ab */
int yyerror (char *s);  /* Called by yyparse on error */
int yylex ( void ); 

int yyerror (char *s)  /* Called by yyparse on error */
{
  printf ("%s\n", s);
  // Doch kein Exit, da der Rechner sonst bei jeden
  // Tippfehler beendet wird.
  //exit(0);
}


// das sind die Kommandozeilenargumente
static const struct option long_options[] = {
  {"hilfe", 0, 0, '?'},
  {"help", 0, 0, 'h'},
  {"version", 0, 0, 'v'},
  {"batch", 0, 0, 'b'},
  {"exp", 1, 0, 'e'},
  {0, 0, 0, 0}
};

// der Hilfetext der ausgegeben wird
char *usage = "Hilfe:\n"
  "------------------------------------------------------------------\n"
  "Notation:  %s [--version|-v] [--help|-h|--hilfe] [--batch|-b]\n"
  "--version|-v \n"
  "gibt die Version aus.\n\n"
  "--help|-h|--hilfe\n"
  "gibt diesen Hilfetext aus.\n\n"
  "--batch|-b\n"
  "Unterdrckt alle Interaktionen. Ist wichtig um die Ausgaben\n"
  "Programmtechnisch verabeiten zu knnen.\n\n"
  "--exp num |-e num\n"
  "Gibt in Expotentialschreibweise aus, wobei n die Anzahl der Stellen ist.\n"
  "Beispiel: \n"
  ">tcalc -b < file.aufgaben\n\n"
  "Gibt alle Ergebnisse aus. In file.aufgaben ist jede Zeile eine\n"
  "Bitte lesen Sie die Datei README fr Detailierte Informationen zu der Syntax der Kommandozeile!\n"
  "Berechnungsformel.\n\n";

// ----------------------------------------------------------------------



int main (int argc, char ** argv) 
{ 
   int opt;
   expotential = batch = 0;
   
    while ((opt =
	  getopt_long (argc, argv, "h?vcbe:", long_options, NULL)) != EOF)
    {
      switch (opt)
	{
	case 'b':
	  batch = 1;
	  break;
	case 'e':
	  expotential = 1;
	  expz = atoi (optarg);
	  break;
	case 'v':
	  printf ("Version: %s\n", version);
	  return 0;
	  break;
	case '?':
	case 'h':
	  printf (usage, argv[0]);
	  return 0;
	  break;

	default:
	  printf ("?? getopt returned character code 0%o ??\n", opt);
	  break;
	}
    }

  if (!batch)
   printf("hefa-calc:\n");
  
  if (expotential)
    {
      if (batch)
	sprintf (expstr, "%%.%dE\n", expz);
      else
	sprintf (expstr, "%s%%.%dE\n\n", ergebnis, expz);
    }
  else
    {
      if (batch)
	sprintf (expstr, "%%lf\n");
      else
	sprintf (expstr, "%s%%lf\n\n", ergebnis);
    }


  // Dadurch geht es beim Parse Error weiter
  while (1)
    yyparse (); 
}


