
%{
#define _GNU_SOURCE
#include <math.h>
#include <tgmath.h>
#include <stdio.h>
#include <stdlib.h>
#define YYERROR_VERBOSE 1

/* Declaration stellt Warnings ab */
int yyerror (char *s);  /* Called by yyparse on error */
int yylex ( void ); 

extern int expotential, batch, expz;
extern char expstr[256];

double memory;
double ergebnis_num;
int    fraction;
long int  longint;

%}
 
%union {
  double val;  /* Zahlen */
  char  *str;  /* Zeichenkette */
}

/* Konstanten */
%token <val> NUM

%token <str> ACOS
%token <str> ASIN
%token <str> ATAN
%token <str> COS 
%token <str> SIN 
%token <str> TAN 
%token <str> ACOSH
%token <str> ASINH
%token <str> ATANH
%token <str> COSH
%token <str> SINH
%token <str> TANH

%token <str> EXP 
%token <str> FREXP
%token <str> LDEXP
%token <str> LOG 
%token <str> LOG10
%token <str> EXPM1
%token <str> LOG1P
%token <str> LOGB
%token <str> EXP2
%token <str> LOG2

%token <str> POW 
%token <str> SQRT
%token <str> HYPOT
%token <str> CBRT

%token <str> CEIL 
%token <str> FABS 
%token <str> FLOOR
%token <str> FMOD 
%token <str> NBI  
%token <str> ROUND
%token <str> TRUNC
%token <str> REMQUO
%token <str> LRINT	 
%token <str> LROUND	 
%token <str> COPYSIGN
%token <str> ERF   
%token <str> ERFC  
%token <str> TGAMMA
%token <str> LGAMMA

%token <str> RINT		
%token <str> NEXTAFTER	
%token <str> NEXTTOWARD	
%token <str> REMAINDER	
%token <str> SCALB	 	
%token <str> SCALBN	 	
%token <str> SCALBLN 	
%token <str> ILOGB		
%token <str> FDIM		
%token <str> FMAX		
%token <str> FMIN		
%token <str> FMA		
%token <str> CARG		
%token <str> CONJ		
%token <str> CPROJ		
%token <str> CIMAG		
%token <str> CREAL		


%token <str> CONST_pi
%token <str> CONST_e
%token <str> CONST_log2e
%token <str> CONST_log10e
%token <str> CONST_ln2
%token <str> CONST_ln10
%token <str> CONST_pi_2
%token <str> CONST_pi_4
%token <str> CONST_1_pi
%token <str> CONST_2_pi
%token <str> CONST_2_sqrtpi
%token <str> CONST_sqrt2
%token <str> CONST_sqrt1_2



%token <str> MEM
%token <str> ERG

%token <str> MILLION
%token <str> BILLION
%token <str> TRILION
%token <str> MILLIARDE

%token <str> TRILLION
%token <str> QUADRILLION
%token <str> QUINTILLION
%token <str> SEXTILLION
%token <str> SEPTILLION
%token <str> OCTILLION 
%token <str> NONILLION
%token <str> DECILLION
%token <str> UNDECILLION
%token <str> DUODECILLION
%token <str> TREDECILLION
%token <str> QUINDECILLION
%token <str> SEXDECILLION
%token <str> SEPTENDECILLION
%token <str> OCTODECILLION
%token <str> NOVEMDECILLION
%token <str> VIGINTILLION
%token <str> CENTILLION 
%token <str> QUATTUORDECILLION


%token <str> HUNDERT
%token <str> TAUSEND
%token <str> UND
%token <str> EINS
%token <str> ZWEI
%token <str> DREI
%token <str> VIER
%token <str> FUENF
%token <str> SECHS
%token <str> SECH
%token <str> SIEBEN
%token <str> SIEB
%token <str> ACHT
%token <str> EIN
%token <str> EINE
%token <str> NEUN
%token <str> ZEHN
%token <str> ELF
%token <str> ZWOELF
%token <str> ZWAN
%token <str> DREISSIG
%token <str> ZIG

%type <val> trillion
%type <val> trillionrest

%type <val> quadrillion
%type <val> quadrillionrest
%type <val> quintillion
%type <val> quintillionrest
%type <val> sextillion
%type <val> sextillionrest

%type <val> centillion 
%type <val> centillionrest
%type <val> septillion
%type <val> septillionrest
%type <val> octillion 
%type <val> octillionrest
%type <val> nonillion
%type <val> nonillionrest
%type <val> decillion
%type <val> decillionrest
%type <val> undecillion
%type <val> undecillionrest
%type <val> duodecillion
%type <val> duodecillionrest
%type <val> tredecillion
%type <val> tredecillionrest
%type <val> quindecillion
%type <val> quindecillionrest
%type <val> sexdecillion
%type <val> sexdecillionrest
%type <val> septendecillion
%type <val> septendecillionrest
%type <val> octodecillion
%type <val> octodecillionrest
%type <val> novemdecillion
%type <val> novemdecillionrest
%type <val> vigintillion
%type <val> vigintillionrest
%type <val> quattuordecillion
%type <val> quattuordecillionrest


%type <val> milliarde
%type <val> milliarderest
%type <val> billion
%type <val> billionrest
%type <val> mille
%type <val> milleklein
%type <val> millerest
%type <val> tausender
%type <val> tausendrest
%type <val> hunderter
%type <val> hundertrest
%type <val> und
%type <val> eint
%type <val> ein
%type <val> eine
%type <val> einer
%type <val> zwne
%type <val> vierfuenf
%type <val> einziger
%type <val> sech
%type <val> zwan
%type <val> zehner
%type <val> ziger


%type <val> pi
%type <val> line
%type <val> exp
%type <val> term
%type <val> po
%type <val> factor
%type <val> sub
%type <val> func
%type <val> mem

%left '-' '+'

%%

input	:
	| input '\n' 
	| input line
	;

line 	: mem '\n'    { printf (expstr, $1);ergebnis_num=$1; } 
	;
      
mem	: MEM '=' exp { $$ = memory = $3; }
	| exp
	; 
      
exp	: exp '+' term { $$ = $1 + $3; }
	| exp '-' term { $$ = $1 - $3; }
	| term
	;

term	: term '*' po { $$ = $1 * $3; }
	| term '/' po { $$ = $1 / $3; }
	| po
	;
	
po	: po '^' factor { $$ = pow($1,$3); }
	| factor
	;

factor	: '(' exp ')' { $$ = $2; }
	| sub
	;

sub	: '-' factor     { $$ = -$2; }
	| pi
	;

pi	: CONST_pi	{ $$ = M_PIl;  }
	| CONST_e 	{ $$ = M_El; }
	| CONST_log2e 	{ $$ = M_LOG2El; }
	| CONST_log10e 	{ $$ = M_LOG10El; }
	| CONST_ln2 	{ $$ = M_LN2l; }
	| CONST_ln10 	{ $$ = M_LN10l; }
	| CONST_pi_2 	{ $$ = M_PI_2l; }
	| CONST_pi_4 	{ $$ = M_PI_4l; }
	| CONST_1_pi 	{ $$ = M_1_PIl; }
	| CONST_2_pi 	{ $$ = M_2_PIl; }
	| CONST_2_sqrtpi{ $$ = M_2_SQRTPIl; }
	| CONST_sqrt2 	{ $$ = M_SQRT2l; }
	| CONST_sqrt1_2 { $$ = M_SQRT1_2l; }
	| func
	; 

func	: ACOS '(' exp ')' { $$ = acos ( $3 ); }
	| ASIN '(' exp ')' { $$ = asin ( $3 ); }
	| ATAN '(' exp ')' { $$ = atan ( $3 ); }
	| COS  '(' exp ')' { $$ = cos ( $3 ); }
	| SIN  '(' exp ')' { $$ = sin ( $3 ); }
	| TAN  '(' exp ')' { $$ = tan ( $3 ); }
	| ACOSH '(' exp ')' { $$ = acosh ( $3 ); }
	| ASINH '(' exp ')' { $$ =asinh  ( $3 ); }
	| ATANH '(' exp ')' { $$ = atanh ( $3 ); }
	| COSH '(' exp ')' { $$ = cosh   ( $3 ); }
	| SINH '(' exp ')' { $$ = sinh   ( $3 ); }
	| TANH '(' exp ')' { $$ = tanh   ( $3 ); }

	| EXP   '(' exp ')'  { $$ = exp  ( $3 ); }
	| FREXP '(' exp ')'  { $$ = frexp( $3, & fraction); memory = (double)fraction; }
	
	| LDEXP '(' exp ',' exp ')'  { $$ = ldexp( $3, $5 ); }

	| LOG   '(' exp ')'  { $$ = log  ( $3 ); }
	| LOG10 '(' exp ')'  { $$ = log10( $3 ); }
	| EXPM1 '(' exp ')'  { $$ = expm1( $3 ); }
	| LOG1P '(' exp ')'  { $$ = log1p( $3 ); }
	| LOGB  '(' exp ')'  { $$ = logb ( $3 ); } 
	| EXP2  '(' exp ')'  { $$ = exp2 ( $3 ); }
	| LOG2  '(' exp ')'  { $$ = log2 ( $3 ); }

	| POW 	'(' exp ',' exp ')'  { $$ = pow ( $3, $5 ); }
	| SQRT	'(' exp ')'  { $$ = sqrt( $3 ); }
	| HYPOT	'(' exp ',' exp ')'  { $$ = hypot( $3, $5 ); }
	| CBRT	'(' exp ')'  { $$ = cbrt( $3 ); }

	| CEIL '(' exp ')'  { $$ =  ceil ( $3 ); }
	| FABS '(' exp ')'  { $$ =  fabs ( $3 ); }
	| FLOOR'(' exp ')'  { $$ =  floor( $3 ); }
	| FMOD '(' exp ',' exp ')'  { $$ =  fmod ( $3, $5 ); }
	| NBI  '(' exp ')'  { $$ =  nearbyint  ( $3 ); } 
	| ROUND'(' exp ')'  { $$ =  round( $3 ); }
	| TRUNC'(' exp ')'  { $$ =  trunc( $3 ); }

	| REMQUO'(' exp ',' exp ')' { $$ =  remquo ( $3, $5, &fraction );memory = (double)fraction;  }

	| LRINT	  '(' exp ')'  { $$ = 	lrint	 ( $3 ); }
	| LROUND  '(' exp ')'  { $$ =   lround   ( $3 ); }    
	| COPYSIGN '(' exp ',' exp ')'  { $$ = 	copysign  ( $3, $5 ); }

	| ERF   '(' exp ')'  { $$ =erf    ( $3 ); }
	| ERFC  '(' exp ')'  { $$ =erfc   ( $3 ); }
	| TGAMMA'(' exp ')'  { $$ =tgamma ( $3 ); }
	| LGAMMA'(' exp ')'  { $$ =lgamma ( $3 ); }

	| RINT		'(' exp ')'  { $$ =rint ( $3 ); }
	| NEXTAFTER	'(' exp ',' exp ')' { $$ =nextafter( $3, $5 ); }
	| NEXTTOWARD	'(' exp ',' exp ')' { $$ =nexttoward( $3, $5 ); }
	| REMAINDER	'(' exp ',' exp ')' { $$ =remainder( $3, $5 ); }
	| SCALB	 	'(' exp ',' exp ')' { $$ =scalb	 ( $3, $5 ); }
	| SCALBN	'(' exp ',' exp ')' { $$ =scalbn( $3, $5 ); }
	| SCALBLN 	'(' exp ',' exp ')' { $$ =scalbln ( $3, $5 ); }
	| ILOGB		'(' exp ')'  { $$ =ilogb( $3 ); }
	| FDIM		'(' exp',' exp ')'  { $$ =fdim( $3, $5 ); }
	| FMAX		'(' exp',' exp ')'  { $$ =fmax( $3, $5 ); }
	| FMIN		'(' exp',' exp ')'  { $$ =fmin( $3, $5 ); }
	| FMA		'(' exp',' exp',' exp ')' { $$=fma( $3, $5, $7);}
	| CARG		'(' exp ')'  { $$ = carg($3); }
	| CONJ		'(' exp ')'  { $$ = conj($3); }
	| CPROJ		'(' exp ')'  { $$ = cproj($3); }
	| CIMAG		'(' exp ')'  { $$ = cimag($3); }
	| CREAL		'(' exp ')'  { $$ = creal($3); }

	| MEM	 { $$ = memory ;} /* Zwischenergebnis speichern */
	| ERG	 { $$ = ergebnis_num; } /* Zugriff auf das letzte Ergebnis */
	| centillion  /* gibt inf  ... naja */
	
	| vigintillion
	| novemdecillion
	| octodecillion
	| septendecillion
	| sexdecillion
	| quindecillion
	| quattuordecillion
	| tredecillion
	| duodecillion
	| undecillion
	| decillion
	| nonillion
	| octillion
	| septillion
	| sextillion
	| quintillion
	| quadrillion
	| trillion
	| billion
	| milliarde
	| mille
	| tausender
	| hunderter
	| und
	| ziger
	| zehner
	| einer
	| NUM
	;

centillion : centillionrest 		{ $$ = $1; }
	| eine      centillionrest	{ $$ = $1 * 1e600 + $2 - 1e600; }
	| zehner    centillionrest	{ $$ = $1 * 1e600 + $2 - 1e600; }
	| ziger     centillionrest	{ $$ = $1 * 1e600 + $2 - 1e600; }
	| und 	    centillionrest	{ $$ = $1 * 1e600 + $2 - 1e600; }
	| hunderter centillionrest	{ $$ = $1 * 1e600 + $2 - 1e600; }
	| tausender centillionrest	{ $$ = $1 * 1e600 + $2 - 1e600; }
	;

centillionrest : CENTILLION		{ $$ = 1e600; }
	|CENTILLION 	einer		{ $$ = 1e600 + $2; }
	|CENTILLION	zehner		{ $$ = 1e600 + $2; }
	|CENTILLION	ziger		{ $$ = 1e600 + $2; }
	|CENTILLION	und		{ $$ = 1e600 + $2; }
	|CENTILLION	hunderter	{ $$ = 1e600 + $2; }
	|CENTILLION	tausender	{ $$ = 1e600 + $2; }
	|CENTILLION	mille		{ $$ = 1e600 + $2; }
	|CENTILLION	milliarde 	{ $$ = 1e600 + $2; }
	|CENTILLION	billion		{ $$ = 1e600 + $2; }
	|CENTILLION	trillion	{ $$ = 1e600 + $2; }
	|CENTILLION	quadrillion	{ $$ = 1e600 + $2; }
	|CENTILLION	quintillion 	{ $$ = 1e600 + $2; }
	|CENTILLION	sextillion 	{ $$ = 1e600 + $2; }
	|CENTILLION	septillion 	{ $$ = 1e600 + $2; }
	|CENTILLION	octillion 	{ $$ = 1e600 + $2; }
	|CENTILLION	nonillion 	{ $$ = 1e600 + $2; }
	|CENTILLION	decillion 	{ $$ = 1e600 + $2; }
	|CENTILLION	undecillion 	{ $$ = 1e600 + $2; }
	|CENTILLION	duodecillion 	{ $$ = 1e600 + $2; }
	|CENTILLION	tredecillion 	{ $$ = 1e600 + $2; }
	|CENTILLION	quindecillion 	{ $$ = 1e600 + $2; }
	|CENTILLION	quattuordecillion{ $$ = 1e600 + $2; }
	|CENTILLION	sexdecillion 	{ $$ = 1e600 + $2; }
	|CENTILLION	septendecillion	{ $$ = 1e600 + $2; }
	|CENTILLION	octodecillion	{ $$ = 1e600 + $2; }
	|CENTILLION	novemdecillion	{ $$ = 1e600 + $2; }
	|CENTILLION	vigintillion	{ $$ = 1e600 + $2; }
	;

vigintillion : vigintillionrest 		{ $$ = $1; }
	| eine      vigintillionrest	{ $$ = $1 * 1e120 + $2 - 1e120; }
	| zehner    vigintillionrest	{ $$ = $1 * 1e120 + $2 - 1e120; }
	| ziger     vigintillionrest	{ $$ = $1 * 1e120 + $2 - 1e120; }
	| und 	    vigintillionrest	{ $$ = $1 * 1e120 + $2 - 1e120; }
	| hunderter vigintillionrest	{ $$ = $1 * 1e120 + $2 - 1e120; }
	| tausender vigintillionrest	{ $$ = $1 * 1e120 + $2 - 1e120; }
	;

vigintillionrest : VIGINTILLION		{ $$ = 1e120; }
	|VIGINTILLION einer		{ $$ = 1e120 + $2; }
	|VIGINTILLION zehner		{ $$ = 1e120 + $2; }
	|VIGINTILLION ziger		{ $$ = 1e120 + $2; }
	|VIGINTILLION und		{ $$ = 1e120 + $2; }
	|VIGINTILLION hunderter		{ $$ = 1e120 + $2; }
	|VIGINTILLION tausender		{ $$ = 1e120 + $2; }
	|VIGINTILLION mille		{ $$ = 1e120 + $2; }
	|VIGINTILLION milliarde 	{ $$ = 1e120 + $2; }
	|VIGINTILLION billion		{ $$ = 1e120 + $2; }
	|VIGINTILLION trillion		{ $$ = 1e120 + $2; }
	|VIGINTILLION quadrillion	{ $$ = 1e120 + $2; }
	|VIGINTILLION quintillion 	{ $$ = 1e120 + $2; }
	|VIGINTILLION sextillion	{ $$ = 1e120 + $2; }
	|VIGINTILLION septillion	{ $$ = 1e120 + $2; }
	|VIGINTILLION octillion 	{ $$ = 1e120 + $2; }
	|VIGINTILLION nonillion 	{ $$ = 1e120 + $2; }
	|VIGINTILLION decillion 	{ $$ = 1e120 + $2; }
	|VIGINTILLION undecillion 	{ $$ = 1e120 + $2; }
	|VIGINTILLION duodecillion 	{ $$ = 1e120 + $2; }
	|VIGINTILLION tredecillion 	{ $$ = 1e120 + $2; }
	|VIGINTILLION quattuordecillion	{ $$ = 1e120 + $2; }
	|VIGINTILLION quindecillion 	{ $$ = 1e120 + $2; }
	|VIGINTILLION sexdecillion 	{ $$ = 1e120 + $2; }
	|VIGINTILLION septendecillion 	{ $$ = 1e120 + $2; }
	|VIGINTILLION octodecillion 	{ $$ = 1e120 + $2; }
	|VIGINTILLION novemdecillion 	{ $$ = 1e120 + $2; }
	;

novemdecillion : novemdecillionrest 	{ $$ = $1; }
	| eine      novemdecillionrest	{ $$ = $1 * 1e114 + $2 - 1e114; }
	| zehner    novemdecillionrest	{ $$ = $1 * 1e114 + $2 - 1e114; }
	| ziger     novemdecillionrest	{ $$ = $1 * 1e114 + $2 - 1e114; }
	| und 	    novemdecillionrest	{ $$ = $1 * 1e114 + $2 - 1e114; }
	| hunderter novemdecillionrest	{ $$ = $1 * 1e114 + $2 - 1e114; }
	| tausender novemdecillionrest	{ $$ = $1 * 1e114 + $2 - 1e114; }
	;

novemdecillionrest : NOVEMDECILLION	{ $$ = 1e114; }
	|NOVEMDECILLION einer		{ $$ = 1e114 + $2; }
	|NOVEMDECILLION zehner		{ $$ = 1e114 + $2; }
	|NOVEMDECILLION ziger		{ $$ = 1e114 + $2; }
	|NOVEMDECILLION und		{ $$ = 1e114 + $2; }
	|NOVEMDECILLION hunderter	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION tausender	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION mille		{ $$ = 1e114 + $2; }
	|NOVEMDECILLION milliarde 	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION billion		{ $$ = 1e114 + $2; }
	|NOVEMDECILLION trillion	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION quadrillion	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION quintillion 	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION sextillion	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION septillion	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION octillion 	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION nonillion 	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION decillion 	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION undecillion 	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION duodecillion 	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION tredecillion 	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION quattuordecillion{ $$ = 1e114 + $2; }
	|NOVEMDECILLION quindecillion 	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION sexdecillion 	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION septendecillion	{ $$ = 1e114 + $2; }
	|NOVEMDECILLION octodecillion 	{ $$ = 1e114 + $2; }
	;

octodecillion : octodecillionrest 	{ $$ = $1; }
	| eine      octodecillionrest	{ $$ = $1 * 1e108 + $2 - 1e108; }
	| zehner    octodecillionrest	{ $$ = $1 * 1e108 + $2 - 1e108; }
	| ziger     octodecillionrest	{ $$ = $1 * 1e108 + $2 - 1e108; }
	| und 	    octodecillionrest	{ $$ = $1 * 1e108 + $2 - 1e108; }
	| hunderter octodecillionrest	{ $$ = $1 * 1e108 + $2 - 1e108; }
	| tausender octodecillionrest	{ $$ = $1 * 1e108 + $2 - 1e108; }
	;

octodecillionrest : OCTODECILLION	{ $$ = 1e108; }
	|OCTODECILLION einer		{ $$ = 1e108 + $2; }
	|OCTODECILLION zehner		{ $$ = 1e108 + $2; }
	|OCTODECILLION ziger		{ $$ = 1e108 + $2; }
	|OCTODECILLION und		{ $$ = 1e108 + $2; }
	|OCTODECILLION hunderter	{ $$ = 1e108 + $2; }
	|OCTODECILLION tausender	{ $$ = 1e108 + $2; }
	|OCTODECILLION mille		{ $$ = 1e108 + $2; }
	|OCTODECILLION milliarde 	{ $$ = 1e108 + $2; }
	|OCTODECILLION billion		{ $$ = 1e108 + $2; }
	|OCTODECILLION trillion		{ $$ = 1e108 + $2; }
	|OCTODECILLION quadrillion	{ $$ = 1e108 + $2; }
	|OCTODECILLION quintillion 	{ $$ = 1e108 + $2; }
	|OCTODECILLION sextillion	{ $$ = 1e108 + $2; }
	|OCTODECILLION septillion	{ $$ = 1e108 + $2; }
	|OCTODECILLION octillion 	{ $$ = 1e108 + $2; }
	|OCTODECILLION nonillion 	{ $$ = 1e108 + $2; }
	|OCTODECILLION decillion 	{ $$ = 1e108 + $2; }
	|OCTODECILLION undecillion 	{ $$ = 1e108 + $2; }
	|OCTODECILLION duodecillion 	{ $$ = 1e108 + $2; }
	|OCTODECILLION tredecillion 	{ $$ = 1e108 + $2; }
	|OCTODECILLION quattuordecillion{ $$ = 1e108 + $2; }
	|OCTODECILLION quindecillion 	{ $$ = 1e108 + $2; }
	|OCTODECILLION sexdecillion 	{ $$ = 1e108 + $2; }
	|OCTODECILLION septendecillion 	{ $$ = 1e108 + $2; }
	;

septendecillion : septendecillionrest 	{ $$ = $1; }
	| eine      septendecillionrest	{ $$ = $1 * 1e102 + $2 - 1e102; }
	| zehner    septendecillionrest	{ $$ = $1 * 1e102 + $2 - 1e102; }
	| ziger     septendecillionrest	{ $$ = $1 * 1e102 + $2 - 1e102; }
	| und 	    septendecillionrest	{ $$ = $1 * 1e102 + $2 - 1e102; }
	| hunderter septendecillionrest	{ $$ = $1 * 1e102 + $2 - 1e102; }
	| tausender septendecillionrest	{ $$ = $1 * 1e102 + $2 - 1e102; }
	;

septendecillionrest : SEPTENDECILLION	{ $$ = 1e102; }
	|SEPTENDECILLION einer		{ $$ = 1e102 + $2; }
	|SEPTENDECILLION zehner		{ $$ = 1e102 + $2; }
	|SEPTENDECILLION ziger		{ $$ = 1e102 + $2; }
	|SEPTENDECILLION und		{ $$ = 1e102 + $2; }
	|SEPTENDECILLION hunderter	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION tausender	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION mille		{ $$ = 1e102 + $2; }
	|SEPTENDECILLION milliarde 	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION billion	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION trillion	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION quadrillion	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION quintillion 	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION sextillion	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION septillion	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION octillion 	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION nonillion 	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION decillion 	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION undecillion 	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION duodecillion 	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION tredecillion 	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION quattuordecillion{ $$ = 1e102 + $2; }
	|SEPTENDECILLION quindecillion 	{ $$ = 1e102 + $2; }
	|SEPTENDECILLION sexdecillion 	{ $$ = 1e102 + $2; }
	;

sexdecillion : sexdecillionrest 	{ $$ = $1; }
	| eine      sexdecillionrest	{ $$ = $1 * 1e96 + $2 - 1e96; }
	| zehner    sexdecillionrest	{ $$ = $1 * 1e96 + $2 - 1e96; }
	| ziger     sexdecillionrest	{ $$ = $1 * 1e96 + $2 - 1e96; }
	| und 	    sexdecillionrest	{ $$ = $1 * 1e96 + $2 - 1e96; }
	| hunderter sexdecillionrest	{ $$ = $1 * 1e96 + $2 - 1e96; }
	| tausender sexdecillionrest	{ $$ = $1 * 1e96 + $2 - 1e96; }
	;

sexdecillionrest : SEXDECILLION		{ $$ = 1e96; }
	|SEXDECILLION einer		{ $$ = 1e96 + $2; }
	|SEXDECILLION zehner		{ $$ = 1e96 + $2; }
	|SEXDECILLION ziger		{ $$ = 1e96 + $2; }
	|SEXDECILLION und		{ $$ = 1e96 + $2; }
	|SEXDECILLION hunderter		{ $$ = 1e96 + $2; }
	|SEXDECILLION tausender		{ $$ = 1e96 + $2; }
	|SEXDECILLION mille		{ $$ = 1e96 + $2; }
	|SEXDECILLION milliarde 	{ $$ = 1e96 + $2; }
	|SEXDECILLION billion		{ $$ = 1e96 + $2; }
	|SEXDECILLION trillion		{ $$ = 1e96 + $2; }
	|SEXDECILLION quadrillion	{ $$ = 1e96 + $2; }
	|SEXDECILLION quintillion 	{ $$ = 1e96 + $2; }
	|SEXDECILLION sextillion	{ $$ = 1e96 + $2; }
	|SEXDECILLION septillion	{ $$ = 1e96 + $2; }
	|SEXDECILLION octillion 	{ $$ = 1e96 + $2; }
	|SEXDECILLION nonillion 	{ $$ = 1e96 + $2; }
	|SEXDECILLION decillion 	{ $$ = 1e96 + $2; }
	|SEXDECILLION undecillion 	{ $$ = 1e96 + $2; }
	|SEXDECILLION duodecillion 	{ $$ = 1e96 + $2; }
	|SEXDECILLION tredecillion 	{ $$ = 1e96 + $2; }
	|SEXDECILLION quattuordecillion	{ $$ = 1e96 + $2; }
	|SEXDECILLION quindecillion 	{ $$ = 1e96 + $2; }
	;

quindecillion : quindecillionrest 	{ $$ = $1; }
	| eine      quindecillionrest	{ $$ = $1 * 1e90 + $2 - 1e90; }
	| zehner    quindecillionrest	{ $$ = $1 * 1e90 + $2 - 1e90; }
	| ziger     quindecillionrest	{ $$ = $1 * 1e90 + $2 - 1e90; }
	| und 	    quindecillionrest	{ $$ = $1 * 1e90 + $2 - 1e90; }
	| hunderter quindecillionrest	{ $$ = $1 * 1e90 + $2 - 1e90; }
	| tausender quindecillionrest	{ $$ = $1 * 1e90 + $2 - 1e90; }
	;

quindecillionrest : QUINDECILLION	{ $$ = 1e90; }
	|QUINDECILLION einer		{ $$ = 1e90 + $2; }
	|QUINDECILLION zehner		{ $$ = 1e90 + $2; }
	|QUINDECILLION ziger		{ $$ = 1e90 + $2; }
	|QUINDECILLION und		{ $$ = 1e90 + $2; }
	|QUINDECILLION hunderter	{ $$ = 1e90 + $2; }
	|QUINDECILLION tausender	{ $$ = 1e90 + $2; }
	|QUINDECILLION mille		{ $$ = 1e90 + $2; }
	|QUINDECILLION milliarde 	{ $$ = 1e90 + $2; }
	|QUINDECILLION billion		{ $$ = 1e90 + $2; }
	|QUINDECILLION trillion		{ $$ = 1e90 + $2; }
	|QUINDECILLION quadrillion	{ $$ = 1e90 + $2; }
	|QUINDECILLION quintillion 	{ $$ = 1e90 + $2; }
	|QUINDECILLION sextillion	{ $$ = 1e90 + $2; }
	|QUINDECILLION septillion	{ $$ = 1e90 + $2; }
	|QUINDECILLION octillion 	{ $$ = 1e90 + $2; }
	|QUINDECILLION nonillion 	{ $$ = 1e90 + $2; }
	|QUINDECILLION decillion 	{ $$ = 1e90 + $2; }
	|QUINDECILLION undecillion 	{ $$ = 1e90 + $2; }
	|QUINDECILLION duodecillion 	{ $$ = 1e90 + $2; }
	|QUINDECILLION tredecillion 	{ $$ = 1e90 + $2; }
	|QUINDECILLION quattuordecillion	{ $$ = 1e90 + $2; }
	;

quattuordecillion : quattuordecillionrest 	{ $$ = $1; }
	| eine      quattuordecillionrest	{ $$ = $1 * 1e84 + $2 - 1e84; }
	| zehner    quattuordecillionrest	{ $$ = $1 * 1e84 + $2 - 1e84; }
	| ziger     quattuordecillionrest	{ $$ = $1 * 1e84 + $2 - 1e84; }
	| und 	    quattuordecillionrest	{ $$ = $1 * 1e84 + $2 - 1e84; }
	| hunderter quattuordecillionrest	{ $$ = $1 * 1e84 + $2 - 1e84; }
	| tausender quattuordecillionrest	{ $$ = $1 * 1e84 + $2 - 1e84; }
	;

quattuordecillionrest : QUATTUORDECILLION	{ $$ = 1e84; }
	|QUATTUORDECILLION einer	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION zehner	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION ziger	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION und		{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION hunderter	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION tausender	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION mille	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION milliarde 	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION billion	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION trillion	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION quadrillion	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION quintillion 	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION sextillion	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION septillion	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION octillion 	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION nonillion 	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION decillion 	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION undecillion 	{ $$ = 1e84 + $2; }
	|QUATTUORDECILLION duodecillion { $$ = 1e84 + $2; }
	|QUATTUORDECILLION tredecillion { $$ = 1e84 + $2; }
	;


tredecillion : tredecillionrest 	{ $$ = $1; }
	| eine      tredecillionrest	{ $$ = $1 * 1e78 + $2 - 1e78; }
	| zehner    tredecillionrest	{ $$ = $1 * 1e78 + $2 - 1e78; }
	| ziger     tredecillionrest	{ $$ = $1 * 1e78 + $2 - 1e78; }
	| und 	    tredecillionrest	{ $$ = $1 * 1e78 + $2 - 1e78; }
	| hunderter tredecillionrest	{ $$ = $1 * 1e78 + $2 - 1e78; }
	| tausender tredecillionrest	{ $$ = $1 * 1e78 + $2 - 1e78; }
	;

tredecillionrest : TREDECILLION		{ $$ = 1e78; }
	|TREDECILLION einer		{ $$ = 1e78 + $2; }
	|TREDECILLION zehner		{ $$ = 1e78 + $2; }
	|TREDECILLION ziger		{ $$ = 1e78 + $2; }
	|TREDECILLION und		{ $$ = 1e78 + $2; }
	|TREDECILLION hunderter		{ $$ = 1e78 + $2; }
	|TREDECILLION tausender		{ $$ = 1e78 + $2; }
	|TREDECILLION mille		{ $$ = 1e78 + $2; }
	|TREDECILLION milliarde 	{ $$ = 1e78 + $2; }
	|TREDECILLION billion		{ $$ = 1e78 + $2; }
	|TREDECILLION trillion		{ $$ = 1e78 + $2; }
	|TREDECILLION quadrillion	{ $$ = 1e78 + $2; }
	|TREDECILLION quintillion 	{ $$ = 1e78 + $2; }
	|TREDECILLION sextillion	{ $$ = 1e78 + $2; }
	|TREDECILLION septillion	{ $$ = 1e78 + $2; }
	|TREDECILLION octillion 	{ $$ = 1e78 + $2; }
	|TREDECILLION nonillion 	{ $$ = 1e78 + $2; }
	|TREDECILLION decillion 	{ $$ = 1e78 + $2; }
	|TREDECILLION undecillion 	{ $$ = 1e78 + $2; }
	|TREDECILLION duodecillion 	{ $$ = 1e78 + $2; }
	;
	
duodecillion : duodecillionrest 	{ $$ = $1; }
	| eine      duodecillionrest	{ $$ = $1 * 1e72 + $2 - 1e72; }
	| zehner    duodecillionrest	{ $$ = $1 * 1e72 + $2 - 1e72; }
	| ziger     duodecillionrest	{ $$ = $1 * 1e72 + $2 - 1e72; }
	| und 	    duodecillionrest	{ $$ = $1 * 1e72 + $2 - 1e72; }
	| hunderter duodecillionrest	{ $$ = $1 * 1e72 + $2 - 1e72; }
	| tausender duodecillionrest	{ $$ = $1 * 1e72 + $2 - 1e72; }
	;

duodecillionrest : DUODECILLION		{ $$ = 1e72; }
	|DUODECILLION einer		{ $$ = 1e72 + $2; }
	|DUODECILLION zehner		{ $$ = 1e72 + $2; }
	|DUODECILLION ziger		{ $$ = 1e72 + $2; }
	|DUODECILLION und		{ $$ = 1e72 + $2; }
	|DUODECILLION hunderter		{ $$ = 1e72 + $2; }
	|DUODECILLION tausender		{ $$ = 1e72 + $2; }
	|DUODECILLION mille		{ $$ = 1e72 + $2; }
	|DUODECILLION milliarde 	{ $$ = 1e72 + $2; }
	|DUODECILLION billion		{ $$ = 1e72 + $2; }
	|DUODECILLION trillion		{ $$ = 1e72 + $2; }
	|DUODECILLION quadrillion	{ $$ = 1e72 + $2; }
	|DUODECILLION quintillion 	{ $$ = 1e72 + $2; }
	|DUODECILLION sextillion	{ $$ = 1e72 + $2; }
	|DUODECILLION septillion	{ $$ = 1e72 + $2; }
	|DUODECILLION octillion 	{ $$ = 1e72 + $2; }
	|DUODECILLION nonillion 	{ $$ = 1e72 + $2; }
	|DUODECILLION decillion 	{ $$ = 1e72 + $2; }
	|DUODECILLION undecillion 	{ $$ = 1e72 + $2; }
	;

undecillion : undecillionrest 		{ $$ = $1; }
	| eine      undecillionrest	{ $$ = $1 * 1e66 + $2 - 1e66; }
	| zehner    undecillionrest	{ $$ = $1 * 1e66 + $2 - 1e66; }
	| ziger     undecillionrest	{ $$ = $1 * 1e66 + $2 - 1e66; }
	| und 	    undecillionrest	{ $$ = $1 * 1e66 + $2 - 1e66; }
	| hunderter undecillionrest	{ $$ = $1 * 1e66 + $2 - 1e66; }
	| tausender undecillionrest	{ $$ = $1 * 1e66 + $2 - 1e66; }
	;

undecillionrest : UNDECILLION		{ $$ = 1e66; }
	|UNDECILLION einer		{ $$ = 1e66 + $2; }
	|UNDECILLION zehner		{ $$ = 1e66 + $2; }
	|UNDECILLION ziger		{ $$ = 1e66 + $2; }
	|UNDECILLION und		{ $$ = 1e66 + $2; }
	|UNDECILLION hunderter		{ $$ = 1e66 + $2; }
	|UNDECILLION tausender		{ $$ = 1e66 + $2; }
	|UNDECILLION mille		{ $$ = 1e66 + $2; }
	|UNDECILLION milliarde 		{ $$ = 1e66 + $2; }
	|UNDECILLION billion		{ $$ = 1e66 + $2; }
	|UNDECILLION trillion		{ $$ = 1e66 + $2; }
	|UNDECILLION quadrillion	{ $$ = 1e66 + $2; }
	|UNDECILLION quintillion 	{ $$ = 1e66 + $2; }
	|UNDECILLION sextillion		{ $$ = 1e66 + $2; }
	|UNDECILLION septillion		{ $$ = 1e66 + $2; }
	|UNDECILLION octillion 		{ $$ = 1e66 + $2; }
	|UNDECILLION nonillion 		{ $$ = 1e66 + $2; }
	|UNDECILLION decillion 		{ $$ = 1e66 + $2; }
	;

decillion : decillionrest 		{ $$ = $1; }
	| eine      decillionrest	{ $$ = $1 * 1e60 + $2 - 1e60; }
	| zehner    decillionrest	{ $$ = $1 * 1e60 + $2 - 1e60; }
	| ziger     decillionrest	{ $$ = $1 * 1e60 + $2 - 1e60; }
	| und 	    decillionrest	{ $$ = $1 * 1e60 + $2 - 1e60; }
	| hunderter decillionrest	{ $$ = $1 * 1e60 + $2 - 1e60; }
	| tausender decillionrest	{ $$ = $1 * 1e60 + $2 - 1e60; }
	;

decillionrest : DECILLION		{ $$ = 1e60; }
	|DECILLION einer		{ $$ = 1e60 + $2; }
	|DECILLION zehner		{ $$ = 1e60 + $2; }
	|DECILLION ziger		{ $$ = 1e60 + $2; }
	|DECILLION und			{ $$ = 1e60 + $2; }
	|DECILLION hunderter		{ $$ = 1e60 + $2; }
	|DECILLION tausender		{ $$ = 1e60 + $2; }
	|DECILLION mille		{ $$ = 1e60 + $2; }
	|DECILLION milliarde 		{ $$ = 1e60 + $2; }
	|DECILLION billion		{ $$ = 1e60 + $2; }
	|DECILLION trillion		{ $$ = 1e60 + $2; }
	|DECILLION quadrillion		{ $$ = 1e60 + $2; }
	|DECILLION quintillion	 	{ $$ = 1e60 + $2; }
	|DECILLION sextillion 		{ $$ = 1e60 + $2; }
	|DECILLION septillion 		{ $$ = 1e60 + $2; }
	|DECILLION octillion 		{ $$ = 1e60 + $2; }
	|DECILLION nonillion 		{ $$ = 1e60 + $2; }
	;


nonillion : nonillionrest 		{ $$ = $1; }
	| eine      nonillionrest	{ $$ = $1 * 1e54 + $2 - 1e54; }
	| zehner    nonillionrest	{ $$ = $1 * 1e54 + $2 - 1e54; }
	| ziger     nonillionrest	{ $$ = $1 * 1e54 + $2 - 1e54; }
	| und 	    nonillionrest	{ $$ = $1 * 1e54 + $2 - 1e54; }
	| hunderter nonillionrest	{ $$ = $1 * 1e54 + $2 - 1e54; }
	| tausender nonillionrest	{ $$ = $1 * 1e54 + $2 - 1e54; }
	;

nonillionrest : NONILLION		{ $$ = 1e54; }
	|NONILLION einer		{ $$ = 1e54 + $2; }
	|NONILLION zehner		{ $$ = 1e54 + $2; }
	|NONILLION ziger		{ $$ = 1e54 + $2; }
	|NONILLION und			{ $$ = 1e54 + $2; }
	|NONILLION hunderter		{ $$ = 1e54 + $2; }
	|NONILLION tausender		{ $$ = 1e54 + $2; }
	|NONILLION mille		{ $$ = 1e54 + $2; }
	|NONILLION milliarde 		{ $$ = 1e54 + $2; }
	|NONILLION billion		{ $$ = 1e54 + $2; }
	|NONILLION trillion		{ $$ = 1e54 + $2; }
	|NONILLION quadrillion		{ $$ = 1e54 + $2; }
	|NONILLION quintillion	 	{ $$ = 1e54 + $2; }
	|NONILLION sextillion 		{ $$ = 1e54 + $2; }
	|NONILLION septillion 		{ $$ = 1e54 + $2; }
	|NONILLION octillion 		{ $$ = 1e54 + $2; }
	;


octillion : octillionrest 		{ $$ = $1; }
	| eine      octillionrest	{ $$ = $1 * 1e48 + $2 - 1e48; }
	| zehner    octillionrest	{ $$ = $1 * 1e48 + $2 - 1e48; }
	| ziger     octillionrest	{ $$ = $1 * 1e48 + $2 - 1e48; }
	| und 	    octillionrest	{ $$ = $1 * 1e48 + $2 - 1e48; }
	| hunderter octillionrest	{ $$ = $1 * 1e48 + $2 - 1e48; }
	| tausender octillionrest	{ $$ = $1 * 1e48 + $2 - 1e48; }
	;

octillionrest : OCTILLION		{ $$ = 1e48; }
	|OCTILLION einer		{ $$ = 1e48 + $2; }
	|OCTILLION zehner		{ $$ = 1e48 + $2; }
	|OCTILLION ziger		{ $$ = 1e48 + $2; }
	|OCTILLION und			{ $$ = 1e48 + $2; }
	|OCTILLION hunderter		{ $$ = 1e48 + $2; }
	|OCTILLION tausender		{ $$ = 1e48 + $2; }
	|OCTILLION mille		{ $$ = 1e48 + $2; }
	|OCTILLION milliarde 		{ $$ = 1e48 + $2; }
	|OCTILLION billion		{ $$ = 1e48 + $2; }
	|OCTILLION trillion		{ $$ = 1e48 + $2; }
	|OCTILLION quadrillion		{ $$ = 1e48 + $2; }
	|OCTILLION quintillion	 	{ $$ = 1e48 + $2; }
	|OCTILLION sextillion 		{ $$ = 1e48 + $2; }
	|OCTILLION septillion 		{ $$ = 1e48 + $2; }
	;


septillion : septillionrest 		{ $$ = $1; }
	| eine      septillionrest	{ $$ = $1 * 1e42 + $2 - 1e42; }
	| zehner    septillionrest	{ $$ = $1 * 1e42 + $2 - 1e42; }
	| ziger     septillionrest	{ $$ = $1 * 1e42 + $2 - 1e42; }
	| und 	    septillionrest	{ $$ = $1 * 1e42 + $2 - 1e42; }
	| hunderter septillionrest	{ $$ = $1 * 1e42 + $2 - 1e42; }
	| tausender septillionrest	{ $$ = $1 * 1e42 + $2 - 1e42; }
	;

septillionrest : SEPTILLION		{ $$ = 1e42; }
	|SEPTILLION einer		{ $$ = 1e42 + $2; }
	|SEPTILLION zehner		{ $$ = 1e42 + $2; }
	|SEPTILLION ziger		{ $$ = 1e42 + $2; }
	|SEPTILLION und			{ $$ = 1e42 + $2; }
	|SEPTILLION hunderter		{ $$ = 1e42 + $2; }
	|SEPTILLION tausender		{ $$ = 1e42 + $2; }
	|SEPTILLION mille		{ $$ = 1e42 + $2; }
	|SEPTILLION milliarde 		{ $$ = 1e42 + $2; }
	|SEPTILLION billion		{ $$ = 1e42 + $2; }
	|SEPTILLION trillion		{ $$ = 1e42 + $2; }
	|SEPTILLION quadrillion		{ $$ = 1e42 + $2; }
	|SEPTILLION quintillion 	{ $$ = 1e42 + $2; }
	|SEPTILLION sextillion 		{ $$ = 1e42 + $2; }
	;

sextillion : sextillionrest 		{ $$ = $1; }
	| eine      sextillionrest	{ $$ = $1 * 1e36 + $2 - 1e36; }
	| zehner    sextillionrest	{ $$ = $1 * 1e36 + $2 - 1e36; }
	| ziger     sextillionrest	{ $$ = $1 * 1e36 + $2 - 1e36; }
	| und 	    sextillionrest	{ $$ = $1 * 1e36 + $2 - 1e36; }
	| hunderter sextillionrest	{ $$ = $1 * 1e36 + $2 - 1e36; }
	| tausender sextillionrest	{ $$ = $1 * 1e36 + $2 - 1e36; }
	;

sextillionrest : SEXTILLION		{ $$ = 1e36; }
	|SEXTILLION einer		{ $$ = 1e36 + $2; }
	|SEXTILLION zehner		{ $$ = 1e36 + $2; }
	|SEXTILLION ziger		{ $$ = 1e36 + $2; }
	|SEXTILLION und			{ $$ = 1e36 + $2; }
	|SEXTILLION hunderter		{ $$ = 1e36 + $2; }
	|SEXTILLION tausender		{ $$ = 1e36 + $2; }
	|SEXTILLION mille		{ $$ = 1e36 + $2; }
	|SEXTILLION milliarde 		{ $$ = 1e36 + $2; }
	|SEXTILLION billion		{ $$ = 1e36 + $2; }
	|SEXTILLION trillion		{ $$ = 1e36 + $2; }
	|SEXTILLION quadrillion		{ $$ = 1e36 + $2; }
	|SEXTILLION quintillion 	{ $$ = 1e36 + $2; }
	;

quintillion :  quintillionrest		{ $$ = $1; }
	| eine      quintillionrest	{ $$ = $1 * 1e30 + $2 - 1e30; }
	| zehner    quintillionrest	{ $$ = $1 * 1e30 + $2 - 1e30; }
	| ziger     quintillionrest	{ $$ = $1 * 1e30 + $2 - 1e30; }
	| und 	    quintillionrest	{ $$ = $1 * 1e30 + $2 - 1e30; }
	| hunderter quintillionrest	{ $$ = $1 * 1e30 + $2 - 1e30; }
	| tausender quintillionrest	{ $$ = $1 * 1e30 + $2 - 1e30; }
	;

quintillionrest : 	QUINTILLION	{ $$ = 1e30; }
	|QUINTILLION einer		{ $$ = 1e30 + $2; }
	|QUINTILLION zehner		{ $$ = 1e30 + $2; }
	|QUINTILLION ziger		{ $$ = 1e30 + $2; }
	|QUINTILLION und		{ $$ = 1e30 + $2; }
	|QUINTILLION hunderter		{ $$ = 1e30 + $2; }
	|QUINTILLION tausender		{ $$ = 1e30 + $2; }
	|QUINTILLION mille		{ $$ = 1e30 + $2; }
	|QUINTILLION milliarde 		{ $$ = 1e30 + $2; }
	|QUINTILLION billion		{ $$ = 1e30 + $2; }
	|QUINTILLION trillion		{ $$ = 1e30 + $2; }
	|QUINTILLION quadrillion	{ $$ = 1e30 + $2; }
	;


quadrillion : quadrillionrest 		{ $$ = $1; }
	| eine      quadrillionrest	{ $$ = $1 * 1e24 + $2 - 1e24; }
	| zehner    quadrillionrest	{ $$ = $1 * 1e24 + $2 - 1e24; }
	| ziger     quadrillionrest	{ $$ = $1 * 1e24 + $2 - 1e24; }
	| und 	    quadrillionrest	{ $$ = $1 * 1e24 + $2 - 1e24; }
	| hunderter quadrillionrest	{ $$ = $1 * 1e24 + $2 - 1e24; }
	| tausender quadrillionrest	{ $$ = $1 * 1e24 + $2 - 1e24; }
	;

quadrillionrest : QUADRILLION		{ $$ = 1e24; }
	| QUADRILLION einer		{ $$ = 1e24 + $2; }
	| QUADRILLION zehner		{ $$ = 1e24 + $2; }
	| QUADRILLION ziger		{ $$ = 1e24 + $2; }
	| QUADRILLION und		{ $$ = 1e24 + $2; }
	| QUADRILLION hunderter		{ $$ = 1e24 + $2; }
	| QUADRILLION tausender		{ $$ = 1e24 + $2; }
	| QUADRILLION mille		{ $$ = 1e24 + $2; }
	| QUADRILLION milliarde 	{ $$ = 1e24 + $2; }
	| QUADRILLION billion		{ $$ = 1e24 + $2; }
	| QUADRILLION trillion		{ $$ = 1e24 + $2; }
	;

trillion : trillionrest 		{ $$ = $1; }
	| eine trillionrest		{ $$ = $1 * 1e18 + $2 - 1e18; }
	| zehner trillionrest		{ $$ = $1 * 1e18 + $2 - 1e18; }
	| ziger trillionrest		{ $$ = $1 * 1e18 + $2 - 1e18; }
	| und trillionrest		{ $$ = $1 * 1e18 + $2 - 1e18; }
	| hunderter trillionrest	{ $$ = $1 * 1e18 + $2 - 1e18; }
	| tausender trillionrest	{ $$ = $1 * 1e18 + $2 - 1e18; }
	;

trillionrest : TRILLION			{ $$ = 1e18; }
	| TRILLION einer		{ $$ = 1e18 + $2; }
	| TRILLION zehner		{ $$ = 1e18 + $2; }
	| TRILLION ziger		{ $$ = 1e18 + $2; }
	| TRILLION und			{ $$ = 1e18 + $2; }
	| TRILLION hunderter		{ $$ = 1e18 + $2; }
	| TRILLION tausender		{ $$ = 1e18 + $2; }
/*mille rest mglich*/	
	| TRILLION mille		{ $$ = 1e18 + $2; }
	| TRILLION milliarde 		{ $$ = 1e18 + $2; }
	| TRILLION billion		{ $$ = 1e18 + $2; }
	;
	
billion : billionrest 			{ $$ = $1; }
	| eine billionrest		{ $$ = $1 * 1e12 + $2 - 1e12; }
	| zehner billionrest		{ $$ = $1 * 1e12 + $2 - 1e12; }
	| ziger billionrest		{ $$ = $1 * 1e12 + $2 - 1e12; }
	| und billionrest		{ $$ = $1 * 1e12 + $2 - 1e12; }
	| hunderter billionrest		{ $$ = $1 * 1e12 + $2 - 1e12; }
	| tausender billionrest		{ $$ = $1 * 1e12 + $2 - 1e12; }
/* gibs nicht mehr ist dann "billion"  -> | mille billionrest		{ $$ = $1 * 1e12 + $2 - 1e12; } */
	;

billionrest : BILLION			{ $$ = 1e12; }
	| BILLION einer			{ $$ = 1e12 + $2; }
	| BILLION zehner		{ $$ = 1e12 + $2; }
	| BILLION ziger			{ $$ = 1e12 + $2; }
	| BILLION und			{ $$ = 1e12 + $2; }
	| BILLION hunderter		{ $$ = 1e12 + $2; }
	| BILLION tausender		{ $$ = 1e12 + $2; }
/*mille rest mglich*/	
	| BILLION mille			{ $$ = 1e12 + $2; }
/*ausnahme milliarde (1000 million) */	
	| BILLION milliarde 		{ $$ = 1e12 + $2; }
	;

/* eine milliarde ist 1000 million !  Deutsche Sprachverwirrung !!! 
 * weiter gehts dann mit billion !!! */
milliarde : milliarderest 		{ $$ = $1; }
	| eine milliarderest		{ $$ = $1 * 1e9 + $2 - 1e9; }
	| zehner milliarderest		{ $$ = $1 * 1e9 + $2 - 1e9; }
	| ziger milliarderest		{ $$ = $1 * 1e9 + $2 - 1e9; }
	| und milliarderest		{ $$ = $1 * 1e9 + $2 - 1e9; }
	| hunderter milliarderest	{ $$ = $1 * 1e9 + $2 - 1e9; }
	;

milliarderest : MILLIARDE		{ $$ = 1e9; }
	| MILLIARDE einer		{ $$ = 1e9 + $2; }
	| MILLIARDE zehner		{ $$ = 1e9 + $2; }
	| MILLIARDE ziger		{ $$ = 1e9 + $2; }
	| MILLIARDE und			{ $$ = 1e9 + $2; }
	| MILLIARDE hunderter		{ $$ = 1e9 + $2; }
	| MILLIARDE tausender		{ $$ = 1e9 + $2; }
	| MILLIARDE milleklein 		 { $$ = 1e9 + $2; }
/* ist nich! ist billion	| MILLIARDE mille	{ $$ = 1e12 + $2; }*/
	;
	
/* mille ohne tausender fr die milliarde */
milleklein : millerest 			{ $$ = $1; }
	| eine millerest 		{ $$ = $1 * 1e6 + $2 - 1e6; }
	| zehner millerest 		{ $$ = $1 * 1e6 + $2 - 1e6; }
	| ziger millerest 		{ $$ = $1 * 1e6 + $2 - 1e6; }
	| und millerest 		{ $$ = $1 * 1e6 + $2 - 1e6; }
	| hunderter millerest 		{ $$ = $1 * 1e6 + $2 - 1e6; }
	;

mille	: milleklein 			{ $$ = $1; }
/* milliarde */	| tausender millerest 	{ $$ = $1 * 1e6 + $2 - 1e6; }
	;

millerest : MILLION 		{ $$ = 1e6; }
	| MILLION einer 	{ $$ = 1e6 + $2; }
	| MILLION zehner 	{ $$ = 1e6 + $2; }
	| MILLION ziger 	{ $$ = 1e6 + $2; }
	| MILLION und 		{ $$ = 1e6 + $2; }
	| MILLION hunderter 	{ $$ = 1e6 + $2; }
	| MILLION tausender 	{ $$ = 1e6 + $2; }
	;

tausender : tausendrest		{ $$ = $1; }
	| hunderter tausendrest { $$ = $1 * 1e3 + $2 - 1e3; }
	| und tausendrest 	{ $$ = $1 * 1e3 + $2 - 1e3; }
	| ziger tausendrest 	{ $$ = $1 * 1e3 + $2 - 1e3; }
	| zehner tausendrest 	{ $$ = $1 * 1e3 + $2 - 1e3; }
	| eint tausendrest 	{ $$ = $1 * 1e3 + $2 - 1e3; } 
	;

tausendrest : TAUSEND 		{ $$ = 1e3; }
	| TAUSEND einer 	{ $$ = 1e3 + $2; }
	| TAUSEND zehner 	{ $$ = 1e3 + $2; }
	| TAUSEND ziger 	{ $$ = 1e3 + $2; }
	| TAUSEND und   	{ $$ = 1e3 + $2; }
	| TAUSEND hunderter 	{ $$ = 1e3 + $2; }
	;

hunderter : hundertrest   	{ $$ = $1; }
	| ein hundertrest 	{ $$ = $1 * 1e2 + $2 - 1e2; }
	;

hundertrest : 	HUNDERT  	{ $$ = 1e2; }
	| HUNDERT einer  	{ $$ = 1e2 + $2; }
	| HUNDERT zehner 	{ $$ = 1e2 + $2; }
	| HUNDERT ziger  	{ $$ = 1e2 + $2; }
	| HUNDERT und    	{ $$ = 1e2 + $2; }
	;

und	: ein UND ziger { $$ = $1 + $3; }
	;

ziger   : zwan ZIG { $$ = $1 * 10.0; }
	| DREISSIG { $$ = 30.0; }
	| einziger ZIG { $$ = $1 * 10.0; }
	; 
	
zwan	: ZWAN { $$ = 2.0; }
	;
	
zehner	: ZEHN { $$ = 10.0; }
	| ELF   { $$ = 11.0; }
	| ZWOELF{ $$ = 12.0; }
	| sech ZEHN { $$ = 10.0 + $1; }
	;

sech	: DREI  { $$ = 3.0; }
	| einziger { $$ = $1; }
	;
	
einziger: vierfuenf { $$ = $1 ; }
	| SECH  { $$ = 6.0; }
 	| SIEB  { $$ = 7.0; }
	;

vierfuenf : VIER  { $$ = 4.0; }
	| FUENF { $$ = 5.0; }
	| ACHT  { $$ = 8.0; }
	| NEUN	{ $$ = 9.0; }
	;

/* die "eins" vor dem Tausender gehrt zur vorigen zahl */
eint	: EIN  { $$ = 1.0; }
	| zwne { $$ = $1 ; }
	;

/* einer und eins zusammengefasst*/
einer	: EINS  { $$ = 1.0; }
	| zwne { $$ = $1 ; }
	;

ein	: EIN  { $$ = 1.0; }
	| zwne { $$ = $1 ; }
	;

eine	: EINE  { $$ = 1.0; }
	| zwne { $$ = $1 ; }
	;

zwne	: ZWEI  { $$ = 2.0; }
	| DREI  { $$ = 3.0; }
	| SECHS { $$ = 6.0; }
	| SIEBEN{ $$ = 7.0; }
	| vierfuenf { $$ = $1; }
	;

%%


