%{
#define _GNU_SOURCE
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "parser.tab.h"

/*char str[256];*/

// aus dem Hauptprogramm.
extern int batch;

int yyerror (char *s);  /* Called by yyparse on error */

/* aus lex.yy.c rausgeholt, bei Versionsnummerwechsel mal nachsehen ob
 * alles noch OK ist ! */

/* Die Input funktion bischen erweitert, Ausgabe >, 
 * alle Buchstaben klein ... */
#define YY_INPUT(buf,result,max_size) \
   if (!batch) printf(">"); \
    int c = '*', n; \
    for ( n = 0; n < max_size && \
	 (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
    {\
      buf[n] = (char) tolower(c); \
    }\
    if ( c == '\n' ) \
    {\
       buf[n++] = (char) c; \
    }\
    if ( c == EOF && ferror( yyin ) ) \
	    YY_FATAL_ERROR( "input in flex scanner failed" ); \
    result = n; \


%}

%%

[0-9.]+		{ sscanf(yytext, "%lf", (double*) &yylval); return NUM; }
[-+*/^()=,\n]	{ return yytext[0]; }
[ \t]		; 
[q;]		{ yyerror("Tschuess!\n"); exit(0); 
			/*hier ist das Programmende!*/ } 
eins		{ return EINS; }
eine		{ return EINE; }
ein		{ return EIN; }
zwei		{ return ZWEI; }
drei		{ return DREI; }
vier		{ return VIER; }
fuenf		{ return FUENF; }
sechs		{ return SECHS; }
sech		{ return SECH; }
sieben		{ return SIEBEN; }
sieb		{ return SIEB; }
acht		{ return ACHT; }
neun		{ return NEUN; }
zehn		{ return ZEHN; }
elf		{ return ELF; }
zwoelf		{ return ZWOELF; }
zwan		{ return ZWAN; }
dreissig	{ return DREISSIG; }
zig		{ return ZIG; }
hundert		{ return HUNDERT; }
tausend		{ return TAUSEND; }

millionen|million			{ return MILLION; }
milliarden|milliarde			{ return MILLIARDE; }
billion|billionen 			{ return BILLION; }
trillion|trillionen			{ return TRILLION; }
quadrillion|quadrillionen		{ return QUADRILLION; }
quintillion|quintillionen		{ return QUINTILLION; }
sextillion|sextillionen			{ return SEXTILLION; }
septillion|septillionen			{ return SEPTILLION; }
octillion|octillionen			{ return OCTILLION ;} 
nonillion|nonillionen			{ return NONILLION ; }
decillion|decillionen			{ return DECILLION ;  }
undecillion|undecillionen		{ return UNDECILLION ; }
duodecillion|duodecillionen             { return DUODECILLION; }
tredecillion|tredecillionen		{ return TREDECILLION ; }
quattuordecillion|quattuordecillionen	{ return QUATTUORDECILLION ; }
quindecillion|quindecillionen		{ return QUINDECILLION ; }
sexdecillion|sexdecillionen		{ return SEXDECILLION ; }
septendecillion|septendecillionen	{ return SEPTENDECILLION ; }
octodecillion|octodecillionen		{ return OCTODECILLION ; }
novemdecillion|novemdecillionen		{ return NOVEMDECILLION; }
vigintillion|vigintillionen		{ return VIGINTILLION; }
centillion|centillionen		        { return CENTILLION; }


und		{ return UND; }
plus|add	{ return '+'; }
minus|sub	{ return '-'; }
mal|mul		{ return '*'; }
durch|div	{ return '/'; }

mem		{ return MEM; }
erg		{ return ERG; }

e		{ return CONST_e; }
log2e		{ return CONST_log2e; }
log10e		{ return CONST_log10e; }
ln2		{ return CONST_ln2; }
ln10		{ return CONST_ln10; }
pi		{ return CONST_pi; }
pi_2		{ return CONST_pi_2; }
pi_4		{ return CONST_pi_4; }
1_pi		{ return CONST_1_pi; }
2_pi		{ return CONST_2_pi; }
2_sqrtpi	{ return CONST_2_sqrtpi; }
sqrt2		{ return CONST_sqrt2; }
sqrt1_2		{ return CONST_sqrt1_2; }

acos		{ return ACOS; /* Winkel Funktionen */ }
asin		{ return ASIN; }
atan 		{ return ATAN; }
cos  		{ return COS; }
sin		{ return SIN; }
tan		{ return TAN; }
acosh		{ return ACOSH; }
asinh		{ return ASINH; }
atanh		{ return ATANH; }
cosh		{ return COSH; }
sinh		{ return SINH; }
tanh		{ return TANH; }


exp		{ return EXP; /* Exponential function of X.  */}
frexp 	       	{ return FREXP; }
ldexp 	       	{ return LDEXP; }
log 		{ return LOG; }
log10 	       	{ return LOG10; }
expm1 	       	{ return EXPM1; }
log1p 	       	{ return LOG1P; }
logb 	       	{ return LOGB; }
exp2 	       	{ return EXP2; }
log2 	       	{ return LOG2; }

pow		{ return POW; /* Power functions.  */ }
sqrt		{ return SQRT; }
hypot		{ return HYPOT;}
cbrt		{ return CBRT; }

ceil		{ return CEIL; /* Nearest integer, absolute value, and remainder functions.  */ }
fabs		{ return FABS;   }
floor		{ return FLOOR;  }
fmod		{ return FMOD;   }
nbi		{ return NBI;    }
round		{ return ROUND;  }
trunc		{ return TRUNC;  }


remquo		{ return REMQUO ; /* Compute remainder of X and Y and put in *QUO a value with sign of x/y
   and magnitude congruent `mod 2^n' to the magnitude of the integral
   quotient x/y, with n >= 3.  */ }

lrint		{ return LRINT	  ;  }
lround		{ return LROUND	  ;  }
copysign	{ return COPYSIGN ;  }

erf		{ return ERF   ;  }
erfc		{ return ERFC  ;  }
tgamma		{ return TGAMMA;  }
lgamma	        { return LGAMMA;  }

rint		{ return RINT;  }
nextafter	{ return NEXTAFTER;  }
nexttoward	{ return NEXTTOWARD;  }
remainder	{ return REMAINDER;  }
scalb	 	{ return SCALB;  }
scalbn	 	{ return SCALBN;  }
scalbln	 	{ return SCALBLN;  }
ilogb		{ return ILOGB;  }
fdim		{ return FDIM;  }
fmax		{ return FMAX;  }
fmin		{ return FMIN;  }
fma		{ return FMA;  }
carg		{ return CARG;  }
conj		{ return CONJ;  }
cproj		{ return CPROJ;  }
cimag		{ return CIMAG;  }
creal		{ return CREAL;  }


