//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#include <qdatetm.h>

#include "alarm.h"

//*****************************************************************************

AlarmEntry::
AlarmEntry(QDateTime alarm_time, Event *ep) : _alarm_time(alarm_time),  
                                              _event(*ep) {
}

//*****************************************************************************

AlarmEntry::
~AlarmEntry() {
}

//*****************************************************************************

Event *AlarmEntry::
event(void) {
   return (&_event);
}

//*****************************************************************************

QDateTime AlarmEntry::
dateTime(void) {
   return (_alarm_time);
}

//*****************************************************************************

int AlarmEntry::
operator <(AlarmEntry& ae) {
   int result = 0;

   if (_alarm_time < ae.dateTime())
      result = 1;

   return (result);
}

//*****************************************************************************

int AlarmEntry::
operator ==(AlarmEntry & ae) {
   int result = 0;

  if (_alarm_time == ae.dateTime())
      result = 1;

   return (result);
}

//*****************************************************************************
//*****************************************************************************

AlarmList::AlarmList() {
}

//*****************************************************************************

AlarmList::
~AlarmList() {
   _alarm_list.setAutoDelete(TRUE);
}

//*****************************************************************************

void AlarmList::
removeEvent(unsigned int key) {
   AlarmEntry *ae_p;
   QList<AlarmEntry> ae_list;

   for (ae_p = _alarm_list.first(); ae_p; ae_p = _alarm_list.next()) {
      if (ae_p->event()->dbKey() == key) {
         ae_list.append(ae_p);
      }
   }

   for (ae_p = ae_list.first(); ae_p; ae_p = ae_list.next()) {
      _alarm_list.removeRef(ae_p);
      delete(ae_p);
   }
}


//*****************************************************************************

void AlarmList::
inSort(const AlarmEntry* ae_p) {
   _alarm_list.inSort(ae_p);
}

//*****************************************************************************

AlarmEntry *AlarmList::
expired(QDateTime time_now) {
   AlarmEntry *ae_p, *result = NULL;

   if (ae_p = _alarm_list.first()) {
      if (ae_p->dateTime() < time_now) {
         result = ae_p;
         _alarm_list.removeFirst();
      }
   }

   return (result); 
}

//*****************************************************************************
