//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#include <stdlib.h>

#include <stream.h>
#include <qapp.h>
#include <qframe.h>
#include <qfont.h>
#include <qbuffer.h>
#include <qdstream.h> 

#include "remind.h"
#include "event.h"
#include "persist.h"
#include "util.h"

//*****************************************************************************

main ( int argc, char **argv ) {
   char *cp;
   QString dir_name;
   QFont font("adobe", 12, QFont::Bold);
   QFont::setDefaultFont(font);
   QApplication a(argc, argv);

   if (cp = getenv("HOME")) {
      QString home(cp);
      dir_name = home + (QString)"/.qtremind";
   }
   QtedPersist::dbSetDirectory(dir_name);
   QtedPersist::dbInitFile("Event");

   Remind remind(&a);

   a.setMainWidget(&remind);
   remind.show();

   return (a.exec());
}
 
//*****************************************************************************
