//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#include <stream.h>

#include <qstring.h>
#include <qpainter.h>
#include "monthday_button.h"

//*****************************************************************************

void QtedMonthdayButton:: 
drawButtonLabel(QPainter *paint) {
   if (_day > 0) {
      int i, x = 2, y = 15, font_height;
      QString number;

      paint->save();
      number.sprintf("%d", _day);
      paint->setPen(foregroundColor());
      paint->drawText(x, y, number);
      font_height = fontMetrics().lineSpacing();
      y += font_height; 
      for(i = 0; i < _strings.count(); i++) {
         paint->setPen(*_colors.at(i));
         paint->drawText(x * 2, y, *_strings.at(i));
         y += font_height; 
      }
      paint->restore();
   }
}

//*****************************************************************************

void QtedMonthdayButton::
addLine(QString text, QColor color) {
   _strings.append(new QString(text));
   _colors.append(new QColor(color));
   repaint();
}

//*****************************************************************************

void QtedMonthdayButton::
day(int day_num) { 
   _day = day_num; 
   if (_day > 0)
      setEnabled(TRUE); 
   else
      setEnabled(FALSE);

   clearText();
}

//*****************************************************************************

void QtedMonthdayButton::
clearText(void) {
   _strings.clear();
   _colors.clear();
   repaint();
}

//*****************************************************************************
