//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#ifndef _Q_TED_MONTHDAY_BUTTON_H_
#define _Q_TED_MONTHDAY_BUTTON_H_

//*****************************************************************************

#include <qcolor.h>
#include <qlist.h>
#include <qpushbt.h>

//*****************************************************************************

class QtedMonthdayButton : public QPushButton {
   private:
      int _day;
      QList <QString>_strings;
      QList <QColor>_colors;
   protected:
      void drawButtonLabel(QPainter *paint);
   public:
      QtedMonthdayButton(QWidget *parent=0, const char *name=0) :
         QPushButton(parent, name), _day(0) { 
         _strings.setAutoDelete(TRUE); 
         _colors.setAutoDelete(TRUE);
      }
      void day(int day_num);
      int day(void) { return(_day); }
      void clearText(void);
      void addLine(QString text, QColor color);
};

#endif

//*****************************************************************************
