//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#ifndef _Q_TED_PERSIST_H_
#define _Q_TED_PERSIST_H_

//*****************************************************************************

#include <gdbm.h>
#include <qstring.h>
#include <qlist.h>
#include <qintdict.h>

//*****************************************************************************

#define ERROR	-1
#define INVALID	-2

// these two MUST NOT be sizeof(int)
#define FREE_LIST	"FREE LIST"
#define MAX_USED_KEY	"MAX  USED"

#define SYSTEM_ERROR	1
#define GDBM_ERROR	2
#define PERSIST_ERROR	3

//*****************************************************************************

class QtedPersist {
   private:
      unsigned int _key;		// 0 = member not stored in db yet 
      int _dirty;			// member not in sync with db
      static GDBM_FILE _dbf;		// gdbm file pointer
      static int _dirname_set;
      static QString _dir;

      static int  dbOpen(QString className, int mode);
      static void dbClose(QString className);
      static void dbError(QString); 	// make user definable routine
      static int  dbMkdir(void);
      unsigned int dbGetKey(void);
      void dbFreeList(QList<unsigned int> list);
      static QList<unsigned int> dbFreeList(QString className);
      void dbMaxUsed(unsigned int);
      static unsigned int dbMaxUsed(QString className);
      virtual const char *dbClassName(void) = 0;

   public:
      QtedPersist();
      QtedPersist(unsigned int key);
      ~QtedPersist();

      void dbDirty(void);
      int dbIsDirty(void);
      unsigned int dbKey(void);
      int dbSave(QByteArray data);
      int dbDelete(void);

      virtual int dbSave(void) = 0;
      virtual int dbRestore(QByteArray data) = 0;

      static QString dbFileName(QString className);
      static int dbInitFile(QString className);
      static QByteArray *dbGet(QString className, unsigned int key);
      static unsigned int dbNextRec(QString className, unsigned int key);
      static int dbSetDirectory(QString dir);
      static void dbShowFreeList(QString className);
      static void dbShowMaxUsed(QString className);
};

#endif

//*****************************************************************************
