//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#include "util.h"

//*****************************************************************************

QString 
ordinal(int i) {
   QString result;

   if (i % 10 == 1 && i != 11)
      result.sprintf("%dst", i);
   else if (i % 10 == 2 && i != 12)
      result.sprintf("%dnd", i);
   else if (i % 10 == 3 && i != 13)
      result.sprintf("%drd", i);
   else
      result.sprintf("%dth", i);

   return (result);
}

//*****************************************************************************

time_t 
epochSeconds(const QDateTime &a_date_time) {
   time_t results;

   struct tm event_time;
   event_time.tm_isdst = -1;
   event_time.tm_year = a_date_time.date().year() - 1900;
   event_time.tm_mon = a_date_time.date().month() - 1;
   event_time.tm_mday = a_date_time.date().day();
   event_time.tm_hour = a_date_time.time().hour();
   event_time.tm_min = a_date_time.time().minute();
   event_time.tm_sec = a_date_time.time().second();

   results = mktime(&event_time);

   return (results);
}

//*****************************************************************************
