//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#include "weekday_labels.h"

//*****************************************************************************

QtedWeekdayLabels:: 
QtedWeekdayLabels(Orientation o, QWidget *parent, const char *name) : 
                  QWidget(parent, name), _orientation(o) {
   for (int i = 0; i < DAYS_PER_WEEK; i++) {
      QLabel *label_p = new QLabel(weekdayNames[i], this);
      label_p->setAlignment(AlignCenter); 
      _weekdayLabels[i] = label_p;
   }
   resizeEvent(NULL);
}

//*****************************************************************************

void QtedWeekdayLabels::
resizeEvent(QResizeEvent *) {
   int i, offset = 0, next_offset;

   for (i = 0; i < DAYS_PER_WEEK; i++) {
      if (_orientation == Horizontal) {
         next_offset = offset + (width() - offset) / (DAYS_PER_WEEK - i);
         _weekdayLabels[i]->setGeometry(offset, 0, 
                                        next_offset - offset, height());
      } else {
         next_offset = offset + (height() - offset) / (DAYS_PER_WEEK - i);
         _weekdayLabels[i]->setGeometry(0, offset, 
                                        width(), next_offset - offset);
      }
      offset = next_offset;
   }
}

//*****************************************************************************
