%% LaTeX2e file `errata.cls'
%% generated by the `filecontents' environment
%% from source `webcomp' on 2001/03/09.
%%
% Copyright (C) 1997, Frank Mittelbach

\ProvidesClass{errata}
  [1997/12/31 v0.6b Mini class for errata files subject to change (FMi)]

\LoadClass{article}

\setcounter{secnumdepth}{-1}
\addtolength\textwidth{5cm}
\addtolength\oddsidemargin{-3cm}

\addtolength\textheight{36pt}

\RequirePackage{shortvrb}
\MakeShortVerb{\|}

\RequirePackage{array,longtable}
\RequirePackage{multicol}


\newcommand\erratagetnumber{}
\def\erratagetnumber#1/#2/#3\erratagetnumber{#1#2#3}


\newcommand\gobbleerrata{%
  \setbox\@tempboxa\vbox\bgroup
     \let\endgobble\egroup
     \let\hideamp\relax
     \let\\\relax\let\par\@@par}

\newcommand*\hideamp{&}

\let\endgobble\relax


\newcommand\erratastartdate{}
\newcommand\myprinting{}


\newcommand\doweprint[2]{%
  \ifnum \myprinting < \if!#2!1000 \else#2 \fi
   \ifnum \expandafter\erratagetnumber\erratastartdate\erratagetnumber <
          \erratagetnumber#1\erratagetnumber \relax
     \@tempswatrue
   \else
     \@tempswafalse
   \fi
  \else
    \@tempswafalse
  \fi
}



\newcommand\includedentries{entries after = \erratastartdate}
\newcommand\printedentries{between \erratastartdate\space and}

\newcommand\showallerrors{%
 \renewcommand\includedentries{all errata entries}%
 \renewcommand\printedentries{up to}
 \renewcommand\doweprint[2]{\@tempswatrue}}


\newcommand\displayrevisionfix[2]{%
    \if!#2!\textbf{#1}\else\textit{#1}\rlap{\textsuperscript{#2}}\fi}

\newcommand\norevisionnumbers{%
  \renewcommand\displayrevisionfix[2]{\textbf{##1}}}

\IfFileExists{\jobname.cfg}
  {
   \input{\jobname.cfg}
   \typeout{***************************************************}
   \typeout{*}
   \typeout{* Configuration file for \jobname.err found }
   \typeout{*}
   \typeout{* If you wish to generate an errata listing}
   \typeout{* containing only errors found after a certain revision}
   \typeout{* and/or only errors found after a certain date}
   \typeout{* modify the information stored in \jobname.cfg}
   \typeout{*}
   \typeout{* Current settings are:}
   \typeout{*}
   \typeout{* \@spaces  printing of your book = \myprinting}
   \typeout{* \@spaces  include \includedentries}
   \typeout{*}
   \typeout{***************************************************}
  }
  {}

%% \erroronpage <page> <line info> <contributor> <date> <fixed in revision>

\newcommand\erroronpage[5]{%
   \endgobble
   \doweprint{#4}{#5}%
   \if@tempswa
     \typeout{Typesetting entry #1 #2 #3 #4}%
   \else
     \typeout{Ignoring entry #1 #2 #3 #4}%
     \expandafter\gobbleerrata
   \fi
   \hideamp \\%
   \displayrevisionfix{#1}{#5}
   \hideamp #2 \hideamp (\textsf{#3}) \hideamp
}

\newcommand\CHAPTER[1]{\endgobble
  &\\[4pt]%
  \multicolumn{4}{l}{\framebox[10cm][l]{\textbf{\normalsize\strut#1}}} \\}

\newenvironment{erratalist}
  {\begin{longtable}{r>{\raggedright}p{2cm}l>{\raggedright}p{10cm}l}}
  {\endgobble\end{longtable}}

\newcommand\erratatitle[2]
  {\begin{center}\LARGE\bfseries
      Errata list for #1\\[5pt](\myprinting.\ printing)\\[10pt]
      \large Includes all entries found \printedentries\space #2
   \end{center}%
   \markright{Errata for #1 (\printedentries\space #2)}%
   \thispagestyle{plain}%
   \vspace{20pt}}

\pagestyle{myheadings}

\AtBeginDocument{\small}

\setlength\parindent{0pt}
\setlength\parskip{2pt}

\newcommand\contributor[2]{\makebox[1cm][l]{\sffamily#1} #2\par}

% some special shortcuts overwriting existing commands:

\let\u\underline
\renewcommand\>{$\to$}

