#!/bin/sh
#	User login script
#
#

#
#	For programs run via the EXTERNW facility
#
	   TERMINAL=`tty`
export TERMINAL

export logitall=1

#
#	Where are we?
#
bbsdir=`dirname $0`
bbsdir=`dirname $bbsdir`
BBSdir=$bbsdir
export bbsdir BBSdir

#
#	Environment etc..
#
. /etc/profile

#
#	Get the main environment
#
. $bbsdir/config/environment

export TERMINFO=/usr/lib/terminfo


#
#	If New is supplied on signon line then use the new image
#
SOPT="$*$L0$L1$L2$L3$L4$L5$L6"

IMAGE=$bbsbin/bbs.exe
export IMAGE

case "$SOPT" in
*New*)	IMAGE=$bbsbin/bbs.exe.new
#		TRACE_CURSES=9999
#		export TRACE_CURSES
		;;
*Old*)	IMAGE=$bbsbin/old/bbs.exe
		;;
esac


#
#	Check for a disabled line(s)
#
tty -s
if [ $? -eq 0 ]
then
	terminal=`tty`
	terminal=`basename $terminal`
	if [ -f $bbsconfig/disabled/$terminal ]
	then
		cat $bbsconfig/disabled/$terminal
		sleep 120
		exit 1
	fi
fi


#
#	For static slip, run bbs image with -dip option, Dynamic slip then -dslip.
#	Dynamic ppp is -dppp.
#
case "$SOPT" in
*Staticslip*)	exec $IMAGE -dip
				;;
*Slip*)			exec $IMAGE -dslip
				;;
*Ppp*)			exec $IMAGE -dppp
				;;
esac


#
#	Default Terminal option, unless Interact is supplied
#
TERM=ansi
export TERM

################################################################################
#
#	Run Image immediately if -c supplied
#

case $1 in
-c)	shift
	exec /bin/ksh -c "$*"
	;;
esac



#
#	We just want everything exported
#
set -a

#
#	Enable others to write to terminal
#
mesg y 2>/dev/null


#
#	If this is a guest login, then re-login as guestA, guestB etc..
#
if [ -f $bbsdir/config/genericAccount/$LOGNAME ]
then
	chmod 777 `tty`

	#
	#	Check guestA, guestB etc.. if logged in
	#
	for g in `cat $bbsdir/config/genericAccount/$LOGNAME`
	do
		ps -au | grep "^$g " >/dev/null
		#
		#	Login as guest account not being used
		#
		if [ $? -ne 0 ]
		then
			echo "Signing on as $g.."

			exec su - $g $SOPT

			exit $?
		fi
	done

	#
	#	All available guest accounts are in use
	#
	echo
	echo "Sorry maximum number of permitted $LOGNAME account sign-ons"
	echo "already connected."
	echo
	echo "(You REALLY should join up as a full member - Only 4.00 a month"
	echo " and a trial account is FREE!!)"
	echo
	echo "If you keep having problems getting online.. You can always phone"
	echo "a voice on 01753 776699 or fax us on the same number"
	echo
	sleep 30
	exit 0
fi



cat <<!



!


################################################################################
#	Quick count of number of incomming mail and show local time.
#

echo "Local time is `date`"
messages
echo 


################################################################################
#	MAIN ENVIRONMENT
#


#
#	Define log file
#
	   BBSLOG="$BBSlogs/$LOGNAME.log"
export BBSLOG


#
#	Enable hangup
#
if tty -s
then
	stty hup
fi

#
#	For tin
#
	   ORGANIZATION='INTERact BBS UK (01753) 775533'
export ORGANIZATION
	   AUTOSUBSCRIBE='INTERact.*'
export AUTOSUBSCRIBE
	   TIN_INDEXDIR=~news/.tin
export TIN_INDEXDIR

#
#	VI in novice mode and ignore case for searches
#
	   EXINIT='set novice ignorecase'
export EXINIT

#
#	Set number of seconds to wait on defaults
#
 	   BBSWAIT=15
export BBSWAIT

if [ \( "$1" = "-c" \) -a \( "`whoami`" = "sysop" \) ]
then
	BBSWAIT=1
fi

################################################################################
#	SOURCE IN $HOME/.bbsrc IF PRESENT
#

#
#	Use custom settings?
#
custom=N
if [ -f $HOME/.bbsrc ]
then
	unset TERM
	unset LINES
	unset COLS
	unset COLOUR
	unset BBSMARKER
	unset BBSPROTOCOL

	. $HOME/.bbsrc

	case "$SOPT" in
	*Interact50*)	TERM=inter50
					;;
	*Interact43*)	TERM=inter43
					;;
	*Interact*)		TERM=interact
					;;
	esac
	
	if [ -n "$TERM" ]
	then
		echo "TERM = $TERM	(Controls escape sequences to send to your terminal)"
	fi

	if [ -n "$LINES" ]
	then
		echo "LINES = $LINES	(How many lines your terminal has)"
	fi

	if [ -n "$COLS" ]
	then
		echo "COLS = $COLS	(How may columns your terminal has)"
	fi

	if [ -n "$COLOUR" ]
	then
		echo "COLOUR = $COLOUR	(Colour enabled Yes/No)"
	fi

	if [ -n "$BBSMARKER" ]
	then
		echo "BBSMARKER = $BBSMARKER	(Used by Archive browser to mark current selection)"
	fi

	if [ -n "$BBSPROTOCOL" ]
	then
		echo "BBSPROTOCOL = $BBSPROTOCOL	(Used for automatic down/up load protocol selection)"
	fi

	if [ -n "$TERM" -o -n "$LINES" -o -n "$COLS" -o -n "$COLOUR" ]
	then
		case "$SOPT" in
		*Custom*)	echo 'Forced CUSTOM settings'
					custom=Y
					;;
		*)
	    #
	    #	Check that user wants to use his/her defaults (if present)
	    #
	    cat <<!

You have $BBSWAIT seconds before we start the BBS using your
custom settings.  If you want to use the system defaults, press
D now.  Otherwise, press any key (or wait).
!
	    /bin/echo "Press D or any other key:"\\c
	    $BBSbin/onekey ${BBSWAIT}0
	    s=$?
	    echo

	    if [ $s -eq 68 -o $s -eq 100 ]
	    then
		    echo 'Using DEFAULT settings'
		    custom=N
			TERM=ansi
	    else
		    echo 'Using CUSTOM settings'
		    custom=Y
	    fi
		;;
		esac
	else
		custom="SOME"
	fi

fi

if [ "$custom" = "N" -o "$custom" = "SOME" ]
then
	. $bbsdata/bbsrc

	if [ -f $HOME/.bbsrc ]
	then
		. $HOME/.bbsrc
	fi

	LINES=24
	COLS=79
	TERM=""	
	COLOUR=N
	if [ "$custom" = "N" ]
	then
		BBSMARKER=""
	fi
	BBSPROTOCOL=""
fi
export LINES COLS TERM COLOUR BBSMARKER BBSPROTOCOL


################################################################################
#	GET TERM IF NOT CUSTOMIZED
#

#
#	If TERM not defined, ask user..
#
if [ -z "$TERM" ]
then
	cat <<!

       Please select your terminal type from the list below :-

             0 - INTERact terminal client (INTERACT.EXE)
        1 ansi  2 vt52  3 vt100  4 vt102/vs100/xterm  5 vt220
  
                      * Default is $TERM

!

	/bin/echo "Select a terminal (or press any other key to try the default):"\\c
    $BBSbin/onekey 1200
    c=$?

    case $c in
	48)	TERM=interact
		;;
	49) TERM=ansi
		;;
    50)	TERM=vt52
	    ;;
    51)	TERM=vt100
	    ;;
    52)	TERM=vs100
	    ;;
    53)	TERM=vt220
	    ;;
	*)	TERM=ansi
		;;
    esac

	echo $TERM
    echo
	if [ "$TERM" != "interact" ]
	then
		echo "Does your terminal support colour and graphics?"
		/bin/echo "(Answering N will also make things go ALOT faster):"\\c
		$BBSbin/onekey 1200
		c=$?

		case $c in
		89|121)	COLOUR=Y
				echo Yes
				;;
		*)		COLOUR=N
				echo No
				;;
		esac
	else
		COLOUR=Y
	fi
fi


################################################################################
#	FINAL ENVIRONMENT SETUP...
#

#
#	Setup bbseditor and VISUAL/EDITOR
#
if [ -z "$bbsedit" ]
then
	bbsedit=vi
	export bbsedit
fi

VISUAL=vi.sh
EDITOR=vi.sh
export VISUAL EDITOR


################################################################################
#	RUN BBS
#

#
#	Don't allow sysop login via modem
#
case `whoami`:`tty` in
sysop:/dev/ttyS*)
	exec cat $bbsdata/bells.txt
	;;
esac



for m in `/usr/bin/ipcs -q | /usr/bin/awk '{ if ( $2 == "'"$LOGNAME"'" ) print $1 }'`
do
	echo "DOOM resource removed: $m"
	ipcrm msg $m >/dev/null 2>&1
done


TWIN_MARKER=$BBSMARKER
export TWIN_MARKER



#
#	Run the BBS image
#
exec $IMAGE
