#!/bin/ksh
#
#	Script to generate a diphosts file from the contents of the
#	password file.  Only dip entries for group 500 are created.
#
#
#

#
#	Save the original password file (without Slip accounts)
#
egrep '^[^A-Z]' /etc/passwd > /etc/passwd.lower



#
#	Create the initial diphosts file
#

cat <<! >/etc/diphosts.new
#
# diphosts	This file describes a number of name-to-address
#		mappings for the DIP program.  It is used to determine
#		which host IP address to use for in incoming call of
#		some user.
#
# Version:	@(#)diphosts		1.10	07/20/93
#
# Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
#
#
# name : pwd : hostname : comments : protocol,mtu
#==================================================
#sbonjovi::bonjovi:MicroWalt "bonjovi" SLIP:SLIP,296
#sroxette::roxette:MicroWalt "roxette" SLIP:CSLIP,296
# End of diphosts.
!

#
#	Create the initial password file (all lowercase accounts)
#
cp /etc/passwd.lower /etc/passwd.new

#
#	For a BBS users..
#	add an entry to diphosts and the password file..
#
awk -F: '{ if ( $2 != "*" && $4 == 500 && $3 >= 500 ) print }' /etc/passwd.lower |
while read l
do
	IFS=':'
	set $l
	IFS=' 	
'

	let h=$3-500
	
	#	Get network address
	let n=2+h/253
	let i=h%253+2

	#	DIPHOSTS
	echo $1::10.1.$n.$i:$5 SLIP:SLIP,296 >>/etc/diphosts.new

	#	PASSWD
	#	Append an entry to the new password file for SLIP dialin
	echo `echo $1 | dd bs=1 count=1 2>/dev/null | tr '[a-z]' '[A-Z]'``echo $1 | sed 's/.//'`:$2:$3:$4:$5:$6:$bbsbin/dip.sh >> /etc/passwd.new
done

#
#	Visual verification.. (if we're not running in batch)
#
if tty -s
then
	vi /etc/passwd.new /etc/diphosts.new
else
	#
	#	Safety checks
	#
	if [ `wc -l </etc/passwd.new` -lt `wc -l </etc/passwd` ]
	then
		echo "ERROR: makedip.sh failed on /etc/passwd"
		exit 1
	fi

	if [ `wc -l </etc/diphosts.new` -lt `wc -l </etc/diphosts` ]
	then
		echo "ERROR: makedip.sh failed on /etc/diphosts"
		exit 1
	fi

	mv /etc/diphosts /etc/diphosts.OLD
	mv /etc/diphosts.new /etc/diphosts
	exit 0
fi

#
#	Install new passwd and diphosts files
#
mv /etc/passwd /etc/passwd.OLD
mv /etc/passwd.new /etc/passwd
mv /etc/diphosts /etc/diphosts.OLD
mv /etc/diphosts.new /etc/diphosts

#

