#!/bin/sh
#
#	Script to relink all user BBS trees from the TREE directory
#	run as some with loadsa permissions (sysop may do)
#



cd $bbsusers

#
#	If username is supplied then just relink him, otherwise do all users
#
if [ $# -eq 0 ]
then
	l="`ls`"
else
	l="$1"
fi

#
#	For each BBS user..
#
for i in $l
do

	#
	#	Generic account?
	#
	generic=
	egrep "^$i$" $bbsconfig/genericAccount/* >/dev/null 2>/dev/null
	if [ $? -eq 0 ]
	then
		generic=Y
	fi

	echo $i:$generic

	#
	#	Create user directories if not-present
	#
	if [ ! -d "$i" ]
	then
		mkdir "$i"
		chown "$i.BBS" "$i"
	fi

	#
	#	Goto their directory
	#
	cd "$i"

	#
	#	This is needed for ftp inbound sessions
	#
	if [ ! -d files/bin ]
	then
		mkdir -p files/bin
		if [ "$i" = "sysop" ]
		then
			cp $bbsbin/etc/newusers/ls files/bin
			chown sysop.BBS files/bin/ls
			chmod 755 files/bin/ls
		else
			ln $bbsusers/sysop/files/bin/ls files/bin/ls
		fi

		chmod 555 files/bin
		chown sysop.BBS files/bin
	fi

	#
	#	Some other directories
	#
	if [ ! -d files/mailer ]
	then
		mkdir -p files/mailer
		chown "$i.BBS" files/mailer
	fi

	if [ ! -d files/ftp ]
	then
		mkdir -p files/ftp
		chown "$i.BBS" files/ftp
	fi

	if [ ! -d files/signatures ]
	then
		mkdir -p files/signatures
		chown "$i.BBS" files/ftp
	fi

	if [ ! -d files/game ]
	then
		mkdir -p files/game
		chown "$i.BBS" files/game
	fi
	
	if [ ! -d files/news ]
	then
		mkdir -p files/news
		chown "$i.BBS" files/news
	fi
	
	if [ ! -d files/system ]
	then
		mkdir -p files/system
		chown "$i.BBS" files/system
	fi
	
	if [ ! -d files/www ]
	then
		mkdir -p files/www
		chown "$i.BBS" files/www
	fi

	if [ -n "$generic" ]
	then
		rm -rf .twin
	elif [ ! -d .twin ]
	then
		mkdir .twin
		chown "$i.BBS" .twin
	fi	

	#
	#	Adult dir
	#
	if [ ! -d Adult ]
	then
		mkdir Adult
		chown "$i.BBS" Adult
	fi


	#
	#	Remove all links
	#
	find . -type l -exec rm {} \;

	#
	#	Links all files from the TREE
	#
	ln -s $bbstree/* $bbstree/.exrc .

	#
	#	If we linked over the fastlocate.Bbs file, remove it
	#
	find . -type l -name fastlocate.Bbs -exec rm {} \;

	cd ..
done
