#!/bin/ksh

stty echo

VERSION="V1.6"
echo '  IGO CONSTRUCTION KIT   '$VERSION
echo 'WWW, Ftp, Telnet, News, Email'
echo '     (Dynamic SLIP)'
echo

####################
#	GET USER DETAILS
####################

#
#	We ask the sysop for the username
#
case $LOGNAME in
sysop)	echo -n "User's name?"
		read USERNAME
		echo 
		echo "User: $USERNAME"
		echo
		;;

*)		sleep 2
		USERNAME=$LOGNAME
		;;
esac


#
#	IPaddr and Signon details
#
let h=`id | cut -c5-99 | sed 's/[^0-9].*//g'`-500
let n=2+h/253
let i=h%253+2


IPADDR=10.1.$n.$i
USER_NAME=`egrep "^$USERNAME:" /etc/passwd  | awk -F: '{ print $5 }'`

export IPADDR USER_NAME


#
#	Password
#
cat <<!
Please supply your normal signon password.  This will be used for
the automatic signon procedure.

WARNING: Never distribute your own igo.zip file to another person!

!

tput smso
echo -n 'Enter password:'
tput rmso
read PASSWORD
export PASSWORD
echo
echo
sleep 2


#
#	User local to interact..
#
cat <<!
Are you local to INTERact??  If you are then the number 
775533 is dialed, otherwise 01753 775533 is dialed.

Press L if you are local to INTERact, any other key assumes
that you are NOT.

!

tput smso
echo -n "Press L if you are local, any other key otherwise:"
onekey 5000
case $? in
76|108)	echo LOCAL
		NUMBER=775533
		;;
*)		echo NOT LOCAL
		NUMBER=01753775533
		;;
esac
tput rmso
echo 
echo 
sleep 2


#
#	Com port for slip..
#
cat <<!
Which comm port do you have your modem plugged into??

(Com2 is the default).

!

tput smso
echo -n "Press 1,2,3 or 4:"
onekey 5000
case $? in
49)		PORT=1
		;;
51)		PORT=3
		;;
52)		PORT=4
		;;
*)		PORT=2
		;;
esac
echo "COM$PORT"
tput rmso
echo
export PORT
sleep 2

#
#	Make directory structure (as will be present on the PC)
#
rm -rf $HOME/files/ftp/igo >/dev/null </dev/null
mkdir -p $HOME/files/ftp/igo/winsock $HOME/files/ftp/igo/www $HOME/files/ftp/igo/email
mkdir -p $HOME/files/ftp/igo/winsock.cfg $HOME/files/ftp/igo/www.cfg $HOME/files/ftp/igo/email.cfg
mkdir -p $HOME/files/ftp/igo/windows
mkdir -p $HOME/files/ftp/igo/cache
mkdir -p $HOME/files/ftp/igo/apps


#
#	Populate the winsock, www and email directories
#
cd $HOME/files/ftp/igo/winsock
nice unzip -L $bbsdata/igo/twsk20b.zip
cd $HOME/files/ftp/igo/www
nice unzip -L $bbsdata/igo/nscape09.zip
cp $bbsdata/igo/trmptel.exe $bbsdata/igo/ftpw.exe $HOME/files/ftp/igo/apps
cd $HOME/files/ftp/igo/email
nice unzip -L $bbsdata/igo/eudor152.zip
cp $bbsdata/igo/email/* .


######################
#	CREATE NEWSRC FILE
######################

cat <<! >$HOME/files/ftp/igo/newsrc
INTERact.adverts:
INTERact.announce:
INTERact.chat:
!


############################
#	CREATE WINSOCK.CFG FILES
############################

#
#	Create file: hosts 
#
cat <<! >$HOME/files/ftp/igo/winsock.cfg/hosts

localhost						127.0.0.1

!


#
#	Create file: trumpwsk.ini
#
cat <<! >$HOME/files/ftp/igo/winsock.cfg/trumpwsk.ini
[Trumpet Winsock]
ip=$IPADDR
netmask=255.0.0.0
gateway=10.1.1.4
dns=10.1.1.4
time=
domain=jags.co.uk
vector=00
mtu=296
rwin=848
mss=512
rtomax=60
ip-buffers=32
slip-enabled=1
slip-port=$PORT
slip-baudrate=38400
slip-handshake=1
slip-compressed=0
dial-option=1
online-check=0
inactivity-timeout=60
slip-timeout=10
slip-redial=0
dial-parity=0
font=Courier,9
registration-name=""
registration-password="h[G?"Rgl"
use-socks=0
socks-host=0.0.0.0
socks-port=1080
socks-id=
socks-local1=0.0.0.0 0.0.0.0
socks-local2=0.0.0.0 0.0.0.0
socks-local3=0.0.0.0 0.0.0.0
socks-local4=0.0.0.0 0.0.0.0
ppp-enabled=0
ppp-usepap=0
ppp-username=""
ppp-password=""
win-posn=30 30 1020 690 -1 -1 -1 -1 1
trace-options=0
!


#
#	Create file: login.cmd
#	(Dynamic SLIP sign-on)
#
cat <<! >$HOME/files/ftp/igo/winsock.cfg/login.cmd

outputecho AT &F\r
outputecho AT &F\r
input 10 OK

outputecho ATDT$NUMBER\r
input 60 CONNECT

input 60 ogin:
output $USERNAME Slip\r

input 10 assword:
output $PASSWORD\r

input 10 "Your address is "
address 5


display \n\n
display Connected OK to INTERact BBS\n
display Your address is \i.\n

sleep 4
!


#
########################
#	CREATE WWW.CFG FILES
########################

#
#	Create the netscape.ini file
#
sed 's/c:\\newsrc/c:\\igo\\newsrc/' $HOME/files/ftp/igo/www/netscape.ini |
sed 's/c:\\netscape/c:\\igo\\netscape/' |
sed 's/^Home Page=.*/Home Page=http:\/\/www.jags.co.uk/' |
sed 's/^NNTP_Server.*/NNTP_Server=news.jags.co.uk/' |
sed 's/^SMTP_Server.*/SMTP_Server=mail.jags.co.uk/' |
sed "s/^User_Name.*/User_Name=$USER_NAME/" |
sed 's/^User_Addr.*/User_Addr='$USERNAME'@jags.co.uk/' > $HOME/files/ftp/igo/www.cfg/netscape.ini 


##############################
#	CREATE THE EMAIL.CFG FILES
##############################

#
#	Create the eudora.ini file
#
cp $HOME/files/ftp/igo/email/eudora.ini $HOME/files/ftp/igo/email.cfg/eudora.ini
cat <<! >>$HOME/files/ftp/igo/email.cfg/eudora.ini
[Settings]
SavePasswordText=
SaveDialupPasswordText=
LastSettingsCategory=0
RealName=$USER_NAME
POPAccount=$USERNAME@jags.co.uk
SMTPServer=mail.jags.co.uk
SavePassword=1

[Open Windows]
OpenWindow1=2,1,In.mbx,In

!



########################################
#	COPY THE IGO.EXE FILE INTO TOP LEVEL
########################################

cp $bbsdata/igo/igo.exe $HOME/files/ftp/igo


####################################################
#	COPY THE INTERact WINDOWS GROUP INTO IGO\WINDOWS
####################################################

cp $bbsdata/igo/interact.grp $HOME/files/ftp/igo/windows


###########################
#	CREATE THE IGO.ZIP FILE
###########################


cd $HOME/files/ftp

echo "INTERact BBS  (UK) 01753 775533
IGO.ZIP $VERSION" > igo/igo.rel

rm -f igo.zip </dev/null >/dev/null 2>&1
nice zip -rk1m  igo.zip igo 

echo "INTERact BBS  (UK) 01753 775533
IGO.ZIP $VERSION" | zip -z igo.zip >/dev/null

rm -rf igo

echo "Archive created OK"

case $LOGNAME in
sysop)	mdel a:* a:*.* 2>/dev/null
		mcopy $bbsusers/sysop/files/ftp/igo.zip a:
		mcopy $bbsdata/igo/misc/* a:
		mlabel a: <<END
$USERNAME
END
		;;
esac
	
sleep 3
