#!/bin/sh

#
#	Disable ctrl c
#

tty -s
if [ $? -eq 0 ]
then
	stty intr '' 2>/dev/null
fi


#
#	This should ensure that the pound() is displayed correctly
#
LESSCHARSET=latin1
export LESSCHARSET

#
#	Needed for the help function to work!!
#
SHELL=/bin/sh
export SHELL

#
#	A safety net.  If this process does go ape, we must terminate it.
#	20 seconds of CPU is more than enough.
#
ulimit -t 20


#
#	Notice that I use dirname and basename so that less is not called with
#	the full pathname to a file (which a user would be able to see and so
#	perhaps develop a good understanding of the file structure - Now
#	we don't want that do we)
#
if [ -n "$1" ]
then
	cd "`dirname \"$1\"`"
	exec nice $bbsbin/less.noshell -x4 -f -d -i "`basename \"$1\"`"
else
	exec nice $bbsbin/less.noshell -x4 -f -d -i
fi
