#!/bin/ksh
#
#	Script to collect all auto.*.* files and
#	then extract uuencoded files from it.
#
#
#	Usage: <dir>
#
#	Will CD to that directory
#
#	Build a list of all auto.*.* files and compile information
#	on which files relate to which output file.
#
#	For each entry in it's list, cat like files and uudecode
#
#	Original sources are removed and are temporary files
#	created in that and /tmp directories.
#


if [ $# -eq 0 ]
then
	echo "autodecode, Invalid usage"
	echo "autodecode: <directory>"
	exit 1
fi


cd $1

trap "\rm -f /tmp/auto.$$ *.auto 2>/dev/null" 0 1 2 3

last=""
export last



(
for i in auto.*.*
do
	info=`awk '/^begin/ { print $3 " '$i'" }' $i`

	if [ -z "$info" ]
	then
		sed -n '9,$p' $i | sed -n '/^M/p' >> $last
		rm $i
	else
		echo $info

		last=$i
	fi

done | sort 
echo STOPAUTO
) > /tmp/auto.$$


lastout=""
export lastout

cat /tmp/auto.$$ | 
while read l
do
	#
	#	$1 = Output file
	#	$2 = Source file
	#
	set $l
	
	echo $1 $2


	if [ $1 != "$lastout" ]
	then

		if [ -n "$lastout" ]
		then
			echo '`' >> $lastout.auto
			echo 'end' >> $lastout.auto

			echo $lastout
			uudecode $lastout.auto

			rm -f $lastout.auto
		fi
	

		lastout=$1

		case $lastout in
		STOPAUTO)	exit 0
					;;
		esac
			

		echo "begin 644 $lastout" > $lastout.auto
	fi


	awk '
BEGIN		{ p=0 }

/^`$/		{ p=0 }
			{ if ( p == 1 ) print }
/^begin/	{ p=1 }' $2 >> $lastout.auto

done


if [ -n "$lastout" ]
then
	echo '`' >> $lastout.auto
	echo 'end' >> $lastout.auto

	uudecode $lastout.auto

	\rm -f $lastout.auto
fi	



\rm -f auto.*.*
