#!/bin/ksh
#
#	Script to check for modem lines with defunct processes attached
#
#	<-kill>			to force a kill
#	<-kill>	<-proc>	to force a kill, but only the listed processes on the
#					command line. 
#
#	checklines.sh -kill, will infact re-run this script 2 minutes later with
#	the list of processes to kill.  The second time round, we'll only kill
#	those processes supplied to this script.  This allows us to find dodgy
#	processes and kill them 2 minutes later, if they are still present on
#	the system.
#
#


for i in $*
do
	case $i in
	-kill)	dokill="Y"	
			;;
	-proc)	proclist="Y"
			;;
	esac
done


trap "rm -f /tmp/checklines.?.$$ >/dev/null 2>&1" 0 1 2 3


#
#	Get list of all dialup lines
#
list=`cd $bbsconfig/dynamicIp ; \ls | grep -v default`

#
#	Get list of devices that it's ok to have many processes on	
#
who | awk '{ print $2 }' > /tmp/checklines.1.$$


#
#	Get list of dialup's with processes attached, which shouldn't
#
cd /dev
fuser $list 2>&- |
	sed 's/://' |
	awk '{ if ( NF > 2 ) print }' |
	egrep -v -f /tmp/checklines.1.$$ > /tmp/checklines.2.$$

if [ -s /tmp/checklines.2.$$ ]
then
	echo 'First pass..'
	cat /tmp/checklines.2.$$
fi


#
#	If -kill supplied and there are some dodgy processes.. do the killing
#
if [ -n "$dokill" -a -s /tmp/checklines.2.$$ ]
then
	#
	#	If we've not been supplied with a process list then
	#	sleep 60 seconds and then call self again to kill those processes
	#	(after comparing which processes we find to be unwanted, compared to
	#	 to the list of unwanted processes that we already have)
	#
	if [ -z "$proclist" ]
	then
		sleep 60
		exec $bbsbin/util/checklines.sh -kill -proc < /tmp/checklines.2.$$
	fi

	#
	#	Compare the list of unwanted processes against what we had last time
	#	if any differences then abort the kill and try to look again in 60
	#	seconds
	#
	if diff - /tmp/checklines.2.$$
	then
		#
		#	Same again, means that we can kill the processes without feeling
		#	guilty.
		#
		echo 'Killing :-' >&2
		sed 's/[a-zA-Z0-9]*[ 	]/' /tmp/checklines.2.$$ >&2
		echo >&2
		echo 'Process list :-' >&2
		ps -axu >&2

		kill -9 `set +x ; sed 's/[a-zA-Z0-9]*[ 	]/' /tmp/checklines.2.$$`
	else
		#
		#	Processes that we want to kill have changed over the last minute
		#	so, don't kill and check again in 1 minute.
		#
		sleep 60
		exec $0 -kill -proc < /tmp/checklines.2.$$
	fi
fi
