#!/bin/sh
#
#
#	INTERACT install script (config.sh)
#

#
#	Check to location
#

to=`dirname $0`
to=`dirname $to`
to=`dirname $to`

if [ -z "$to" -o "$to" = "." ]
then
	from=`pwd`
	from=`dirname $to`
	from=`dirname $to`
fi

#
#	Get the bbs environment
#
bbsdir=$to
. $to/config/environment


#
#	Add BBS group if not present
#
grep BBS /etc/group >/dev/null 2>&1
if [ $? -ne 0 ]
then
	echo "BBS:*:500:" >> /etc/group
else
	echo "Group BBS already presend in /etc/group"
fi


#
#	Added sysop user
#
touch /etc/shadow /etc/gshadow

/usr/sbin/useradd -c "The System Operator" -d $to/users/sysop -g 500 \
				  -s $to/bin/bbs.sh -u 500  sysop
if [ $? -ne 0 ]
then
	echo "User sysop already exists - NOT CREATED"
else
	echo "User sysop CREATED"
fi


#
#	Create bbs tree for sysop
#
$to/bin/control/relink.sh sysop



#
#	Install rc.bbs
#
cp $to/bin/etc/rc.bbs /etc/rc.d/rc.bbs
chmod +x /etc/rc.d/rc.bbs

grep rc.bbs /etc/rc.d/rc.local >/dev/null 2>&1
if [ $? -ne 0 ]
then
	echo "/etc/rc.d/rc.bbs $to -control -chat -www" >> /etc/rc.d/rc.local
	echo "/etc/rc.d/rc.bbs added to /etc/rc.d/rc.local"
else
	echo "/etc/rc.d/rc.bbs already present in /etc/rc.d/rc.local"
fi


#
#	Install the terminfo files.
#
cd $to/terminfo/bin
for i in $*
do
	first=`echo $i | cut -c1`
	mkdir -p /usr/lib/terminfo/$first
	cp $i /usr/lib/terminfo/$first
done


#
#	Install the termcap file
#
sed '/INTERact TERMCAP/,$d' /etc/termcap > /etc/termcap.new
cat $to/terminfo/termcap >> /etc/termcap.new
mv /etc/termcap /etc/termcap.old
mv /etc/termcap.new /etc/termcap
chmod 744 /etc/termcap

#
#	Add bbsdir= to system profile
#
grep -v bbsdir /etc/profile > /etc/profile.new
echo "bbsdir=$bbsdir" >> /etc/profile.new
echo "export bbsdir" >> /etc/profile.new
echo '. $bbsdir/config/environment' >> /etc/profile.new
mv /etc/profile /etc/profile.old
mv /etc/profile.new /etc/profile
chmod 744 /etc/profile

#
#	Run the rc.bbs
#
/etc/rc.d/rc.bbs $to -control -chat


#
#	Sysop sign-on
#
echo "About to run bbs as sysop.  Simply answer Y when prompted to
create database.."
echo
echo "(Press any key to continue)"
$to/bin/onekey 1000
su - sysop


