#!/bin/sh
#
#
#	INTERACT install script (interact.sh)
#
#	$1	Directory to install to
#

#
#	Check to location
#
to=$1
if [ -z "$to" ]
then
	echo "Please supply a directory to install to"
	exit 1
fi


UPGRADE=N
export UPGRADE

if [ -f "$to" -o -d "$to" ]
then
	echo "Install location $to already present"
	if [ -f "$to.old" -o -d "$to.old" ]
	then
		echo "ERROR: The $to.old directory already exists.."
		echo "       .. perhaps a failed upgrade?"
		echo "       Either remove the $to.old directory"
		echo "       or remove $to and rename $to.old"
		echo "       to $to."
	
		exit 3
	fi


	echo "Are we upgrading?  Enter 'yes' if we are"

	read r
	case $r in
		yes)	;;
		*)		echo "Abort"
				exit 2
				;;
	esac

	UPGRADE=Y
fi


from=`dirname $0`

if [ -z "$from" -o "$from" = "." ]
then
	from=`pwd`
fi



#
#	The interact.sh and interact.tar must be in the same
#	directory
#
if [ ! -f "$from/interact.tar" -a ! -f "$from/interact.tar.gz" ]
then
	echo "Can't find the interact tar archive in the directory"
	echo "that interact.sh is in  ($from)"
	exit 3
fi


#
#	We're upgrading.. Save existing environment
#
if [ "$UPGRADE" = "Y" ]
then
	echo "Backing up.."
	mv $to $to.old
	if [ $? -ne 0 ]
	then
		echo "Failed to make backup of existing install"
		exit 4
	fi
fi



#
#	Make install location
#
mkdir -p $to
if [ $? -ne 0 ]
then
	echo "Failed to make directory $to"
	exit 4
fi
	


#
#	Untar to install location
#
cd $to
(
if [ -f "$from/interact.tar.gz" ]
then
	gunzip -c $from/interact.tar.gz
else
	cat $from/interact.tar
fi
) |
tar xvf -


#
#	Restore installation specific files..
#
cd $to.old
tar cf - accounts | ( cd $to ; tar xvf - )
tar cf - config | ( cd $to ; tar xvf - )
tar cf - userdb | ( cd $to ; tar xvf - )
tar cf - users | ( cd $to ; tar xvf - )
tar cf - tree | ( cd $to ; tar xvf - )




$to/bin/util/config.sh 


