/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __kom__aggregate_h__
#define __kom__aggregate_h__

#include "kom.h"
#include "komComponent.h"

class KOMAggregateFactory : virtual public KOMComponentFactory,
			    virtual public KOM::AggregateFactory_skel
{
public:
  // You have to implement these on your own!
  // virtual ::KOM::Aggregate_ptr create( Component_ptr core );
};

class KOMAggregate : virtual public KOMComponent,
		     virtual public KOM::Aggregate_skel
{
public:
  virtual ~KOMAggregate();
  
  // C++
  virtual void cleanUp();

  // IDL
  virtual KOM::ID addAggregate( KOM::AggregateFactory_ptr _factory,
				const KOM::InterfaceSeq& _required,
				const KOM::InterfaceSeq& _provided,
				CORBA::Boolean _activate);
  virtual void removeAggregate( KOM::ID _id );

  virtual KOM::ID addPlugin( KOM::PluginFactory_ptr _factory,
			     const KOM::InterfaceSeq& _required,
			     const KOM::InterfaceSeq& _required_plugins,
			     const KOM::InterfaceSeq& _provided,
			     CORBA::Boolean _activate);
  virtual void removePlugin( KOM::ID _id );
  
  virtual CORBA::Object_ptr getInterface( const char* name );
  virtual KOM::InterfaceSeq* interfaces();
  virtual CORBA::Boolean supportsInterface( const char* name );

  virtual CORBA::Object_ptr getPluginInterface( const char* name );
  virtual KOM::InterfaceSeq* pluginInterfaces();
  virtual CORBA::Boolean supportsPluginInterface( const char* name );

  virtual KOM::Component::PluginInfoSeq* describePlugins();
  virtual KOM::Plugin_ptr getPlugin( KOM::ID id );

  virtual KOM::Component_ptr parent();
  
protected:
  KOMAggregate( KOM::Component_ptr _com );
  
  KOM::Component_var m_vParent;

};

#endif

