#!/usr/local/bin/python

# Qt tutorial 6.

import sys
from kde import *


class LCDRange(QWidget):
	def __init__(self,*args):
		apply(QWidget.__init__,(self,) + args)

		self.lcd = QLCDNumber(2,self,"lcd")
		self.lcd.move(0,0)
		self.sBar = QScrollBar(0,99, \
				       1,10, \
				       0, \
				       QScrollBarOrientation.Horizontal, \
				       self,"scrollbar")
		connect(self.sBar,SIGNAL("valueChanged(int)"),self.lcd,SLOT("display(int)"))

	def resizeEvent(self,resizeEvent):
		self.sBar.setGeometry(0,self.height() - 16,self.width(),16)
		self.lcd.resize(self.width(),self.sBar.y() - 5)


class MyWidget(QWidget):
	def __init__(self,*args):
		apply(QWidget.__init__,(self,) + args)

		self.setMinimumSize(200,300)

		self.quit = QPushButton("Quit",self,"quit")
		self.quit.setGeometry(10,10,75,30)
		self.quit.setFont(QFont("Times",18,QFontWeight.Bold))

		connect(self.quit,SIGNAL("clicked()"),qApp,SLOT("quit()"))

		self.value = []

		for i in range(16):
			self.value.append(LCDRange(self))

	def resizeEvent(self,resizeEvent):
		startx = 10
		starty = self.quit.y() + self.quit.height() + 10
		valueWidth = (self.width() - startx - 10 - 3 * 5) / 4
		valueHeight = (self.height() - starty - 10 - 3 * 5) / 4

		for i in range(16):
			self.value[i].setGeometry(startx + (i % 4) * (5 + valueWidth), \
						  starty + (i / 4) * (5 + valueHeight), \
						  valueWidth,valueHeight)


qApp = a = QApplication(sys.argv)

w = MyWidget()
w.setGeometry(100,100,400,400)
a.setMainWidget(w)
w.show()
a.exec_loop()
