#!/usr/local/bin/python

# Qt tutorial 7.

import sys
from kde import *


class LCDRange(QWidget):
	def __init__(self,*args):
		apply(QWidget.__init__,(self,) + args)

		self.lcd = QLCDNumber(2,self,"lcd")
		self.lcd.move(0,0)
		self.sBar = QScrollBar(0,99, \
				       1,10, \
				       0, \
				       QScrollBarOrientation.Horizontal, \
				       self,"scrollbar")
		connect(self.sBar,SIGNAL("valueChanged(int)"),self.lcd,SLOT("display(int)"))
		connect(self.sBar,SIGNAL("valueChanged(int)"),self,PYSIGNAL("valueChanged(int)"))

	def value(self):
		return self.sBar.value()

	def setValue(self,value):
		self.sBar.setValue(value)

	def resizeEvent(self,resizeEvent):
		self.lcd.resize(self.width(),self.height() - 16 - 5)
		self.sBar.setGeometry(0,self.lcd.height() + 5,self.width(),16)


class MyWidget(QWidget):
	def __init__(self,*args):
		apply(QWidget.__init__,(self,) + args)

		self.setMinimumSize(200,300)

		self.quit = QPushButton("Quit",self,"quit")
		self.quit.setGeometry(10,10,75,30)
		self.quit.setFont(QFont("Times",18,QFontWeight.Bold))

		connect(self.quit,SIGNAL("clicked()"),qApp,SLOT("quit()"))

		self.value = []

		for i in range(16):
			self.value.append(LCDRange(self))
			if i > 0:
				connect(self.value[i],PYSIGNAL("valueChanged(int)"), \
					self.value[i - 1].setValue)

	def resizeEvent(self,resizeEvent):
		valueWidth = (self.width() - 20) / 4
		valueHeight = (self.height() - 65) / 4

		for i in range(16):
			self.value[i].setGeometry(10 + (i % 4) * valueWidth, \
						  55 + (i / 4) * valueHeight, \
						  valueWidth - 5,valueHeight - 5)


qApp = a = QApplication(sys.argv)

w = MyWidget()
w.setGeometry(100,100,400,400)
a.setMainWidget(w)
w.show()
a.exec_loop()
