/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

#include <Python.h>
#include <graminit.h>

#include <qstring.h>
#include <kapp.h>

#include <iostream>

PyObject* pModule;
PyObject* pDict;

static int runCodeStr( char *code )
{
  PyObject *presult = PyRun_String( code, file_input, pDict, pDict );
  if ( presult == 0L )
  {    
    PyErr_Print();
    return -1;
  }

  Py_XDECREF( presult );
  return 0;
}

static int runFile( const char *_filename )
{
  FILE *f = fopen( _filename, "r" );
  if ( !f )
    return -1;

  QString script;
  char buffer[ 4096 ];
  while ( !feof( f ) )
  {
    int n = fread( buffer, 1, 4095, f );
    if ( n > 0 )
    {
      buffer[n] = 0;
      script += buffer;
    }
  }
  fclose( f );

  return runCodeStr( script.data() );
}


int main( int argc, char **argv )
{
  Py_Initialize();
  pModule = PyImport_AddModule( "kypthon" );
  assert( pModule );
  
  pDict = PyModule_GetDict( pModule );
  assert( pDict );
  
  PyDict_SetItemString( pDict, "__dummy__", Py_None );
  PyDict_SetItemString( pDict, "__builtins__", PyEval_GetBuiltins() );

  QString tmp = "import sys\n";
  runCodeStr( (char*)tmp.data() );
  tmp += "sys.path = [ \"";
  tmp += kapp->kde_bindir().data();
  tmp += "/../include/python\", \"";
  tmp += kapp->kde_bindir().data();
  tmp += "/../lib\", ] + sys.path\n";
  runCodeStr( (char*)tmp.data() );
  tmp = "from kde import *\n";
  runCodeStr( (char*)tmp.data() );

  if ( argc > 1 )
  {
    PySys_SetArgv( argc - 1, argv + 1);
    if ( runFile( argv[1] ) != 0 )
    {
      exit(1);
    }
  }
  
  if ( argc <= 1 )
  {
    PySys_SetArgv( argc, argv );

    cout << "============== KDE Python ==============" << endl;
    cout << "Version 0.1, released 26. Jan. 1999" << endl;
    cout << "(c) Torben Weis, weis@kde.org" << endl;
    cout << "========================================" << endl;

    PyRun_InteractiveLoop( stdin, "<stdin>" );
  }
  
  return 0;
}
