/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __op_autoloader_h__
#define __op_autoloader_h__

#include "openparts.h"
#include "opApplication.h"

#include <qstring.h>

template<class X>
class OPAutoLoader : public CORBA::BOAObjectRestorer
{
public:
    OPAutoLoader( const char *_repoid, const char *_tag ) { m_strRepoId = _repoid; m_strTag = _tag; }
  
    CORBA::Boolean restore( CORBA::Object_ptr _obj )
    {
      if ( m_strRepoId == _obj->_repoid() )
      {
	cerr << "restoring ... " << endl;
	(void)new X( _obj );
	cerr << "restored ... " << endl;
	return TRUE;
      }
      cout << "cannot restore " << _obj->_repoid() << " objects" << endl;
      return FALSE;
    }

    CORBA::Boolean bind( const char *repoid, const CORBA::ORB::ObjectTag &tag )
    {
      if ( strcmp( repoid, m_strRepoId ) == 0 )
      {
	CORBA::String_var str;
	str = opapp_orb->tag_to_string( tag );
	if ( strcmp( str.in(), m_strTag ) != 0L )
	  return FALSE;
	
	cerr << "creating " << str.in() << " ... " << endl;
	(void)new X( tag );
	return TRUE;
      }
      return FALSE;
    }

protected:
  QString m_strRepoId;
  QString m_strTag;
};

#endif
