/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __op_MainWindow_h__
#define __op_MainWindow_h__

#include <ktmainwindow.h>
#include <qintdict.h>

#include <opToolBar.h>
#include <opStatusBar.h>

class OPMainWindowIf;
class OPMenuBar;
class OPMenuBarManager;
class OPToolBarFactory;
class OPToolBarManager;
class OPStatusBarManager;
class OPToolBar;
class OPStatusBar;

class OPMainWindow : public KTMainWindow
{
  Q_OBJECT

  friend OPMainWindowIf;
  
public:
  OPMainWindow( const char *_name = 0L );
  ~OPMainWindow();

  virtual OPMainWindowIf* interface();

  /**
   * The Toolbars created with this function are always persistent and not
   * managed by the @ref OPToolBarManager. This function is a replacement for
   * @ref #toolBar which just returns an ordinary @ref KToolBar.
   */
  virtual OPToolBar* opToolBar( int _id = 0 );
  /**
   * Do NOT use together with the @ref OPMenuBarManager.
   * This function is a replacement for @ref #menuBar which just returns an ordinary @ref KMenuBar.
   */
  virtual OPMenuBar* opMenuBar();
  
  /**
   * Used in conjunction with @ref OPMenuBarManager
   */
  virtual void createFileMenu( OPMenuBar* ) { }
  /**
   * Used in conjunction with @ref OPMenuBarManager
   */
  virtual void createHelpMenu( OPMenuBar* ) { }
  /**
   * @return a pointer to the @ref OPMenuBarManager.
   *         If there is yet no one, then a OPMenuBarManager
   *         is created. When using the menu bar manger you should implement
   *         @ref #createFileMenu and @ref #createHelpMenu. The manager will
   *         call this function to tell you, when you have to create or release
   *         our menu.
   */
  virtual OPMenuBarManager* menuBarManager();
  virtual bool hasMenuBarManager() { return ( m_pMenuBarManager != 0L ); }

  virtual OPToolBarManager* toolBarManager();
  virtual bool hasToolBarManager() { return ( m_pToolBarManager != 0L ); }

  virtual OPToolBarFactory* toolBarFactory();
  virtual bool hasToolBarFactory() { return ( m_pToolBarFactory != 0L ); }
  
  virtual OPStatusBarManager* statusBarManager();
  virtual bool hasStatusBarManager() { return ( m_pStatusBarManager != 0L ); }

  /**
   * If AutoCaption mode is enabled, the main window will automatically set
   * the main window caption, corresponding to the caption of the active part.
   * If AutoCaption mode is disabled the window caption will not change when
   * the active part changes.
   */
  virtual bool autoCaptionMode() { return m_bAutoCaption; }
  virtual void setAutoCaption( bool flag ) { m_bAutoCaption = flag; }
  
signals:  
  void activePartChanged( unsigned long _new_part_id, unsigned long _old_part_id );
  
protected:
  void emitActivePartChanged( unsigned long _new_part_id, unsigned long _old_part_id );

  bool m_bAutoCaption;
  
  OPMainWindowIf* m_pInterface;
  /**
   * Used by @ref #opMenuBar
   */
  OPMenuBar* m_pMenuBar;
  OPMenuBarManager* m_pMenuBarManager;
  OPToolBarManager* m_pToolBarManager;
  OPToolBarFactory* m_pToolBarFactory;
  OPStatusBarManager* m_pStatusBarManager;
  QIntDict<OPToolBar> m_mapToolBars;
};

#endif
