/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __op_MainWindow_if_h__
#define __op_MainWindow_if_h__

class OPMainWindow;
class OPMainWindowIf;

#include "openparts.h"
#include "opMainWindow.h"

#include <komComponent.h>

#include <qwidget.h>


class OPMainWindowIf : virtual public KOMComponent,
		       virtual public OpenParts::MainWindow_skel
{
public:
  // C++
  OPMainWindowIf( OPMainWindow* _main );
  ~OPMainWindowIf();

  // IDL
  virtual void setActivePart( OpenParts::Id Part );
  virtual OpenParts::Part_ptr activePart();
  virtual OpenParts::Id activePartId();

  /**
   * @return true if the click event should be consumed
   *         or false if not. This implementation always
   *         return false.
   */
  virtual CORBA::Boolean partClicked( OpenParts::Id part, CORBA::Long button );
  
  virtual void setSize( CORBA::Long _width, CORBA::Long _height );
  virtual void setPosition( CORBA::Long _x, CORBA::Long _y );

  virtual char *partCaption( OpenParts::Id part );
  virtual void setPartCaption( OpenParts::Id part, const char *caption );

  virtual OpenParts::MenuBarManager_ptr menuBarManager();
  virtual OpenParts::ToolBarManager_ptr toolBarManager();
  virtual OpenPartsUI::ToolBarFactory_ptr toolBarFactory();
  virtual OpenParts::StatusBarManager_ptr statusBarManager();
  
  // C++
  virtual OPMainWindow* window() { return m_pMainWindow; }

  virtual OpenParts::Id registerPart( OpenParts::Part_ptr Part, const char *caption );
  virtual void unregisterPart( OpenParts::Id id );
  
  virtual void cleanUp();
  
  OpenParts::Part_ptr findPart( OpenParts::Id Part );

protected:  
  /**
   * Holds the active part. May be 0L is no active part is set.
   */
  OpenParts::Part_var m_vActivePart;
  /**
   * We hold this due to better performance.
   * m_vActivePart->id() always leeds to the same result.
   */
  OpenParts::Id m_idActivePart;

  OPMainWindow* m_pMainWindow;

  /**
   * Maps IDs to parts.
   */
  map<OpenParts::Id,OpenParts::Part_var> m_mapParts;

  /**
   * Maps IDs to caption texts.
   */
   map<OpenParts::Id,string> m_mapCaptions;

  /**
   * The id counter. We need this to give each registered part
   * some unique id. The minimum valid id is '1'. An Id of '0'
   * is illegal.
   */
  OpenParts::Id m_id;
};

typedef KOMVar<OpenParts::MainWindow> OPMainWindow_ref;

#endif

