/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "opMenuBarManager.h"
#include "opMainWindowIf.h"
#include "opMainWindow.h"
#include <opMenuIf.h>
#include <opMenu.h>

OPMenuBarManager::OPMenuBarManager( OPMainWindow *_main )
{
  m_pMainWindow = _main;
  m_activeId = 0;

  cerr << "Creating menubar" << endl;
  
  m_pMenuBar = m_pMainWindow->opMenuBar();
}

OPMenuBarManager::~OPMenuBarManager()
{
}

void OPMenuBarManager::registerClient( OpenParts::Id id, KOM::Base_ptr client )
{
  cerr << "OPOMenu: register " << id << endl;

  m_mapCallbacks[ id ] = KOM::Base::_duplicate( client );
}

void OPMenuBarManager::unregisterClient( OpenParts::Id id )
{
  cerr << "OPOMenu: unregister " << id << endl;
  
  // Did we just unregister the active part ? => clear the menubar and unregister the part afterwards
  if ( id == m_activeId )
  {
    clear();
    m_activeId = 0;
  }

  map<OpenParts::Id,KOM::Base_var>::iterator it = m_mapCallbacks.find( id );
  assert( it != m_mapCallbacks.end() );
  m_mapCallbacks.erase( it, ++it );   
}

void OPMenuBarManager::create( OpenParts::Id id )
{
  // No changes ?
  if ( id == m_activeId && id != 0 )
    return;
  
  cerr << "CREATING " << id << endl;

  map<OpenParts::Id,KOM::Base_var>::iterator it = m_mapCallbacks.find( id );
  if( id != 0 && it == m_mapCallbacks.end() )
  {
    cerr << "ERROR: void OPMenuBarManager::create( OpenParts::Id id )" << endl;
    cerr << "       Unknown id " << id << endl;
    id = 0;
  }
  
  if ( id )
    EMIT_EVENT( it->second, OpenPartsUI::eventCreateMenuBar, m_pMenuBar->interface() );

  m_pMainWindow->createFileMenu( m_pMenuBar );
  m_pMainWindow->createHelpMenu( m_pMenuBar );

  m_activeId = id;
}

void OPMenuBarManager::clear()
{
  cerr << "CLEARING " << m_activeId << endl;

  // Tell all involved parties that the menu bar is cleared now and their menus are
  // removed.

  m_pMainWindow->createHelpMenu( 0L );
  
  if ( m_activeId != 0 )
  {    
    map<OpenParts::Id,KOM::Base_var>::iterator it = m_mapCallbacks.find( m_activeId );
    if ( it != m_mapCallbacks.end() )
    {
      cerr << "SENDING Menu Clear Event" << endl;
      EMIT_EVENT( it->second, OpenPartsUI::eventCreateMenuBar, (OpenPartsUI::typeCreateMenuBar_ptr)0L );
    }
    else
    {
      cerr << "ERROR: void OPMenuBarManager::clear()" << endl;
      cerr << "       Unknown id " << m_activeId << endl;
    }
  }
  
  m_pMainWindow->createFileMenu( 0L );

  m_pMenuBar->reset();
}

