/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "opToolBarManager.h"
#include "opMainWindowIf.h"
#include "opMainWindow.h"
#include <opToolBarIf.h>
#include <opToolBar.h>

OPToolBarManager::OPToolBarManager( OPMainWindow *_main )
{
  m_pMainWindow = _main;
  m_activeId = 0;

  cerr << "Creating toolbar" << endl;
  
  m_pToolBarFactory = new OPToolBarFactory( m_pMainWindow );
}

OPToolBarManager::~OPToolBarManager()
{
}

void OPToolBarManager::registerClient( OpenParts::Id id, KOM::Base_ptr client )
{
  cerr << "OPOTool: register " << id << endl;

  m_mapCallbacks[ id ] = KOM::Base::_duplicate( client );
}

void OPToolBarManager::unregisterClient( OpenParts::Id id )
{
  cerr << "OPOTool: unregister " << id << endl;
  
  // Did we just unregister the active part ? => clear the toolbar and unregister the part afterwards
  if ( id == m_activeId )
  {
    clear();
    m_activeId = 0;
  }

  map<OpenParts::Id,KOM::Base_var>::iterator it = m_mapCallbacks.find( id );
  assert( it != m_mapCallbacks.end() );
  m_mapCallbacks.erase( it, ++it );   
}

void OPToolBarManager::create( OpenParts::Id id )
{
  // No changes ?
  if ( id == m_activeId )
    return;
  
  cerr << "CREATING TOOLBAR" << id << endl;

  map<OpenParts::Id,KOM::Base_var>::iterator it = m_mapCallbacks.find( id );
  if( id != 0 && it == m_mapCallbacks.end() )
  {
    cerr << "ERROR: void OPToolBarManager::create( OpenParts::Id id )" << endl;
    cerr << "       Unknown id " << id << endl;
    id = 0;
  }
  
  if ( id )
    EMIT_EVENT( it->second, OpenPartsUI::eventCreateToolBar, m_pToolBarFactory );

  m_activeId = id;
}

void OPToolBarManager::clear()
{
  cerr << "CLEARING " << m_activeId << endl;

  // Tell all involved parties that the tool bar is cleared now and their tools are
  // removed.

  if ( m_activeId != 0 )
  {    
    map<OpenParts::Id,KOM::Base_var>::iterator it = m_mapCallbacks.find( m_activeId );
    if ( it != m_mapCallbacks.end() )
    {
      EMIT_EVENT( it->second, OpenPartsUI::eventCreateToolBar, (OpenPartsUI::typeCreateToolBar_ptr)0L );
    }
    else
    {
      cerr << "ERROR: void OPToolBarManager::clear()" << endl;
      cerr << "       Unknown id " << m_activeId << endl;
    }
  }

  cerr << "Remove Transient bars" << endl;
  m_pToolBarFactory->removeTransientBars();
  cerr << "Removed Transient bars" << endl;
}

