/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

/*
Sun Dec 20 20:33:22 1998 Simon Hausmann <tronical@gmx.net>
    * added signals: highlighted, aboutToShow
    * fixed bug in insertItem4 (id and accel were unused)
*/

#ifndef __OPmenuif_h__
#define __OPmenuif_h__

#include "openparts_ui.h"
#include "opMenu.h"

#include <komBase.h>

#include <qintdict.h>
#include <qdict.h>
#include <map>

class OPMenuIf;
class OPMenu;
class OPMenuBar;

#include "opQCProxy.h"

class OPMenuDataIf : virtual public KOMBase,
		     virtual public OpenPartsUI::MenuData_skel
{
public:
  OPMenuDataIf( OPMenu* _menu );
  ~OPMenuDataIf();
  
  virtual void cleanUp();
  
  virtual CORBA::ULong count();
  virtual CORBA::Long insertItem( const char* text, CORBA::Object_ptr receiver,
				  const char* member, CORBA::Long accel );
  virtual CORBA::Long insertItem2( const OpenPartsUI::Pixmap& pixmap,
				   CORBA::Object_ptr receiver, const char* member,
				   CORBA::Long accel );
  virtual CORBA::Long insertItem3( const OpenPartsUI::Pixmap& pixmap,
				   const char* text, CORBA::Object_ptr receiver,
				   const char* member, CORBA::Long accel );
  virtual CORBA::Long insertItem4( const char* text, CORBA::Object_ptr receiver,
				   const char* member, CORBA::Long accel,
				   CORBA::Long id, CORBA::Long index );
  virtual CORBA::Long insertItem5( const OpenPartsUI::Pixmap& pixmap,
				   CORBA::Object_ptr receiver, const char* member,
				   CORBA::Long accel, CORBA::Long id,
				   CORBA::Long index );
  virtual CORBA::Long insertItem6( const OpenPartsUI::Pixmap& pixmap,
				   const char* text, CORBA::Object_ptr receiver,
				   const char* member, CORBA::Long accel,
				   CORBA::Long id, CORBA::Long index );
  virtual CORBA::Long insertItem7( const char* text, CORBA::Long id,
				   CORBA::Long index );
  virtual CORBA::Long insertItem8( const char* text, ::OpenPartsUI::Menu_ptr& popup,
				   CORBA::Long id, CORBA::Long index );
  virtual CORBA::Long insertItem9( const OpenPartsUI::Pixmap& pixmap,
				   CORBA::Long id, CORBA::Long index );
  virtual CORBA::Long insertItem10( const OpenPartsUI::Pixmap& pixmap,
				    ::OpenPartsUI::Menu_ptr& popup, CORBA::Long id,
				    CORBA::Long index );
  virtual CORBA::Long insertItem11( const OpenPartsUI::Pixmap& pixmap,
				    const char* text, CORBA::Long id,
				    CORBA::Long index );
  virtual CORBA::Long insertItem12( const OpenPartsUI::Pixmap& pixmap,
				    const char* text, ::OpenPartsUI::Menu_ptr& popup,
				    CORBA::Long id, CORBA::Long index );
  virtual void insertSeparator( CORBA::Long index );
  virtual void removeItem( CORBA::Long id );
  virtual void removeItemAt( CORBA::Long index );
  virtual void clear();
  virtual CORBA::Long accel( CORBA::Long id );
  virtual void setAccel( CORBA::Long key, CORBA::Long id );
  virtual char* text( CORBA::Long id );
  virtual OpenPartsUI::Pixmap* pixmap( CORBA::Long id );
  virtual void changeItemText( const char* text, CORBA::Long id );
  virtual void changeItemPixmap( const OpenPartsUI::Pixmap& pixmap, CORBA::Long id );
  virtual void changeItem( const OpenPartsUI::Pixmap& pixmap, const char* text,
			   CORBA::Long id );
  virtual CORBA::Boolean isItemEnabled( CORBA::Long id );
  virtual void setItemEnabled( CORBA::Long id, CORBA::Boolean enable );
  virtual CORBA::Boolean isItemChecked( CORBA::Long id );
  virtual void setItemChecked( CORBA::Long id, CORBA::Boolean check );
  virtual void updateItem( CORBA::Long id );
  virtual CORBA::Long indexOf( CORBA::Long id );
  virtual CORBA::Long idAt( CORBA::Long index );
  virtual void setId( CORBA::Long index, CORBA::Long id );
  virtual void setCheckable( CORBA::Boolean checkable );
  virtual CORBA::Boolean isCheckable();

  virtual void activated( CORBA::Long id );
  virtual void highlighted( CORBA::Long id );
  virtual void aboutToShow();
  
protected:
  OPMenu* m_pMenu;
  
  multimap<int,Qt2CORBAProxy*> m_mapProxies;
  multimap<CORBA::Long,OPMenu*> m_mapMenus;
};

class OPMenuIf : virtual public OPMenuDataIf,
		 virtual public OpenPartsUI::Menu_skel
{
public:
  OPMenuIf( OPMenu* );
};

class OPMenuBarIf : virtual public KOMBase,
		    virtual public OpenPartsUI::MenuBar_skel
{
public:
  OPMenuBarIf( OPMenuBar* );
  ~OPMenuBarIf();

  virtual void cleanUp();
  
  virtual CORBA::ULong count();
  virtual CORBA::Long insertItem( const char* text, CORBA::Object_ptr receiver, const char* member, CORBA::Long accel );
  virtual CORBA::Long insertItem2( const char* text, CORBA::Long id, CORBA::Long index );
  virtual CORBA::Long insertMenu( const char* text, OpenPartsUI::Menu_ptr& menu, CORBA::Long id, CORBA::Long index );
  virtual void insertSeparator( CORBA::Long index );
  virtual void removeItem( CORBA::Long id );
  virtual void removeItemAt( CORBA::Long index );
  virtual void clear();
  virtual CORBA::Long accel( CORBA::Long id );
  virtual void setAccel( CORBA::Long key, CORBA::Long id );
  virtual char* text( CORBA::Long id );
  virtual void changeItem( const char* text, CORBA::Long id );
  virtual void setItemChecked( CORBA::Long id, CORBA::Boolean flag );
  virtual void setItemEnabled( CORBA::Long id, CORBA::Boolean flag );
  virtual OpenPartsUI::Menu_ptr menuAt( CORBA::Long index );
  virtual OpenPartsUI::Menu_ptr menu( CORBA::Long id );
  virtual OpenPartsUI::Menu_ptr helpMenu();
  virtual void setHelpMenu( CORBA::Long _id );
  virtual OpenPartsUI::Menu_ptr fileMenu();
  virtual void setFileMenu( CORBA::Long _id );
  
  virtual void activated( CORBA::Long id );
  virtual void highlighted( CORBA::Long id );

protected:
  OPMenuBar* m_pMenuBar;

  multimap<int,Qt2CORBAProxy*> m_mapProxies;
};
#endif
