/*
  Author: Simon Hausmann <tronical@gmx.net>
*/

#include "opStatusBarIf.h"
#include "opUIUtils.h"

#include <string.h>
#include <assert.h>

#include <qstrlist.h>
#include <ktmainwindow.h>

OPStatusBarIf::OPStatusBarIf( OPStatusBar* _statusbar )
{
  m_pStatusBar = _statusbar;
  m_bVisible = true;
  
  SIGNAL_IMPL("pressed");
  SIGNAL_IMPL("released");
}

OPStatusBarIf::~OPStatusBarIf()
{
  cerr << "OPStatusBarIf::~OPStatusBarIf() " << (int)this << endl;
  cleanUp();
}

CORBA::Long OPStatusBarIf::insertItem( const char *text, CORBA::Long ID )
{
  return (CORBA::Long) (m_pStatusBar->insertItem( text, (int)ID ));
}

void OPStatusBarIf::removeItem( CORBA::Long ID )
{
  m_pStatusBar->removeItem( (int)ID );
}

void OPStatusBarIf::changeItem( const char *text, CORBA::Long ID )
{
  m_pStatusBar->changeItem( text, (int)ID );
}

void OPStatusBarIf::setInsertOrder( OpenPartsUI::StatusBar::InsertOrder order )
{
  if ( order == OpenPartsUI::StatusBar::LeftToRight )
     m_pStatusBar->setInsertOrder( KStatusBar::LeftToRight );
  else if ( order == OpenPartsUI::StatusBar::RightToLeft )
     m_pStatusBar->setInsertOrder( KStatusBar::RightToLeft );               
}

void OPStatusBarIf::setAlignment( CORBA::Long ID, OpenPartsUI::StatusBar::Alignment align )
{
  int a = 0;

  switch (align)
         {
	   case OpenPartsUI::StatusBar::AlignLeft: a = AlignLeft; break;
	   case OpenPartsUI::StatusBar::AlignRight: a = AlignRight; break;
	   case OpenPartsUI::StatusBar::AlignHCenter: a = AlignHCenter; break;
	   case OpenPartsUI::StatusBar::AlignTop: a = AlignTop; break;
	   case OpenPartsUI::StatusBar::AlignBottom: a = AlignBottom; break;
	   case OpenPartsUI::StatusBar::AlignVCenter: a = AlignVCenter; break;
	   case OpenPartsUI::StatusBar::AlignCenter: a = AlignCenter; break;
	 }

  m_pStatusBar->setAlignment( (int) ID, a );
}

void OPStatusBarIf::setHeight( CORBA::Long height )
{
  m_pStatusBar->setHeight( (int)height );
}

void OPStatusBarIf::setBorderWidth( CORBA::Long width )
{
  m_pStatusBar->setBorderWidth( (int)width );
}

void OPStatusBarIf::message( const char *text, CORBA::Long time )
{
  m_pStatusBar->message( text, (int)time );
}

void OPStatusBarIf::clear()
{
  m_pStatusBar->clear();
}

void OPStatusBarIf::pressed( CORBA::Long ID )
{
  SIGNAL_CALL1( "pressed", ID );
}

void OPStatusBarIf::released( CORBA::Long ID )
{
  SIGNAL_CALL1( "released", ID );
}

CORBA::Boolean OPStatusBarIf::enable( OpenPartsUI::BarStatus stat )
{
  KStatusBar::BarStatus s;
  
  switch ( stat )
         {
	   case OpenPartsUI::Toggle: s = KStatusBar::Toggle; break;
	   case OpenPartsUI::Show: s = KStatusBar::Show; break;
	   case OpenPartsUI::Hide: s = KStatusBar::Hide; break;
	 }

  m_bVisible = m_pStatusBar->enable(s);
	 
  return (CORBA::Boolean) m_bVisible;
}

void OPStatusBarIf::cleanUp()
{
  cerr << "void OPStatusBarIf::cleanUp() " << (int)this << endl;
}
