/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "pm_skeleton.h"
#include "pm_object.h"

#include <assert.h>

extern CORBA::TypeCode_ptr findTypeCode( int _id );

PyMicoSkeleton::PyMicoSkeleton( const char *_repoid, const CORBA::BOA::ReferenceData &_id )
{
  m_strRepoid = _repoid;
  
  CORBA::ImplementationDef_var _impl = _find_impl( _repoid, NULL );

  assert (!CORBA::is_nil (_impl));
  _create_ref (_id, CORBA::InterfaceDef::_nil(), _impl, _repoid );
}

PyMicoSkeleton::~PyMicoSkeleton()
{
  // TODO: cleanup python objects and typecodes
}

/* void* PyMicoSkeleton::_narrow_helper( const char *_repoid )
{
  if( m_strRepoid ==  _repoid )
    return (void *) this;
  return 0L;
} */

void PyMicoSkeleton::registerCallback( PyObject* _obj, const char* _func, CORBA::TypeCode_ptr _tc, PyObject* _list )
{
  Py_INCREF( _obj );

  Callback c;
  c.obj = _obj;
  c.func = _func;
  c.rettype = _tc;
  
  c.args = PyList_Size( _list );
  cerr << "We have " << c.args << " param to handle" << endl;
  
  for( int i = 0; i < c.args; i++ )
  {
    PyObject* tuple = PyList_GetItem( _list, i );
    assert( tuple != 0L );

    int inout;
    int typecodeid;
    PyObject *o1 = PyTuple_GetItem( tuple, 0 );
    PyObject *o2 = PyTuple_GetItem( tuple, 1 );
    assert( o1 != 0L && o2 != 0L );
    PyArg_Parse( o1, "i", &typecodeid );
    PyArg_Parse( o2, "i", &inout );

    CORBA::ArgModeFlags a;    
    if ( inout == 1 )
      a = CORBA::ARG_IN;
    else if ( inout == 2 )
      a = CORBA::ARG_OUT;
    else if ( inout == 4 )
      a = CORBA::ARG_INOUT;
    else
    {
      cerr << "Illegal arg mode " << inout << " in registration of method " << _func << "@" << m_strRepoid << endl;
      return;
    }
    
    CORBA::TypeCode_ptr tc = findTypeCode( typecodeid );
    if ( CORBA::is_nil( tc ) )
    {
      cerr << "Invalid typecodeid " << typecodeid << " in registration of method " << _func << "@" << m_strRepoid << endl;
      return;
    }
    
    c.inout.push_back( a );
    c.types.push_back( tc );
  }
  
  m_mapCallbacks[ _func ] = c;
}

void PyMicoSkeleton::invoke( CORBA::ServerRequest_ptr _req, CORBA::Environment & )
{
  // m_pReq = _req;
  
  cerr << "I got called for " << _req->op_name() << endl;
  
  map<string,Callback>::iterator it = m_mapCallbacks.find( _req->op_name() );
  if ( it == m_mapCallbacks.end() )
  {
    cerr << "ERROR: Function of name " << _req->op_name() << " is not registered in class " << m_strRepoid << endl;
    return;
  }
  
  cerr << "Proceeding" << endl;
  
  int inargs = 0;
  int outargs = 0;
  
  CORBA::NVList* args = new CORBA::NVList( it->second.args );
  list<CORBA::ArgModeFlags>::iterator it1 = it->second.inout.begin();
  list<CORBA::TypeCode_ptr>::iterator it2 = it->second.types.begin();
  for( int i = 0; i < it->second.args; i++ )
  {
    if ( *it1 == CORBA::ARG_IN || *it1 == CORBA::ARG_INOUT )
      inargs++;
    if ( *it1 == CORBA::ARG_INOUT || *it1 == CORBA::ARG_OUT )
      outargs++;
    
    args->add( *it1 );
    args->item( i )->value()->type( *it2 );

    it1++;
    it2++;
  }

  if (!_req->params( args ))
      return;

  PyObject* tuple = PyTuple_New( inargs );

  it1 = it->second.inout.begin();
  it2 = it->second.types.begin();
  for( int a = 0; a < it->second.args; a++ )
  {
    if ( *it1 == CORBA::ARG_IN || *it1 == CORBA::ARG_INOUT )
    {
      PyObject* x = parseResult( *( args->item( a )->value() ), *it2 );
      // TODO: Raise a system exception here
      if ( x == 0L )
	assert( 0 );
      PyTuple_SetItem( tuple, a, x );
    }

    it1++;
    it2++;
  }
  
  cerr << "Calling" << endl;
  PyObject* pmeth = PyObject_GetAttrString( it->second.obj, (char*)_req->op_name() );
  if ( pmeth == 0L )
  {
    cerr << "No such method " << _req->op_name() << endl;
    return;
  }
  PyObject* obj = PyEval_CallObject( pmeth, tuple );

  cerr << "Called" << endl;
  
  // Error in python code ?
  if ( obj == 0L )
  {
    cerr << "ERROR: Python: Could not exec" << endl;
    PyErr_PrintEx( 0 );
    PyErr_Clear();
  }
  // Try to pack the return value
  else
  {
    cerr << "PACKING return values" << endl;
    // Do not pack void
    if ( ( it->second.rettype != CORBA::_tc_void && outargs == 0 ) ||
	 ( it->second.rettype == CORBA::_tc_void && outargs == 1 ) )
    {
      cerr << "PACKING single" << endl;
      CORBA::Any *_any_res = new CORBA::Any;
      if ( !parseResult( *_any_res, obj, it->second.rettype ) )
      {
	cerr << "ERROR: Could not parse result of function. Expected one result parameter" << endl;
	assert( 0 );
      }
      _req->result( _any_res );
    }
    else if ( outargs > 0 )
    {
      cerr << "PACKING multiple" << endl;
      int expected = outargs;
      if ( it->second.rettype != CORBA::_tc_void )
	expected++;
      int size = PyTuple_Size( obj );
      if ( size != expected )
      {
	cerr << "ERROR: Expected " << expected << " return parameters, but got " << size << endl;
	assert( 0 );
      }
      int pos = 0;
      if ( it->second.rettype != CORBA::_tc_void )
      {
	PyObject* a = PyTuple_GetItem( obj, pos++ );
	assert( a != 0L );
	CORBA::Any *_any_res = new CORBA::Any;
	if ( !parseResult( *_any_res, obj, it->second.rettype ) )
	{
	  cerr << "ERROR: Could not parse result of function." << endl;    
	  assert( 0 );
	}
	_req->result( _any_res );
      }
      it1 = it->second.inout.begin();
      it2 = it->second.types.begin();
      cerr << "size=" << size << "  pos=" << pos << " args=" << it->second.args << endl;
      for( int i = 0; i < it->second.args; i++ )
      {
	cerr << "Checking " << i << endl;
	if ( *it1 == CORBA::ARG_OUT || *it1 == CORBA::ARG_INOUT )
	{
	  CORBA::Any any;
	  any.type( (*it2) );
	  PyObject* a = PyTuple_GetItem( obj, pos++ );
	  assert( a != 0L );
	  if ( !parseResult( any, a, (*it2) ) )
	  {
	    cerr << "ERROR: Could not parse out/inout parameter." << endl;    
	    assert( 0 );
	  }
	  // Py_DECREF( a );
	  cerr << "PACKING arg " << i << endl;
	  *(args->item( i )->value()) = any;
	}
	it1++;
	it2++;
      }
    }
    else
      cerr << "PACKING: Nothing" << endl;
  }
  
  /* Py_DECREF( pmeth );
  
  if ( obj )
    Py_DECREF( obj ); */

  cerr << "Return from server" << endl;
}

void PyMicoSkeleton::raiseException( const char *_repoid, CORBA::Any& _any, CORBA::CompletionStatus _cs, CORBA::ULong _minor )
{
  /* if( CORBA::SystemException::_is_sysex( _repoid ) )
  {
    m_pReq->exception( CORBA::SystemException::_create_sysex( _repoid, _minor, _cs ) );
    return;
  }
  
  CORBA::UnknownUserException *ex = new CORBA::UnknownUserException( new CORBA::Any( _any ) );
  m_pReq->exception( ex ); */
}


