/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "main.h"

#include <komApplication.h>

#include <qcolor.h>

#include <iostream>

Core::Core()
{
  cout << "+Core" << endl;
}

Core::~Core()
{
  cout << "-Core" << endl;
}

bool Core::event( const char* _event, const CORBA::Any& _value )
{
  EVENT_MAPPER( _event, _value );

  MAPPING( Events::eventChangeRGBColor, Events::typeChangeRGBColor, mappingColor );
  MAPPING_STRING( Events::eventOpenURL, mappingOpenURL );

  END_EVENT_MAPPER;
  
  return false;
}

bool Core::mappingOpenURL( const char *_url )
{
  cout << "Core: OpenURL '" << _url << "'" << endl;

  return true;
}

bool Core::mappingColor( Events::typeChangeRGBColor& _color )
{
  cout << "Core: Changing to r=" << _color.red << " g=" << _color.green 
       << " b=" << _color.blue << endl;

  return true;
}

Filter1::Filter1( Core* _core )
{
  cout << "+Filter1" << endl;

  m_pCore = _core;
  
  KOM::EventTypeSeq seq;
  seq.length( 1 );
  seq[0] = CORBA::string_dup( Events::eventChangeHSVColor );
  _core->installFilter( this, "eventFilter", seq, KOM::Base::FM_WRITE );
}

Filter1::~Filter1()
{
  cout << "-Filter1" << endl;
}

CORBA::Boolean Filter1::eventFilter( KOM::Base_ptr obj, const char* type,
				     const CORBA::Any& value )
{
  EVENT_MAPPER( type, value );

  MAPPING( Events::eventChangeHSVColor, Events::typeChangeHSVColor, mappingColor );

  END_EVENT_MAPPER;
  
  return false;
}

bool Filter1::mappingColor( Events::HSVColor& _color )
{
  cout << "Filter1: Converting HSV -> RGB" << endl;
  
  Events::RGBColor rgb;
  
  QColor c( _color.h, _color.s, _color.v, QColor::Hsv );
  rgb.red = c.red();
  rgb.green = c.green();
  rgb.blue = c.blue();

  EMIT_EVENT( m_pCore, Events::eventChangeRGBColor, rgb );
  
  return true;
}

Filter2::Filter2( Core* _core )
{
  cout << "+Filter2" << endl;

  KOM::EventTypeSeq seq;
  seq.length( 1 );
  seq[0] = CORBA::string_dup( Events::eventOpenURL );
  _core->installFilter( this, "eventFilter", seq, KOM::Base::FM_IMPLEMENT );
}

Filter2::~Filter2()
{
  cout << "-Filter2" << endl;
}

CORBA::Boolean Filter2::eventFilter( KOM::Base_ptr obj, const char* type,
				     const CORBA::Any& value )
{
  EVENT_MAPPER( type, value );

  MAPPING_STRING( Events::eventOpenURL, mappingOpenURL );

  END_EVENT_MAPPER;
  
  return false;
}

bool Filter2::mappingOpenURL( const char *_url )
{
  if ( strstr( _url, "porn" ) != 0L )
  {
    cout << "Filter2: You should not look at such pages! Bad boy!" << endl;
    return true;
  }
  
  return false;
}

Filter3::Filter3( Core* _core )
{
  cout << "+Filter3" << endl;

  KOM::EventTypeSeq seq;
  seq.length( 1 );
  seq[0] = CORBA::string_dup( Events::eventOpenURL );
  _core->installFilter( this, "eventFilter", seq, KOM::Base::FM_READ );
}

Filter3::~Filter3()
{
  cout << "-Filter3" << endl;
}

CORBA::Boolean Filter3::eventFilter( KOM::Base_ptr obj, const char* type,
				     const CORBA::Any& value )
{
  EVENT_MAPPER( type, value );

  MAPPING_STRING( Events::eventOpenURL, mappingOpenURL );

  END_EVENT_MAPPER;
  
  return false;
}

bool Filter3::mappingOpenURL( const char *_url )
{
  history.push_back( _url );
  
  // Print history
  list<string>::iterator it = history.begin();
  for( ; it != history.end(); ++it )
    cout << "History: " << it->c_str() << endl;
  
  return false;
}

int main( int argc, char **argv )
{
  KOMApplication app( argc, argv );

  /***************
   * Create the component and install the filters
   ***************/
  Core *core = new Core;

  KOM::Base_var f1 = KOM::Base::_duplicate( new Filter1( core ) );
  KOM::Base_var f2 = KOM::Base::_duplicate( new Filter2( core ) );
  KOM::Base_var f3 = KOM::Base::_duplicate( new Filter3( core ) );
  
  // Describe filters
  KOM::Base::EventFilterSeq_var seq = core->describeEventFilters();
  for( CORBA::ULong l = 0; l < seq->length(); ++l )
  {
    cout << "Events:" << endl;
    for( CORBA::ULong k = 0; k < (*seq)[l].events.length(); ++k )
      cout << "  " << (*seq)[l].events[k].in() << endl;
    cout << "Function: " << (*seq)[l].function.in() << endl;
  }
  seq->length( 0 );
  
  cout << "1 ----------------------------------------------" << endl;
  
  /***************
   * Send some events around
   ***************/

  EMIT_EVENT_STRING( core, Events::eventOpenURL, "http://www.kde.org" );
  // This one is filtered by Filter2
  EMIT_EVENT_STRING( core, Events::eventOpenURL, "http://www.porn.com" );
  // You will notice that the Filter3 will only have 2
  // entries in its history, since the above URL was filtered
  // before it reached Filter3.
  EMIT_EVENT_STRING( core, Events::eventOpenURL, "http://koffice.kde.org" );

  // Lets see how Filter1 converts colors
  Events::HSVColor hsv;
  hsv.h = 90;
  hsv.v = 128;
  hsv.s = 128;
  EMIT_EVENT( core, Events::eventChangeHSVColor, hsv );
  
  cout << "2 ----------------------------------------------" << endl;

  /**************
   * Uninstall Filter2
   **************/
  core->uninstallFilter( f2 );
  f2->destroy();
  f2 = 0L;
  
  // Describe filters
  seq = core->describeEventFilters();
  for( CORBA::ULong l = 0; l < seq->length(); ++l )
  {
    cout << "Events:" << endl;
    for( CORBA::ULong k = 0; k < (*seq)[l].events.length(); ++k )
      cout << "  " << (*seq)[l].events[k].in() << endl;
    cout << "Function: " << (*seq)[l].function.in() << endl;
  }
  seq->length( 0 );

  // Now it is no longer filtered
  EMIT_EVENT_STRING( core, Events::eventOpenURL, "http://www.porn.com" );

  cout << "3 ----------------------------------------------" << endl;

  /**************
   * Destroy the component
   * and the remaining filters
   **************/
  f1->destroy();
  f1 = 0L;
  
  CORBA::release( core );
  
  f3->destroy();
  f3 = 0L;
  
  return 0;
}
