
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <sys/mman.h>

#include <linux/mman.h>

#include "pcmem.h"

int main(int argc, char * *argv)
{
   struct mm_permit permit;
   int memfd, start, end, err;
   
   printf("\n");
   
   if ((memfd = open("/dev/pcmem", O_RDWR)) == -1) {
      printf("Failed to open /dev/pcmem, error %s\n", strerror(errno));
      return(1);
   }
   
   if (getuid() == 0) printf("Note: You are running as root, this will give you permission to everything.\n");
   
   start = 0x1000000;
   end   = 0x2000000;
   printf("\nAttempting to access range $%x - $%x to mimic a memory attack.\n", start, end);
   if ((mmap((void *)0, end-start, PROT_READ|PROT_WRITE|PROT_EXEC, MAP_PRIVATE, memfd, start)) == (void *)-1) {
      printf("  ...Attempt failed (this is correct if you are not privileged).\n");
      printf("     Failure: %s\n", strerror(errno));
   }
   else printf("  ...Attempt succeeded (if you are privileged, this is ok).\n");

   permit.start = 0xA0000;
   permit.end   = 0x200000;
   permit.mode  = S_IRWXU | S_IRWXG | S_IRWXO;
   printf("\nAttempting to mark range $%x - $%x as globally accessible.\n", permit.start, permit.end);
   
   if ((ioctl(memfd, MMIO_PERMIT_RANGE, &permit)) == -1) {
      if (errno == EPERM) printf("  ...Failure: You do not have permission to do this (good :-)\n");
      else printf("  ...Failure: %s\n", strerror(errno));
   }
   else {
      if (!getuid()) printf("  ...Success (you are root, this is good...)\n");
      else printf("  ...Success (YOU ARE NOT ROOT: HOW DO YOU HAVE PERMISSIONS?)\n");
   }

   printf("\nNow attempting to access range $%x - $%x\n", permit.start, permit.end);
   if ((mmap((void *)permit.start, permit.end-permit.start, PROT_READ|PROT_WRITE, MAP_PRIVATE, memfd, permit.start)) == (void *)-1) {
      printf("  ...Failure: %s\n  (this is correct if you have never run this exe as root).\n", strerror(errno));
   }
   else printf("  ...Attempt succeeded (correct assuming you have run this program as root before).\n");

   printf("\n");
   close(memfd);
   return(0);
}
