//`timescale 1 ns / 10 ps
 
module lcd_text_driver(clock, text, text_strobe,
	lcd_rst,
	lcd_read_data,
	lcd_e, lcd_rw, lcd_rs,
	lcd_write_data, lcd_dir, lcd_busy, test);


input 	clock;
input 	[7:0] text;
input 	text_strobe;
input 	lcd_rst;
input 	[3:0] lcd_read_data;
output 	lcd_e, lcd_rw, lcd_rs;
output 	[3:0] lcd_write_data;
output 	lcd_dir;
output	lcd_busy;
output	test;

reg lcd_e, lcd_rw, lcd_rs, lcd_dir;
reg [3:0] lcd_write_data;
reg lcd_busy;
wire test;
//wire [3:0] lcd_read_data;

reg busy_flag;
reg [7:0] fstate;
reg [20:0] state;
reg lcd_initialized;
reg us_clock;
reg print_flag;
reg printing_flag;
reg [7:0] print_data;
reg [6:0] lcd_display_ram_address;
reg line2;

initial
begin
fstate = 0;
lcd_initialized = 0;
lcd_e = 0;
lcd_rw = 0;
lcd_rs = 0;
lcd_dir = 0;
line2 = 0;
end

// generate micro second clock
always @(posedge clock)
//always @(clock)
begin
fstate = fstate + 1;
if(fstate >= 25)
	begin
	fstate = 0;
	us_clock = !us_clock;
	end 
end // always

//reg [7:0] busy_reg;
always @(posedge us_clock)
begin
if(lcd_rst)
	begin
	state = 0;
	lcd_initialized = 0;
	lcd_e = 0;
	lcd_rw = 0;
	lcd_rs = 0;
	lcd_dir = 0;
	line2 = 0;
	end
else
	begin
	if(! lcd_initialized)
		begin
		state = state + 1;
		case (state)
			// wait > 30 ms after power up
			// initial state control lines
			30500:
				begin
				lcd_e = 0;
				lcd_rw = 0;
				lcd_rs = 0;
				lcd_dir = 0;
				end
			// function set
			// select 4 bit mode
			31000: lcd_write_data = 4'b0010; // 0010xxxx
			32000: lcd_e = 1;
			33000: lcd_e = 0;
			34000: lcd_write_data = 4'b0010; // 0010xxxx
			35000: lcd_e = 1;
			36000: lcd_e = 0;
			37000: lcd_write_data = 4'b1100; // 11xxxxxx 2 line, display on
			38000: lcd_e = 1;
			39000: lcd_e = 0;

			// wait > 39 us
			// display on / off
			40000: lcd_write_data = 4'b0000; // 0000xxxx
			41000: lcd_e = 1;
			42000: lcd_e = 0;
			43000: lcd_write_data = 4'b1111; // 1111xxxx 1, dso on, cu on, cu blink
			44000: lcd_e = 1;
			45000: lcd_e = 0;

			// wait > 39 us
			// display clear
			46000: lcd_write_data = 4'b0000; // 0000xxxx
			47000: lcd_e = 1;
			48000: lcd_e = 0;
			49000: lcd_write_data = 4'b0001; // 0001xxxx display clear
			50000: lcd_e = 1;
			51000: lcd_e = 0;

			// wait > 1.53 ms
			// display entry mode
			53000: lcd_write_data = 4'b0000; // 0000xxxx
			54000: lcd_e = 1;
			55000: lcd_e = 0;
			// 0111xxxx 1, incr. mode , entire shift off
//			56000: lcd_write_data = 4'b0111;

			// NORMAL cursor moves right with chars
			56000: lcd_write_data = 4'b0110;

			// cu remains left, chars move right
//			56000: lcd_write_data = 4'b0101;

			// cu moves left with chars
//			56000: lcd_write_data = 4'b0100;

			57000: lcd_e = 1;
			58000: lcd_e = 0;
			// lcd now initialized
			59000:
				begin
				lcd_initialized = 1;
				end
			endcase // state
		end // if ! lcd_initialized
	else // lcd initialized
		begin
		if(print_flag)
			begin
			state = state + 1;
			printing_flag = 1;
			// test if control character
			if(print_data < 32)
				begin
				if(print_data == 10) // LF, control J, next line
					begin
					// set DDRAM address 00h (line 1) or 40h (line 2)
					case(state)
					190030:
						begin
						// 1 ac6 ac5 ac4 ac3 ac2 ac1 ac0
						if(! line2) lcd_display_ram_address = 7'b100_0000;
						else lcd_display_ram_address = 7'b000_0000;
						line2 = !line2;
						lcd_write_data [3] = 1;
						lcd_write_data [2:0] = lcd_display_ram_address [6:4];
						end
					190040: lcd_e = 1;
					190050: lcd_e = 0;
					// low nibble of 00h or 40h
					190060: lcd_write_data [3:0] = lcd_display_ram_address [3:0];
					190070: lcd_e = 1;
					190080: lcd_e = 0;
					190090:
						begin
						printing_flag = 0; 
						state = 59900; // before busy flag check
						end
					endcase
					end // end LF
					else if(print_data == 12) // FF
					begin
					// control character handling
					// so far only cls = dec 12 = ctrl L = formfeed
					// display clear
					case(state)
					190000: lcd_write_data = 4'b0000; // 0000xxxx
					191000: lcd_e = 1;
					192000: lcd_e = 0;
					193000: lcd_write_data = 4'b0001; // 0001xxxx display clear
					194000: lcd_e = 1;
					195000: lcd_e = 0;
					196000:
						begin
						printing_flag = 0; 
						state = 59900; // before busy flag check
						end
					endcase
					end // end FF
					else // not implemented control characters
					begin
					case(state)
						196000:
						begin
						printing_flag = 0; 
						state = 59900; // before busy flag check
						end
					endcase
					end // end not implemented contorl characters
				end // control char
			else // not a control char
				begin
				case(state)
				// get busy flag (bit 3) and higher 3 address bits			
				60000: lcd_dir = 1; // data direction from LCD
				60001: lcd_rs = 0; // select command reg
				60002: lcd_rw = 1; // data read mode
				60003: lcd_e = 1; // data read on bus
				60004: busy_flag = lcd_read_data[3];
				60005: lcd_e = 0; // LCD tristate
				// get lower 4 address bits
				60006: lcd_e = 1; // data read on bus
				// dummy read
				60007: lcd_e = 0; // LCD tristate
				60008: lcd_rw = 0; // date write mode
				60009: lcd_rs = 1; // select data reg
				60010: lcd_dir = 0; // data direction to LCD
				// loop if busy
				60011: if(busy_flag) state = 59995;
	
				// print character
				60012: lcd_rs = 1;
				// high nibble
				60013: lcd_write_data [3:0] = print_data [7:4];
				60014: lcd_e = 1;
				60015: lcd_e = 0;
				// low nibble
				60016: lcd_write_data [3:0] = print_data [3:0];
				60017: lcd_e = 1;
				60018: lcd_e = 0;
				60019: lcd_rs = 0;
				// character has now been printed
				60020:
					begin
					printing_flag = 0; 
					state = 59995; // before busy flag check
					end
				endcase
				end // if not control char
			end // if print_flag
		end // if lcd_initialized
	end // if ! reset
end // always


always @(posedge clock)
begin
if(text_strobe)
	begin
	lcd_busy = 1;
	print_data [7:0] = text [7:0];
	print_flag = 1;
	end
else
	begin
	if(! printing_flag)
		begin
		print_flag = 0;
		lcd_busy = 0;
		end // if ! printing_flag
	end
end // always


//assign test = us_clock; //us_clock; //lcd_initialized;
assign test = printing_flag; //print_flag; //printing_flag; //text_strobe;

endmodule





