module top(clock,
				button,
				tx_data, rx_data, dsr_out, cts_out, rts_in,
				led,
				lcd_e, lcd_rw, lcd_rs, lcd_data,
				ethernet,
				test_out0, test_out1, test_out2, test_out3);

	input clock;
	input button;
	input rx_data, rts_in;
	output led;
	output lcd_e, lcd_rw, lcd_rs;
	inout [3:0] lcd_data;
	output tx_data, dsr_out, cts_out;
	input ethernet;
	output test_out0, test_out1, test_out2, test_out3;

wire real_clock;
wire button_line;
wire reset_line;
wire rx_data;
wire rts_in;
wire tx_data;
wire dsr_out;
wire cts_out;
wire lcd_enable, lcd_read_write, lcd_register_select;
wire [3:0] lcd_write_data;
wire [3:0] lcd_read_data;
wire lcd_direction;
wire ethernet_in;
wire test_out_wire0, test_out_wire1, test_out_wire2, test_out_wire3;


// test high frequency clock
wire clock2x, clock4x, lock_signal;

// button io
BUFG U1 (.I(button), .O(button_line) );

// clock io
IBUFG clkpad0 (.I(clock), .O(real_clock));

// clock multiplier
//dll_standard d11(
// .CLKIN(real_clock), .RESET(reset_line), .CLK2X(clock2x), .CLK4X(clock4x), .LOCKED(lock_signal) );


wire locked2x;
// clock * 2
CLKDLL dll2x (.CLKIN(real_clock), .CLKFB(test_out_wire1), .RST(1'b0),
	.CLK2X(test_out_wire1), .LOCKED(locked2x) );

//	.CLKDV(), .CLK0(), .CLK90(), .CLK180(), .CLK270(),  


//wire clk2x;
//BUFG clk2xg0 (.I(test_out_wire1), .O(clk2x));


wire locked2x_delay;
SRL16 rstsrl0 (.D(locked2x), .CLK(test_out_wire1), .Q(locked2x_delay), 
               .A3(1'b1), .A2(1'b1), .A1(1'b1), .A0(1'b1));

wire reset4x;
assign reset4x = !locked2x_delay;
wire locked4x;
// clock * 4
CLKDLL dll4x (.CLKIN(test_out_wire1), .CLKFB(test_out_wire3), .RST(reset4x),
	.CLK2X(test_out_wire3), .LOCKED(locked4x) );

// .CLKDV() .CLK0(), .CLK90(), .CLK180(), .CLK270(),  

/*
wire locked4x_delay;
SRL16 rstsrl1 (.D(locked4x), .CLK(test_out_wire3), .Q(locked4x_delay), 
               .A3(1'b1), .A2(1'b1), .A1(1'b1), .A0(1'b1) );


wire reset8x;
assign reset8x = !locked4x_delay;


wire locked8x;
wire clock_400Mhz;
// clock * 8
CLKDLL dll8x (.CLKIN(test_out_wire3), .CLKFB(clock_400Mhz), .RST(reset8x),
	.CLK2X(clock_400Mhz), .LOCKED(locked8x) );
	
//.CLKDV(), .CLK0(), .CLK90(), .CLK180(), .CLK270(),  

*/

                           

// test pins
OBUF tob0 (.I(test_out_wire0), .O(test_out0) );
OBUF tob1 (.I(test_out_wire1), .O(test_out1) );
OBUF tob2 (.I(test_out_wire2), .O(test_out2) );
OBUF tob3 (.I(test_out_wire3), .O(test_out3) );

// lcd io buffers
OBUF lcdb0 (.I(lcd_enable), .O(lcd_e));
OBUF lcdb1 (.I(lcd_read_write), .O(lcd_rw));
OBUF lcdb2 (.I(lcd_register_select), .O(lcd_rs));
IOBUF lcdb4 (.I(lcd_write_data[0]), .T(lcd_direction),
	.O(lcd_read_data[0]), .IO(lcd_data[0]));
IOBUF lcdb5 (.I(lcd_write_data[1]), .T(lcd_direction),
	.O(lcd_read_data[1]), .IO(lcd_data[1]));
IOBUF lcdb6 (.I(lcd_write_data[2]), .T(lcd_direction),
	.O(lcd_read_data[2]), .IO(lcd_data[2]));
IOBUF lcdb7 (.I(lcd_write_data[3]), .T(lcd_direction),
	.O(lcd_read_data[3]), .IO(lcd_data[3]));

// serial port buffers
OBUF tua1 (.I(tx_data_b), .O(tx_data) );
OBUF tua2 (.I(dsr_out_b), .O(dsr_out) );
OBUF tua3 (.I(cts_out_b), .O(cts_out) );
IBUF tua4 (.I(rx_data), .O(rx_data_b) );
IBUF tua5 (.I(rts_in), .O(rts_in_b) );

// from ethernet diff amp
IBUF ss1_eth(.I(ethernet), .O(ethernet_in) );


wire lcd_busy;

// reset generator
reg a_reset;
reg [7:0] a_reset_state;
always @(posedge real_clock)
begin
case(a_reset_state)
	0:
		begin
		a_reset = 1;
		a_reset_state = 1;
		end
	255:
		begin
		a_reset = 0;
		end
	default:
		begin
		a_reset_state = a_reset_state + 1;
		end
	endcase
end // always

// reset
assign reset_line = button_line;

reg [7:0] text;
reg text_strobe;
wire lcd_test_wire;
wire rx_ready, tx_empty;
wire [7:0] rx_par_data;
reg rx_strobe;

rx_uart rxu0(.clock(real_clock), .divider(16'd325),
.rx_serial_data(rx_data_b),
.rx_strobe(rx_strobe), .rx_data_out(rx_par_data),
.rx_available(rx_ready) );
//.test1(test_out_wire0), .test2(test_out_wire1));

reg tx_start;
reg tx_strobe;
reg [10:0] tx_strobe_count;
reg tx_strobe_end;

always @(posedge real_clock)
begin
if(rx_ready == 1)
	begin
	rx_strobe = 1;
	if(tx_start == 0)
		begin
		tx_start = 1;
		tx_strobe = 1;
		end
	end
else
	begin
	rx_strobe = 0;
	tx_start = 0;
	end

if(tx_strobe_end)
	begin
	tx_strobe = 0;
	end
end // always


always @(posedge real_clock)
begin
// strobe high for 2 clock or so
if(tx_start)
	begin
	tx_strobe_count = tx_strobe_count + 1;
	if(tx_strobe_count == 3)
		begin
		tx_strobe_end = 1;
		end
	end
else
	begin
	tx_strobe_count = 0;
	tx_strobe_end = 0;
	end
end // always

// tx uart

/*
tx_uart txua0(.clock(real_clock),
.data(rx_par_data), .data_strobe(rx_ready),
.tx_data(tx_data_b), .cts_out(cts_out_b), .dsr_out(dsr_out_b),
.tx_empty(tx_empty) );
*/

/*
lcd_text_driver lcd_text_driver(
	.clock(real_clock),
	.text(rx_par_data), .text_strobe(rx_ready),
	.lcd_rst(button_line), //1'b0), 
	.lcd_e(lcd_enable), .lcd_rw(lcd_read_write),
	.lcd_rs(lcd_register_select),
	.lcd_read_data(lcd_read_data[3:0]),
	.lcd_write_data(lcd_write_data [3:0]),
	.lcd_dir(lcd_direction), .lcd_busy(lcd_busy),
	.test(lcd_test_wire));
*/



// counter gating
// measure real_color clock
// 1 second symmetrical gate pulse


reg [31:0] one_sec_cnt;
reg counter_gate;
reg latch_pulse;
reg lcd_trigger;
reg ccounter_reset;
wire bcd_conversion_ready;
wire [38:0] bcd_data;

always @(posedge real_clock)
begin
	if(reset_line)
		begin
			one_sec_cnt = 0;
			counter_gate = 0;
			latch_pulse = 0;
			ccounter_reset = 0;
		end
	else
		begin
			if(one_sec_cnt == 49999999) counter_gate = 0;
			if(one_sec_cnt == 50000010) latch_pulse = 1;			
			if(one_sec_cnt == 50000020) latch_pulse = 0;			
			if(one_sec_cnt == 50000030) lcd_trigger = 1;
			if(one_sec_cnt == 50000040) lcd_trigger = 0;
			if(one_sec_cnt == 50000050) ccounter_reset = 1;
			if(one_sec_cnt == 50000060) ccounter_reset = 0;
			if(one_sec_cnt == 50000070)
				begin
					one_sec_cnt = 0;
					counter_gate = 1;
				end 	
			else
				begin
					one_sec_cnt = one_sec_cnt + 1;
				end
		end
end // always 


reg [31:0] ccounter;
reg [31:0] counter_data;

// this should use the input signal whos frequency is to be measured as clock.
always @(posedge ethernet_in)		// External
//always @(posedge real_clock)		//  50 MHz
//always @(posedge test_out_wire1)	// 100 MHz
//always @(posedge test_out_wire3)	// 200 MHz
//always @(posedge clock_400Mhz)	// 400 MHz
begin
if(reset_line)
	begin
		ccounter = 0;
		counter_data = 0;
	end
else
	begin
		if(latch_pulse) counter_data = ccounter;
		if(counter_gate) ccounter = ccounter + 1;
		if(ccounter_reset) ccounter = 0;
	end

end // always


binary_to_bcd b2bcd0(
.clk_i(real_clock), .ce_i(1'b1), .rst_i(reset_line), .start_i(lcd_trigger),
.dat_binary_i(counter_data), .dat_bcd_o(bcd_data),
.done_o(bcd_conversion_ready) ); 


reg lcd_strobe;
reg [25:0] steps;
reg [7:0] lcd_char;

always @(posedge real_clock)
begin
if(! bcd_conversion_ready)
	begin
		lcd_strobe = 0;
		lcd_char [7:0] = 8'd0;
		steps = 0;
	end // reset
else
	begin
	case(steps)
		0:
			begin
			lcd_strobe = 0;
			steps = 1;
			end
		1000:
			begin
			lcd_char [7:0] = 12; // CLS, formfeed and LF only one implemented in lcd driver
			steps = steps + 1;
			end
		2000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		3000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		4000:
			begin
			if(!lcd_busy && tx_empty) steps = steps + 1;
			end

		5000:
			begin
			lcd_char [7:0] = bcd_data[35:32] + 48; 
			steps = steps + 1;
			end
		6000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		7000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		8000:
			begin
			if(!lcd_busy && tx_empty) steps = steps + 1;
			end

		9000:
			begin
			lcd_char [7:0] = bcd_data[31:28] + 48; 
			steps = steps + 1;
			end
		10000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		11000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		12000:
			begin
			if(!lcd_busy && tx_empty) steps = steps + 1;
			end

		13000:
			begin
			lcd_char [7:0] = bcd_data[27:24] + 48; 
			steps = steps + 1;
			end
		14000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		15000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		16000:
			begin
			if(!lcd_busy && tx_empty) steps = steps + 1;
			end

		17000:
			begin
			lcd_char [7:0] = bcd_data[23:20] + 48; 
			steps = steps + 1;
			end
		18000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		19000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		20000:
			begin
			if(!lcd_busy && tx_empty) steps = steps + 1;
			end

		21000:
			begin
			lcd_char [7:0] = bcd_data[19:16] + 48; 
			steps = steps + 1;
			end
		22000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		23000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		24000:
			begin
			if(!lcd_busy && tx_empty) steps = steps + 1;
			end

		25000:
			begin
			lcd_char [7:0] = bcd_data[15:12] + 48; 
			steps = steps + 1;
			end
		26000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		27000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		28000:
			begin
			if(!lcd_busy && tx_empty) steps = steps + 1;
			end

		29000:
			begin
			lcd_char [7:0] = bcd_data[11:8] + 48;
			steps = steps + 1;
			end
		30000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		31000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		32000:
			begin
			if(!lcd_busy && tx_empty) steps = steps + 1;
			end

		33000:
			begin
			lcd_char [7:0] = bcd_data[7:4] + 48;
			steps = steps + 1;
			end
		34000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		35000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		36000:
			begin
			if(!lcd_busy && tx_empty) steps = steps + 1;
			end

		37000:
			begin
			lcd_char [7:0] = bcd_data[3:0] + 48;
			steps = steps + 1;
			end
		38000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		39000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		40000:
			begin
			if(!lcd_busy && tx_empty) steps = steps + 1;
			end
// say Hz
		41000:
			begin
			lcd_char [7:0] = 72;// H
			steps = steps + 1;
			end
		42000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		43000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		44000:
			begin
			if(!lcd_busy && tx_empty) steps = steps + 1;
			end

		45000:
			begin
			lcd_char [7:0] = 122; // z
			steps = steps + 1;
			end
		46000:
			begin
			lcd_strobe = 1;		
			steps = steps + 1;
			end
		47000:
			begin
			lcd_strobe = 0;
			steps = steps + 1;
			end
		48000:
			begin
//			STOP HERE			
//			if(!lcd_busy) steps = steps + 1;
			end

		default:
			begin
			steps = steps + 1;
			end
		endcase
	end // if bcd_conversion_ready 
end // always 


`define USE_LCD
`ifdef USE_LCD
lcd_text_driver lcd_text_driver(
	.clock(real_clock),
	.text(lcd_char), .text_strobe(lcd_strobe),
	.lcd_rst(button_line), //1'b0), 
	.lcd_e(lcd_enable), .lcd_rw(lcd_read_write),
	.lcd_rs(lcd_register_select),
	.lcd_read_data(lcd_read_data[3:0]),
	.lcd_write_data(lcd_write_data [3:0]),
	.lcd_dir(lcd_direction), .lcd_busy(lcd_busy),
	.test(lcd_test_wire));
`else
	assign lcd_busy = 1'b0;
`endif 


// convert FF for LCD to CR for serial port 
reg [7:0] tx_char;
always @(posedge real_clock)
begin
if(lcd_char == 12) tx_char = 13;
else tx_char = lcd_char;
end // always


tx_uart txua0(.clock(real_clock),
.data(tx_char), .data_strobe(lcd_strobe),
.tx_data(tx_data_b), .cts_out(cts_out_b), .dsr_out(dsr_out_b),
.tx_empty(tx_empty) );






//assign test_out_wire0 = clock2x; //tx_strobe;
//assign test_out_wire1 = lcd_strobe;
//assign test_out_wire2 = cd_test_wire;
//assign test_out_wire3 = lcd_busy;

assign led = counter_gate; //bcd_conversion_ready;

endmodule
 

